/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.funqy.knative.events;

import io.quarkus.funqy.knative.events.CloudEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractCloudEvent<T>
implements CloudEvent<T> {
    private static final Pattern VERSION_REGEX = Pattern.compile("^(\\d+)\\.(\\d+)$");
    private boolean isMajorParsed;
    private int majorSpecVersion;

    public String toString() {
        return "CloudEvent{specVersion='" + this.specVersion() + '\'' + ", id='" + this.id() + '\'' + ", type='" + this.type() + '\'' + ", source='" + this.source() + '\'' + ", subject='" + this.subject() + '\'' + ", time=" + this.time() + ", extensions=" + this.extensions() + ", dataSchema=" + this.dataSchema() + ", dataContentType='" + this.dataContentType() + '\'' + ", data=" + this.data() + '}';
    }

    public static int parseMajorSpecVersion(String ver) {
        if (ver == null) {
            return -1;
        }
        Matcher m = VERSION_REGEX.matcher(ver);
        if (m.find()) {
            ver = m.group(1);
            if (ver == null) {
                return -1;
            }
            try {
                return Integer.parseInt(ver);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    public static boolean isKnownSpecVersion(String ceSpecVersion) {
        int maj = AbstractCloudEvent.parseMajorSpecVersion(ceSpecVersion);
        return maj == 0 || maj == 1;
    }

    protected int majorSpecVersion() {
        if (!this.isMajorParsed) {
            this.majorSpecVersion = AbstractCloudEvent.parseMajorSpecVersion(this.specVersion());
            this.isMajorParsed = true;
        }
        return this.majorSpecVersion;
    }
}

