/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.funqy.runtime;

import io.quarkus.funqy.runtime.FunctionInvoker;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;

public class FunctionRegistry {
    protected Map<String, FunctionInvoker> functions = new HashMap<String, FunctionInvoker>();
    private static final Logger log = Logger.getLogger(FunctionRegistry.class);

    public void register(Class clz, String methodName, String descriptor, String functionName) {
        String methodDescription = clz.getName() + "/" + methodName + descriptor;
        FunctionInvoker fi = this.functions.get(functionName);
        if (fi != null) {
            String otherMethodDescription = fi.targetClass.getName() + "/" + fi.method.getName() + FunctionRegistry.getMethodDescriptor(fi.method);
            String msg = String.format("Name conflict: the name \"%s\" is shared by \"%s\" and \"%s\". Consider using @Func(\"name-here\") annotation parameter to distinguish them.", functionName, methodDescription, otherMethodDescription);
            log.warn((Object)msg);
        }
        for (Method m : clz.getMethods()) {
            if (!m.getName().equals(methodName) || !descriptor.equals(FunctionRegistry.getMethodDescriptor(m))) continue;
            this.functions.put(functionName, new FunctionInvoker(functionName, clz, m));
            return;
        }
        throw new RuntimeException("Method \"" + methodDescription + "\" not found.");
    }

    public FunctionInvoker matchInvoker(String name) {
        return this.functions.get(name);
    }

    public Collection<FunctionInvoker> invokers() {
        return this.functions.values();
    }

    private static String getDescriptorForClass(Class c) {
        if (c.isPrimitive()) {
            if (c == Byte.TYPE) {
                return "B";
            }
            if (c == Character.TYPE) {
                return "C";
            }
            if (c == Double.TYPE) {
                return "D";
            }
            if (c == Float.TYPE) {
                return "F";
            }
            if (c == Integer.TYPE) {
                return "I";
            }
            if (c == Long.TYPE) {
                return "J";
            }
            if (c == Short.TYPE) {
                return "S";
            }
            if (c == Boolean.TYPE) {
                return "Z";
            }
            if (c == Void.TYPE) {
                return "V";
            }
            throw new RuntimeException("Unrecognized primitive " + c);
        }
        if (c.isArray()) {
            return c.getName().replace('.', '/');
        }
        return ("L" + c.getName() + ";").replace('.', '/');
    }

    private static String getMethodDescriptor(Method m) {
        Object s = "(";
        for (Class<?> c : m.getParameterTypes()) {
            s = (String)s + FunctionRegistry.getDescriptorForClass(c);
        }
        s = (String)s + ")";
        return (String)s + FunctionRegistry.getDescriptorForClass(m.getReturnType());
    }
}

