/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tooling.dependency;

import io.quarkus.bootstrap.util.BootstrapUtils;
import io.quarkus.fs.util.ZipUtils;
import io.quarkus.gradle.tooling.dependency.ExtensionDependency;
import io.quarkus.gradle.tooling.dependency.LocalExtensionDependency;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACTV;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;

public class DependencyUtils {
    private static final String COPY_CONFIGURATION_NAME = "quarkusDependency";
    private static final String TEST_FIXTURE_SUFFIX = "-test-fixtures";

    public static Configuration duplicateConfiguration(Project project, Configuration toDuplicate) {
        Configuration configurationCopy = (Configuration)project.getConfigurations().findByName(COPY_CONFIGURATION_NAME);
        if (configurationCopy != null) {
            project.getConfigurations().remove((Object)configurationCopy);
        }
        return DependencyUtils.duplicateConfiguration(project, COPY_CONFIGURATION_NAME, toDuplicate);
    }

    public static Configuration duplicateConfiguration(Project project, String name, Configuration toDuplicate) {
        Configuration configurationCopy = (Configuration)project.getConfigurations().create(name);
        configurationCopy.getDependencies().addAll((Collection)toDuplicate.getAllDependencies());
        configurationCopy.getDependencyConstraints().addAll((Collection)toDuplicate.getAllDependencyConstraints());
        return configurationCopy;
    }

    public static boolean isTestFixtureDependency(Dependency dependency) {
        if (!(dependency instanceof ModuleDependency)) {
            return false;
        }
        ModuleDependency module = (ModuleDependency)dependency;
        for (Capability requestedCapability : module.getRequestedCapabilities()) {
            if (!requestedCapability.getName().endsWith(TEST_FIXTURE_SUFFIX)) continue;
            return true;
        }
        return false;
    }

    public static String asDependencyNotation(Dependency dependency) {
        return String.join((CharSequence)":", dependency.getGroup(), dependency.getName(), dependency.getVersion());
    }

    public static String asDependencyNotation(ArtifactCoords artifactCoords) {
        return String.join((CharSequence)":", artifactCoords.getGroupId(), artifactCoords.getArtifactId(), artifactCoords.getVersion());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ExtensionDependency getExtensionInfoOrNull(Project project, ResolvedArtifact artifact) {
        ModuleVersionIdentifier artifactId = artifact.getModuleVersion().getId();
        File artifactFile = artifact.getFile();
        if (artifact.getId().getComponentIdentifier() instanceof ProjectComponentIdentifier) {
            SourceSet mainSourceSet;
            File resourcesDir;
            Path descriptorPath;
            SourceSetContainer sourceSets;
            Project projectDep = project.getRootProject().findProject(((ProjectComponentIdentifier)artifact.getId().getComponentIdentifier()).getProjectPath());
            SourceSetContainer sourceSetContainer = sourceSets = projectDep == null ? null : (SourceSetContainer)projectDep.getExtensions().findByType(SourceSetContainer.class);
            if (sourceSets != null && Files.exists(descriptorPath = (resourcesDir = (mainSourceSet = (SourceSet)sourceSets.getByName("main")).getOutput().getResourcesDir()).toPath().resolve("META-INF/quarkus-extension.properties"), new LinkOption[0])) {
                return DependencyUtils.loadExtensionInfo(project, descriptorPath, artifactId, projectDep);
            }
        }
        if (!artifactFile.exists()) {
            return null;
        }
        if (artifactFile.isDirectory()) {
            Path descriptorPath = artifactFile.toPath().resolve("META-INF/quarkus-extension.properties");
            if (!Files.exists(descriptorPath, new LinkOption[0])) return null;
            return DependencyUtils.loadExtensionInfo(project, descriptorPath, artifactId, null);
        }
        if (!"jar".equals(artifact.getExtension())) return null;
        try (FileSystem artifactFs = ZipUtils.newFileSystem((Path)artifactFile.toPath());){
            Path descriptorPath = artifactFs.getPath("META-INF/quarkus-extension.properties", new String[0]);
            if (!Files.exists(descriptorPath, new LinkOption[0])) return null;
            ExtensionDependency extensionDependency = DependencyUtils.loadExtensionInfo(project, descriptorPath, artifactId, null);
            return extensionDependency;
        }
        catch (IOException e) {
            throw new GradleException("Failed to read " + artifactFile, (Throwable)e);
        }
    }

    private static ExtensionDependency loadExtensionInfo(Project project, Path descriptorPath, ModuleVersionIdentifier exentionId, Project extensionProject) {
        List<Dependency> conditionalDependencies;
        Properties extensionProperties = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(descriptorPath);){
            extensionProperties.load(reader);
        }
        catch (IOException e) {
            throw new GradleException("Failed to load " + descriptorPath, (Throwable)e);
        }
        GACTV deploymentModule = GACTV.fromString((String)extensionProperties.getProperty("deployment-artifact"));
        if (extensionProperties.containsKey("conditional-dependencies")) {
            String[] deps = BootstrapUtils.splitByWhitespace((String)extensionProperties.getProperty("conditional-dependencies"));
            conditionalDependencies = new ArrayList(deps.length);
            for (String conditionalDep : deps) {
                conditionalDependencies.add(DependencyUtils.create(project.getDependencies(), conditionalDep));
            }
        } else {
            conditionalDependencies = Collections.emptyList();
        }
        ArtifactKey[] constraints = BootstrapUtils.parseDependencyCondition((String)extensionProperties.getProperty("dependency-condition"));
        if (extensionProject != null) {
            return new LocalExtensionDependency(extensionProject, exentionId, (ArtifactCoords)deploymentModule, conditionalDependencies, constraints == null ? Collections.emptyList() : Arrays.asList(constraints));
        }
        return new ExtensionDependency(exentionId, (ArtifactCoords)deploymentModule, conditionalDependencies, constraints == null ? Collections.emptyList() : Arrays.asList(constraints));
    }

    public static Dependency create(DependencyHandler dependencies, String conditionalDependency) {
        GACTV dependencyCoords = GACTV.fromString((String)conditionalDependency);
        return dependencies.create((Object)String.join((CharSequence)":", dependencyCoords.getGroupId(), dependencyCoords.getArtifactId(), dependencyCoords.getVersion()));
    }

    public static void addLocalDeploymentDependency(String deploymentConfigurationName, LocalExtensionDependency extension, DependencyHandler dependencies) {
        dependencies.add(deploymentConfigurationName, (Object)dependencies.project(Collections.singletonMap("path", extension.findDeploymentModulePath())));
    }

    public static void requireDeploymentDependency(String deploymentConfigurationName, ExtensionDependency extension, DependencyHandler dependencies) {
        dependencies.add(deploymentConfigurationName, (Object)(extension.getDeploymentModule().getGroupId() + ":" + extension.getDeploymentModule().getArtifactId() + ":" + extension.getDeploymentModule().getVersion()));
    }
}

