/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.dependency;

import io.quarkus.gradle.dependency.ApplicationDeploymentClasspathBuilder;
import io.quarkus.gradle.tooling.dependency.DependencyUtils;
import io.quarkus.gradle.tooling.dependency.ExtensionDependency;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.runtime.LaunchMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;

public class ConditionalDependenciesEnabler {
    private final Map<GACT, Set<ExtensionDependency>> featureVariants = new HashMap<GACT, Set<ExtensionDependency>>();
    private final Map<ModuleVersionIdentifier, ExtensionDependency> allExtensions = new HashMap<ModuleVersionIdentifier, ExtensionDependency>();
    private final Project project;
    private final Configuration enforcedPlatforms;
    private final Set<ArtifactKey> existingArtifacts = new HashSet<ArtifactKey>();
    private final List<Dependency> unsatisfiedConditionalDeps = new ArrayList<Dependency>();

    public ConditionalDependenciesEnabler(Project project, LaunchMode mode, Configuration platforms) {
        this.project = project;
        this.enforcedPlatforms = platforms;
        Configuration baseRuntimeConfig = project.getConfigurations().getByName(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName(mode));
        if (!baseRuntimeConfig.getIncoming().getDependencies().isEmpty()) {
            this.collectConditionalDependencies(baseRuntimeConfig.getResolvedConfiguration().getResolvedArtifacts());
            while (!this.unsatisfiedConditionalDeps.isEmpty()) {
                boolean satisfiedConditionalDeps = false;
                int originalUnsatisfiedCount = this.unsatisfiedConditionalDeps.size();
                int i = 0;
                while (i < this.unsatisfiedConditionalDeps.size()) {
                    Dependency conditionalDep = this.unsatisfiedConditionalDeps.get(i);
                    if (this.resolveConditionalDependency(conditionalDep)) {
                        satisfiedConditionalDeps = true;
                        this.unsatisfiedConditionalDeps.remove(i);
                        continue;
                    }
                    ++i;
                }
                if (satisfiedConditionalDeps || this.unsatisfiedConditionalDeps.size() != originalUnsatisfiedCount) continue;
                break;
            }
            this.reset();
        }
    }

    public Collection<ExtensionDependency> getAllExtensions() {
        return this.allExtensions.values();
    }

    private void reset() {
        this.featureVariants.clear();
        this.existingArtifacts.clear();
        this.unsatisfiedConditionalDeps.clear();
    }

    private void collectConditionalDependencies(Set<ResolvedArtifact> runtimeArtifacts) {
        this.addToMasterList(runtimeArtifacts);
        Map<ModuleVersionIdentifier, ExtensionDependency> artifactExtensions = this.getArtifactExtensions(runtimeArtifacts);
        this.allExtensions.putAll(artifactExtensions);
        artifactExtensions.forEach((ignored, extension) -> this.queueAbsentExtensionConditionalDependencies((ExtensionDependency)extension));
    }

    private void addToMasterList(Set<ResolvedArtifact> artifacts) {
        artifacts.stream().map(ConditionalDependenciesEnabler::getKey).forEach(this.existingArtifacts::add);
    }

    private Map<ModuleVersionIdentifier, ExtensionDependency> getArtifactExtensions(Set<ResolvedArtifact> runtimeArtifacts) {
        return runtimeArtifacts.stream().flatMap(artifact -> DependencyUtils.getOptionalExtensionInfo(this.project, artifact).stream()).collect(Collectors.toMap(ExtensionDependency::getExtensionId, Function.identity()));
    }

    private void queueAbsentExtensionConditionalDependencies(ExtensionDependency extension) {
        extension.getConditionalDependencies().stream().filter(dep -> !this.exists((Dependency)dep)).forEach(dep -> this.queueConditionalDependency(extension, (Dependency)dep));
    }

    private boolean resolveConditionalDependency(Dependency conditionalDep) {
        Configuration conditionalDeps = this.createConditionalDependenciesConfiguration(this.project, conditionalDep);
        Set resolvedArtifacts = conditionalDeps.getResolvedConfiguration().getResolvedArtifacts();
        boolean isConditionalDependencyResolved = resolvedArtifacts.stream().filter(artifact -> this.areEquals(conditionalDep, (ResolvedArtifact)artifact)).flatMap(artifact -> DependencyUtils.getOptionalExtensionInfo(this.project, artifact).stream()).filter(extension -> extension.getDependencyConditions().isEmpty() || this.exist(extension.getDependencyConditions())).findFirst().map(extension -> {
            this.enableConditionalDependency(extension.getExtensionId());
            return true;
        }).orElse(false);
        if (isConditionalDependencyResolved) {
            this.addToMasterList(resolvedArtifacts);
            Map<ModuleVersionIdentifier, ExtensionDependency> artifactExtensions = this.getArtifactExtensions(resolvedArtifacts);
            artifactExtensions.forEach((id, extension) -> extension.setConditional(true));
            this.allExtensions.putAll(artifactExtensions);
            artifactExtensions.forEach((ignored, extension) -> this.queueAbsentExtensionConditionalDependencies((ExtensionDependency)extension));
        }
        return isConditionalDependencyResolved;
    }

    private boolean areEquals(Dependency dependency, ResolvedArtifact artifact) {
        return dependency.getName().equals(artifact.getName()) && Objects.equals(dependency.getVersion(), artifact.getModuleVersion().getId().getVersion()) && artifact.getModuleVersion().getId().getGroup().equals(dependency.getGroup());
    }

    private void queueConditionalDependency(ExtensionDependency extension, Dependency conditionalDep) {
        this.featureVariants.computeIfAbsent(ConditionalDependenciesEnabler.getFeatureKey(conditionalDep), k -> {
            this.unsatisfiedConditionalDeps.add(conditionalDep);
            return new HashSet();
        }).add(extension);
    }

    private Configuration createConditionalDependenciesConfiguration(Project project, Dependency conditionalDep) {
        Configuration conditionalDepConfiguration = project.getConfigurations().detachedConfiguration(new Dependency[0]).extendsFrom(new Configuration[]{this.enforcedPlatforms});
        conditionalDepConfiguration.getDependencies().add((Object)conditionalDep);
        return conditionalDepConfiguration;
    }

    private void enableConditionalDependency(ModuleVersionIdentifier dependency) {
        Set<ExtensionDependency> extensions = this.featureVariants.remove(ConditionalDependenciesEnabler.getFeatureKey(dependency));
        if (extensions == null) {
            return;
        }
        extensions.forEach(e -> e.importConditionalDependency(this.project.getDependencies(), dependency));
    }

    private boolean exist(List<ArtifactKey> dependencies) {
        return this.existingArtifacts.containsAll(dependencies);
    }

    private boolean exists(Dependency dependency) {
        return this.existingArtifacts.contains(ArtifactKey.of((String)dependency.getGroup(), (String)dependency.getName(), null, (String)"jar"));
    }

    public boolean exists(ExtensionDependency dependency) {
        return this.existingArtifacts.contains(ArtifactKey.of((String)dependency.getGroup(), (String)dependency.getName(), null, (String)"jar"));
    }

    private static GACT getFeatureKey(ModuleVersionIdentifier version) {
        return new GACT(version.getGroup(), version.getName());
    }

    private static GACT getFeatureKey(Dependency version) {
        return new GACT(version.getGroup(), version.getName());
    }

    private static ArtifactKey getKey(ResolvedArtifact a) {
        return ArtifactKey.of((String)a.getModuleVersion().getId().getGroup(), (String)a.getName(), (String)a.getClassifier(), (String)a.getType());
    }
}

