/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.dependency;

import io.quarkus.bootstrap.model.PlatformImports;
import io.quarkus.bootstrap.model.PlatformImportsImpl;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.gradle.dependency.ConditionalDependenciesEnabler;
import io.quarkus.gradle.tooling.ToolingUtils;
import io.quarkus.gradle.tooling.dependency.DependencyUtils;
import io.quarkus.gradle.tooling.dependency.ExtensionDependency;
import io.quarkus.gradle.tooling.dependency.IncludedBuildExtensionDependency;
import io.quarkus.gradle.tooling.dependency.LocalExtensionDependency;
import io.quarkus.runtime.LaunchMode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.internal.artifacts.dependencies.DefaultDependencyArtifact;
import org.gradle.api.internal.artifacts.dependencies.DefaultExternalModuleDependency;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;

public class ApplicationDeploymentClasspathBuilder {
    private final Project project;
    private final LaunchMode mode;
    private final String runtimeConfigurationName;
    private final String platformConfigurationName;
    private final String deploymentConfigurationName;
    private static final HashMap<String, PlatformImportsImpl> platformImports = new HashMap();
    private final String platformImportName;

    private static String getRuntimeConfigName(LaunchMode mode, boolean base) {
        StringBuilder sb = new StringBuilder();
        sb.append("quarkus");
        if (mode == LaunchMode.DEVELOPMENT) {
            sb.append("Dev");
        } else if (mode == LaunchMode.TEST) {
            sb.append("Test");
        } else {
            sb.append("Prod");
        }
        if (base) {
            sb.append("Base");
        }
        sb.append("RuntimeClasspathConfiguration");
        return sb.toString();
    }

    public static String getBaseRuntimeConfigName(LaunchMode mode) {
        return ApplicationDeploymentClasspathBuilder.getRuntimeConfigName(mode, true);
    }

    public static String getFinalRuntimeConfigName(LaunchMode mode) {
        return ApplicationDeploymentClasspathBuilder.getRuntimeConfigName(mode, false);
    }

    public static void initConfigurations(Project project) {
        ConfigurationContainer configContainer = project.getConfigurations();
        ((Configuration)configContainer.create("quarkusDev")).extendsFrom(new Configuration[]{configContainer.getByName("implementation")});
        ((Configuration)configContainer.create(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName(LaunchMode.TEST))).extendsFrom(new Configuration[]{configContainer.getByName("testRuntimeClasspath")});
        ((Configuration)configContainer.create(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName(LaunchMode.NORMAL))).extendsFrom(new Configuration[]{configContainer.getByName("runtimeClasspath")});
        ((Configuration)configContainer.create(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName(LaunchMode.DEVELOPMENT))).extendsFrom(new Configuration[]{configContainer.getByName("quarkusDev"), configContainer.getByName("compileClasspath"), configContainer.getByName("runtimeClasspath")});
        configContainer.getByName("annotationProcessor").withDependencies(annotationProcessors -> {
            Set compileClasspathArtifacts = DependencyUtils.duplicateConfiguration(project, configContainer.getByName("compileClasspath")).getResolvedConfiguration().getResolvedArtifacts();
            for (ResolvedArtifact artifact : compileClasspathArtifacts) {
                if (!"quarkus-panache-common".equals(artifact.getName()) || !"io.quarkus".equals(artifact.getModuleVersion().getId().getGroup())) continue;
                project.getDependencies().add("annotationProcessor", (Object)("io.quarkus:quarkus-panache-common:" + artifact.getModuleVersion().getId().getVersion()));
            }
        });
    }

    public ApplicationDeploymentClasspathBuilder(Project project, LaunchMode mode) {
        this.project = project;
        this.mode = mode;
        this.runtimeConfigurationName = ApplicationDeploymentClasspathBuilder.getFinalRuntimeConfigName(mode);
        this.platformConfigurationName = ToolingUtils.toPlatformConfigurationName(this.runtimeConfigurationName);
        this.deploymentConfigurationName = ToolingUtils.toDeploymentConfigurationName(this.runtimeConfigurationName);
        this.platformImportName = project.getPath() + ":" + this.platformConfigurationName;
        this.setUpPlatformConfiguration();
        this.setUpRuntimeConfiguration();
        this.setUpDeploymentConfiguration();
    }

    private void setUpPlatformConfiguration() {
        if (this.project.getConfigurations().findByName(this.platformConfigurationName) == null) {
            PlatformImportsImpl platformImports = ApplicationDeploymentClasspathBuilder.platformImports.computeIfAbsent(this.platformImportName, ignored -> new PlatformImportsImpl());
            this.project.getConfigurations().create(this.platformConfigurationName, configuration -> {
                ListProperty dependencyListProperty = this.project.getObjects().listProperty(Dependency.class);
                configuration.getDependencies().addAllLater((Provider)dependencyListProperty.value(this.project.provider(() -> this.project.getConfigurations().getByName("implementation").getAllDependencies().stream().filter(dependency -> dependency instanceof ModuleDependency && ToolingUtils.isEnforcedPlatform((ModuleDependency)dependency)).collect(Collectors.toList()))));
                configuration.getResolutionStrategy().eachDependency(d -> {
                    ModuleIdentifier identifier = d.getTarget().getModule();
                    String group = identifier.getGroup();
                    String name = identifier.getName();
                    if (name.endsWith("-quarkus-platform-descriptor")) {
                        platformImports.addPlatformDescriptor(group, name, d.getTarget().getVersion(), "json", d.getTarget().getVersion());
                    } else if (name.endsWith("-quarkus-platform-properties")) {
                        DefaultDependencyArtifact dep = new DefaultDependencyArtifact();
                        dep.setExtension("properties");
                        dep.setType("properties");
                        dep.setName(name);
                        DefaultExternalModuleDependency gradleDep = new DefaultExternalModuleDependency(group, name, d.getTarget().getVersion(), null);
                        gradleDep.addArtifact((DependencyArtifact)dep);
                        for (ResolvedArtifact a : this.project.getConfigurations().detachedConfiguration(new Dependency[]{gradleDep}).getResolvedConfiguration().getResolvedArtifacts()) {
                            if (!a.getName().equals(name)) continue;
                            try {
                                platformImports.addPlatformProperties(group, name, null, "properties", d.getTarget().getVersion(), a.getFile().toPath());
                                break;
                            }
                            catch (AppModelResolverException e) {
                                throw new GradleException("Failed to import platform properties " + a.getFile(), (Throwable)e);
                            }
                        }
                    }
                });
            });
        }
    }

    private void setUpRuntimeConfiguration() {
        if (this.project.getConfigurations().findByName(this.runtimeConfigurationName) == null) {
            this.project.getConfigurations().create(this.runtimeConfigurationName, configuration -> configuration.extendsFrom(new Configuration[]{this.project.getConfigurations().getByName(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName(this.mode))}));
        }
    }

    private void setUpDeploymentConfiguration() {
        if (this.project.getConfigurations().findByName(this.deploymentConfigurationName) == null) {
            this.project.getConfigurations().create(this.deploymentConfigurationName, configuration -> {
                Configuration enforcedPlatforms = this.getPlatformConfiguration();
                configuration.extendsFrom(new Configuration[]{enforcedPlatforms});
                ListProperty dependencyListProperty = this.project.getObjects().listProperty(Dependency.class);
                configuration.getDependencies().addAllLater((Provider)dependencyListProperty.value(this.project.provider(() -> {
                    ConditionalDependenciesEnabler cdEnabler = new ConditionalDependenciesEnabler(this.project, this.mode, enforcedPlatforms);
                    Collection<ExtensionDependency> allExtensions = cdEnabler.getAllExtensions();
                    Set<ExtensionDependency> extensions = this.collectFirstMetQuarkusExtensions(this.getRawRuntimeConfiguration(), allExtensions);
                    for (ExtensionDependency knownExtension : allExtensions) {
                        if (!knownExtension.isConditional()) continue;
                        extensions.add(knownExtension);
                    }
                    HashSet<ModuleVersionIdentifier> alreadyProcessed = new HashSet<ModuleVersionIdentifier>(extensions.size());
                    DependencyHandler dependencies = this.project.getDependencies();
                    HashSet<Dependency> deploymentDependencies = new HashSet<Dependency>();
                    for (ExtensionDependency extension : extensions) {
                        if (extension instanceof IncludedBuildExtensionDependency) {
                            deploymentDependencies.add(((IncludedBuildExtensionDependency)extension).getDeployment());
                            continue;
                        }
                        if (extension instanceof LocalExtensionDependency) {
                            LocalExtensionDependency localExtensionDependency = (LocalExtensionDependency)extension;
                            deploymentDependencies.add(dependencies.project(Collections.singletonMap("path", localExtensionDependency.findDeploymentModulePath())));
                            continue;
                        }
                        if (!alreadyProcessed.add(extension.getExtensionId())) continue;
                        deploymentDependencies.add(dependencies.create((Object)(extension.getDeploymentModule().getGroupId() + ":" + extension.getDeploymentModule().getArtifactId() + ":" + extension.getDeploymentModule().getVersion())));
                    }
                    return deploymentDependencies;
                })));
            });
        }
    }

    public Configuration getPlatformConfiguration() {
        return this.project.getConfigurations().getByName(this.platformConfigurationName);
    }

    private Configuration getRawRuntimeConfiguration() {
        return this.project.getConfigurations().getByName(this.runtimeConfigurationName);
    }

    public Configuration getRuntimeConfiguration() {
        this.getDeploymentConfiguration().resolve();
        return this.project.getConfigurations().getByName(this.runtimeConfigurationName);
    }

    public Configuration getDeploymentConfiguration() {
        return this.project.getConfigurations().getByName(this.deploymentConfigurationName);
    }

    public PlatformImports getPlatformImports() {
        this.getPlatformConfiguration().getResolvedConfiguration();
        return (PlatformImports)platformImports.get(this.platformImportName);
    }

    private Set<ExtensionDependency> collectFirstMetQuarkusExtensions(Configuration configuration, Collection<ExtensionDependency> knownExtensions) {
        HashSet<ExtensionDependency> firstLevelExtensions = new HashSet<ExtensionDependency>();
        Set firstLevelModuleDependencies = configuration.getResolvedConfiguration().getFirstLevelModuleDependencies();
        HashSet<String> visitedArtifacts = new HashSet<String>();
        for (ResolvedDependency firstLevelModuleDependency : firstLevelModuleDependencies) {
            firstLevelExtensions.addAll(this.collectQuarkusExtensions(firstLevelModuleDependency, visitedArtifacts, knownExtensions));
        }
        return firstLevelExtensions;
    }

    private Set<ExtensionDependency> collectQuarkusExtensions(ResolvedDependency dependency, Set<String> visitedArtifacts, Collection<ExtensionDependency> knownExtensions) {
        String artifactKey = String.format("%s:%s", dependency.getModuleGroup(), dependency.getModuleName());
        if (!visitedArtifacts.add(artifactKey)) {
            return Collections.emptySet();
        }
        LinkedHashSet<ExtensionDependency> extensions = new LinkedHashSet<ExtensionDependency>();
        ExtensionDependency extension = this.getExtensionOrNull(dependency.getModuleGroup(), dependency.getModuleName(), dependency.getModuleVersion(), knownExtensions);
        if (extension != null) {
            extensions.add(extension);
        } else {
            for (ResolvedDependency child : dependency.getChildren()) {
                extensions.addAll(this.collectQuarkusExtensions(child, visitedArtifacts, knownExtensions));
            }
        }
        return extensions;
    }

    private ExtensionDependency getExtensionOrNull(String group, String artifact, String version, Collection<ExtensionDependency> knownExtensions) {
        for (ExtensionDependency knownExtension : knownExtensions) {
            if (!group.equals(knownExtension.getGroup()) || !artifact.equals(knownExtension.getName()) || !version.equals(knownExtension.getVersion())) continue;
            return knownExtension;
        }
        return null;
    }
}

