/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tooling.dependency;

import io.quarkus.gradle.tooling.dependency.ExtensionDependency;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;

public class LocalExtensionDependency
extends ExtensionDependency {
    private static final String DEFAULT_DEPLOYMENT_PATH_SUFFIX = "deployment";
    private Project localProject;

    public LocalExtensionDependency(Project localProject, ModuleVersionIdentifier extensionId, ArtifactCoords deploymentModule, List<Dependency> conditionalDependencies, List<ArtifactKey> dependencyConditions) {
        super(extensionId, deploymentModule, conditionalDependencies, dependencyConditions);
        this.localProject = localProject;
    }

    public String findDeploymentModulePath() {
        String parentPath;
        String deploymentModuleName = DEFAULT_DEPLOYMENT_PATH_SUFFIX;
        if (this.localProject.getParent().findProject(this.deploymentModule.getArtifactId()) != null) {
            deploymentModuleName = this.deploymentModule.getArtifactId();
        }
        if ((parentPath = this.localProject.getParent().getPath()).endsWith(":")) {
            return parentPath + deploymentModuleName;
        }
        return parentPath + ":" + deploymentModuleName;
    }
}

