/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tooling;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.model.gradle.ModelParameter;
import io.quarkus.bootstrap.model.gradle.impl.ModelParameterImpl;
import io.quarkus.gradle.tooling.GradleApplicationModelBuilder;
import io.quarkus.runtime.LaunchMode;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.attributes.Category;
import org.gradle.api.initialization.IncludedBuild;

public class ToolingUtils {
    private static final String DEPLOYMENT_CONFIGURATION_SUFFIX = "Deployment";
    public static final String DEV_MODE_CONFIGURATION_NAME = "quarkusDev";

    public static String toDeploymentConfigurationName(String baseConfigurationName) {
        return baseConfigurationName + DEPLOYMENT_CONFIGURATION_SUFFIX;
    }

    public static List<Dependency> getEnforcedPlatforms(Project project) {
        return ToolingUtils.getEnforcedPlatforms(project.getConfigurations().getByName("implementation"));
    }

    public static List<Dependency> getEnforcedPlatforms(Configuration config) {
        ArrayList<Dependency> directExtension = new ArrayList<Dependency>();
        for (Dependency d : config.getAllDependencies()) {
            ModuleDependency module;
            if (!(d instanceof ModuleDependency) || !ToolingUtils.isEnforcedPlatform(module = (ModuleDependency)d)) continue;
            directExtension.add(d);
        }
        return directExtension;
    }

    public static boolean isEnforcedPlatform(ModuleDependency module) {
        Category category = (Category)module.getAttributes().getAttribute(Category.CATEGORY_ATTRIBUTE);
        return category != null && ("enforced-platform".equals(category.getName()) || "platform".equals(category.getName()));
    }

    public static IncludedBuild includedBuild(Project project, String projectName) {
        try {
            return project.getGradle().includedBuild(projectName);
        }
        catch (UnknownDomainObjectException ignore) {
            return null;
        }
    }

    public static Path serializeAppModel(ApplicationModel appModel, Task context, boolean test) throws IOException {
        Path serializedModel = context.getTemporaryDir().toPath().resolve("quarkus-app" + (test ? "-test" : "") + "-model.dat");
        try (ObjectOutputStream out = new ObjectOutputStream(Files.newOutputStream(serializedModel, new OpenOption[0]));){
            out.writeObject(appModel);
        }
        return serializedModel;
    }

    public static ApplicationModel create(Project project, LaunchMode mode) {
        ModelParameterImpl params = new ModelParameterImpl();
        params.setMode(mode.toString());
        return (ApplicationModel)new GradleApplicationModelBuilder().buildAll(ApplicationModel.class.getName(), (ModelParameter)params, project);
    }
}

