/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tooling;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.model.ApplicationModelBuilder;
import io.quarkus.bootstrap.model.CapabilityContract;
import io.quarkus.bootstrap.model.ExtensionCapabilities;
import io.quarkus.bootstrap.model.PlatformImports;
import io.quarkus.bootstrap.model.PlatformImportsImpl;
import io.quarkus.bootstrap.model.gradle.ModelParameter;
import io.quarkus.bootstrap.model.gradle.impl.ModelParameterImpl;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.DefaultArtifactSources;
import io.quarkus.bootstrap.workspace.DefaultSourceDir;
import io.quarkus.bootstrap.workspace.DefaultWorkspaceModule;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.bootstrap.workspace.WorkspaceModuleId;
import io.quarkus.fs.util.ZipUtils;
import io.quarkus.gradle.tooling.ToolingUtils;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactDependency;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.maven.dependency.GACTV;
import io.quarkus.maven.dependency.GAV;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.maven.dependency.ResolvedDependencyBuilder;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.util.HashUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.artifacts.dependencies.DefaultDependencyArtifact;
import org.gradle.api.internal.artifacts.dependencies.DefaultExternalModuleDependency;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.language.jvm.tasks.ProcessResources;
import org.gradle.tooling.provider.model.ParameterizedToolingModelBuilder;

public class GradleApplicationModelBuilder
implements ParameterizedToolingModelBuilder<ModelParameter> {
    private static final String MAIN_RESOURCES_OUTPUT = "build/resources/main";
    private static final String CLASSES_OUTPUT = "build/classes";
    private static final String DEPLOYMENT_CONFIGURATION = "quarkusDeploymentConfiguration";
    private static final String CLASSPATH_CONFIGURATION = "quarkusClasspathConfiguration";
    private static final byte COLLECT_TOP_EXTENSION_RUNTIME_NODES = 1;
    private static final byte COLLECT_DIRECT_DEPS = 2;
    private static final byte COLLECT_RELOADABLE_MODULES = 4;

    private static Configuration classpathConfig(Project project, LaunchMode mode) {
        if (LaunchMode.TEST.equals((Object)mode)) {
            return project.getConfigurations().getByName("testRuntimeClasspath");
        }
        if (LaunchMode.DEVELOPMENT.equals((Object)mode)) {
            Configuration classpathConfiguration = (Configuration)project.getConfigurations().findByName(CLASSPATH_CONFIGURATION);
            if (classpathConfiguration != null) {
                project.getConfigurations().remove((Object)classpathConfiguration);
            }
            return ((Configuration)project.getConfigurations().create(CLASSPATH_CONFIGURATION)).extendsFrom(new Configuration[]{project.getConfigurations().getByName("quarkusDev"), project.getConfigurations().getByName("compileClasspath"), project.getConfigurations().getByName("runtimeClasspath")});
        }
        return project.getConfigurations().getByName("runtimeClasspath");
    }

    private static Configuration deploymentClasspathConfig(Project project, LaunchMode mode, Collection<Dependency> platforms) {
        Configuration devDeploymentConfiguration;
        Configuration testDeploymentConfiguration;
        Configuration deploymentConfiguration = (Configuration)project.getConfigurations().findByName(DEPLOYMENT_CONFIGURATION);
        if (deploymentConfiguration != null) {
            project.getConfigurations().remove((Object)deploymentConfiguration);
        }
        deploymentConfiguration = ((Configuration)project.getConfigurations().create(DEPLOYMENT_CONFIGURATION)).withDependencies(ds -> ds.addAll(platforms));
        Configuration implementationDeployment = (Configuration)project.getConfigurations().findByName(ToolingUtils.toDeploymentConfigurationName("implementation"));
        if (implementationDeployment != null) {
            deploymentConfiguration.extendsFrom(new Configuration[]{implementationDeployment});
        }
        if (LaunchMode.TEST.equals((Object)mode) && (testDeploymentConfiguration = (Configuration)project.getConfigurations().findByName(ToolingUtils.toDeploymentConfigurationName("testImplementation"))) != null) {
            deploymentConfiguration.extendsFrom(new Configuration[]{testDeploymentConfiguration});
        }
        if (LaunchMode.DEVELOPMENT.equals((Object)mode) && (devDeploymentConfiguration = (Configuration)project.getConfigurations().findByName(ToolingUtils.toDeploymentConfigurationName("quarkusDev"))) != null) {
            deploymentConfiguration.extendsFrom(new Configuration[]{devDeploymentConfiguration});
        }
        return deploymentConfiguration;
    }

    public boolean canBuild(String modelName) {
        return modelName.equals(ApplicationModel.class.getName());
    }

    public Class<ModelParameter> getParameterType() {
        return ModelParameter.class;
    }

    public Object buildAll(String modelName, Project project) {
        ModelParameterImpl modelParameter = new ModelParameterImpl();
        modelParameter.setMode(LaunchMode.DEVELOPMENT.toString());
        return this.buildAll(modelName, (ModelParameter)modelParameter, project);
    }

    public Object buildAll(String modelName, ModelParameter parameter, Project project) {
        LaunchMode mode = LaunchMode.valueOf((String)parameter.getMode());
        List<Dependency> deploymentDeps = ToolingUtils.getEnforcedPlatforms(project);
        PlatformImports platformImports = this.resolvePlatformImports(project, deploymentDeps);
        ResolvedDependency appArtifact = GradleApplicationModelBuilder.getProjectArtifact(project, mode);
        ApplicationModelBuilder modelBuilder = new ApplicationModelBuilder().setAppArtifact(appArtifact).addReloadableWorkspaceModule(appArtifact.getKey()).setPlatformImports(platformImports);
        LinkedHashMap<ArtifactKey, ResolvedDependencyBuilder> appDependencies = new LinkedHashMap<ArtifactKey, ResolvedDependencyBuilder>();
        Configuration classpathConfig = GradleApplicationModelBuilder.classpathConfig(project, mode);
        this.collectDependencies(classpathConfig.getResolvedConfiguration(), mode, project, appDependencies, modelBuilder, (DefaultWorkspaceModule)appArtifact.getWorkspaceModule());
        Configuration deploymentConfig = GradleApplicationModelBuilder.deploymentClasspathConfig(project, mode, deploymentDeps);
        this.collectExtensionDependencies(project, deploymentConfig, appDependencies);
        for (ResolvedDependencyBuilder d : appDependencies.values()) {
            modelBuilder.addDependency(d.build());
        }
        return modelBuilder.build();
    }

    public static ResolvedDependency getProjectArtifact(Project project, LaunchMode mode) {
        ResolvedDependencyBuilder appArtifact = (ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setGroupId(project.getGroup().toString())).setArtifactId(project.getName())).setVersion(project.getVersion().toString());
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
        if (javaConvention == null) {
            throw new GradleException("Failed to locate Java plugin extension in " + project.getPath());
        }
        DefaultWorkspaceModule mainModule = new DefaultWorkspaceModule((WorkspaceModuleId)new GAV(appArtifact.getGroupId(), appArtifact.getArtifactId(), appArtifact.getVersion()), project.getProjectDir(), project.getBuildDir());
        mainModule.setBuildFiles((PathCollection)PathList.of((Path[])new Path[]{project.getBuildFile().toPath()}));
        GradleApplicationModelBuilder.initProjectModule(project, mainModule, (SourceSet)javaConvention.getSourceSets().findByName("main"), "main", "");
        if (mode.equals((Object)LaunchMode.TEST)) {
            GradleApplicationModelBuilder.initProjectModule(project, mainModule, (SourceSet)javaConvention.getSourceSets().findByName("test"), "test", "tests");
        }
        PathList.Builder paths = PathList.builder();
        GradleApplicationModelBuilder.collectDestinationDirs(mainModule.getMainSources().getSourceDirs(), paths);
        GradleApplicationModelBuilder.collectDestinationDirs(mainModule.getMainSources().getResourceDirs(), paths);
        return appArtifact.setWorkspaceModule((WorkspaceModule)mainModule).setResolvedPaths((PathCollection)paths.build()).build();
    }

    private static void collectDestinationDirs(Collection<SourceDir> sources, PathList.Builder paths) {
        for (SourceDir src : sources) {
            if (!Files.exists(src.getOutputDir(), new LinkOption[0])) {
                return;
            }
            Path path = src.getOutputDir();
            if (paths.contains(path)) {
                return;
            }
            paths.add(path);
        }
    }

    private PlatformImports resolvePlatformImports(Project project, List<Dependency> deploymentDeps) {
        Configuration boms = project.getConfigurations().detachedConfiguration(deploymentDeps.toArray(new Dependency[0]));
        PlatformImportsImpl platformImports = new PlatformImportsImpl();
        boms.getResolutionStrategy().eachDependency(d -> {
            String group = d.getTarget().getGroup();
            String name = d.getTarget().getName();
            if (name.endsWith("-quarkus-platform-descriptor")) {
                platformImports.addPlatformDescriptor(group, name, d.getTarget().getVersion(), "json", d.getTarget().getVersion());
            } else if (name.endsWith("-quarkus-platform-properties")) {
                DefaultDependencyArtifact dep = new DefaultDependencyArtifact();
                dep.setExtension("properties");
                dep.setType("properties");
                dep.setName(name);
                DefaultExternalModuleDependency gradleDep = new DefaultExternalModuleDependency(group, name, d.getTarget().getVersion(), null);
                gradleDep.addArtifact((DependencyArtifact)dep);
                for (ResolvedArtifact a : project.getConfigurations().detachedConfiguration(new Dependency[]{gradleDep}).getResolvedConfiguration().getResolvedArtifacts()) {
                    if (!a.getName().equals(name)) continue;
                    try {
                        platformImports.addPlatformProperties(group, name, null, "properties", d.getTarget().getVersion(), a.getFile().toPath());
                        break;
                    }
                    catch (AppModelResolverException e) {
                        throw new GradleException("Failed to import platform properties " + a.getFile(), (Throwable)e);
                    }
                }
            }
        });
        boms.getResolvedConfiguration();
        return platformImports;
    }

    private void collectExtensionDependencies(Project project, Configuration deploymentConfiguration, Map<ArtifactKey, ResolvedDependencyBuilder> appDependencies) {
        ResolvedConfiguration rc = deploymentConfiguration.getResolvedConfiguration();
        for (ResolvedArtifact a : rc.getResolvedArtifacts()) {
            if (a.getId().getComponentIdentifier() instanceof ProjectComponentIdentifier) {
                Project projectDep = project.getRootProject().findProject(((ProjectComponentIdentifier)a.getId().getComponentIdentifier()).getProjectPath());
                JavaPluginConvention javaExtension = projectDep == null ? null : (JavaPluginConvention)projectDep.getConvention().findPlugin(JavaPluginConvention.class);
                SourceSet mainSourceSet = (SourceSet)javaExtension.getSourceSets().getByName("main");
                ResolvedDependencyBuilder dep = appDependencies.computeIfAbsent(GradleApplicationModelBuilder.toAppDependenciesKey(a.getModuleVersion().getId().getGroup(), a.getName(), a.getClassifier()), k -> GradleApplicationModelBuilder.toDependency(a, mainSourceSet));
                dep.setDeploymentCp();
                dep.clearFlag(64);
                continue;
            }
            if (!GradleApplicationModelBuilder.isDependency(a)) continue;
            ResolvedDependencyBuilder dep = appDependencies.computeIfAbsent(GradleApplicationModelBuilder.toAppDependenciesKey(a.getModuleVersion().getId().getGroup(), a.getName(), a.getClassifier()), k -> GradleApplicationModelBuilder.toDependency(a, new int[0]));
            dep.setDeploymentCp();
            dep.clearFlag(64);
        }
    }

    private void collectDependencies(ResolvedConfiguration configuration, LaunchMode mode, Project project, Map<ArtifactKey, ResolvedDependencyBuilder> appDependencies, ApplicationModelBuilder modelBuilder, DefaultWorkspaceModule wsModule) {
        Set resolvedArtifacts = configuration.getResolvedArtifacts();
        HashSet artifactFiles = resolvedArtifacts.size() < configuration.getFiles().size() ? new HashSet(resolvedArtifacts.size()) : null;
        configuration.getFirstLevelModuleDependencies().forEach(d -> this.collectDependencies((org.gradle.api.artifacts.ResolvedDependency)d, mode, project, appDependencies, artifactFiles, (Set<ArtifactKey>)new HashSet<ArtifactKey>(), modelBuilder, wsModule, (byte)7));
        if (artifactFiles != null) {
            for (File f : configuration.getFiles()) {
                int dot;
                if (artifactFiles.contains(f) || !f.exists()) continue;
                String parentPath = f.getParent();
                String group = HashUtil.sha1((String)(parentPath == null ? f.getName() : parentPath));
                String name = f.getName();
                String type = "jar";
                if (!f.isDirectory() && (dot = f.getName().lastIndexOf(46)) > 0) {
                    name = f.getName().substring(0, dot);
                    type = f.getName().substring(dot + 1);
                }
                String version = String.valueOf(f.lastModified());
                ResolvedDependencyBuilder artifactBuilder = (ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setGroupId(group)).setArtifactId(name)).setType(type)).setVersion(version)).setResolvedPath(f.toPath()).setDirect(true)).setRuntimeCp();
                this.processQuarkusDependency(artifactBuilder, modelBuilder);
                appDependencies.put(artifactBuilder.getKey(), artifactBuilder);
            }
        }
    }

    private void collectDependencies(org.gradle.api.artifacts.ResolvedDependency resolvedDep, LaunchMode mode, Project project, Map<ArtifactKey, ResolvedDependencyBuilder> appDependencies, Set<File> artifactFiles, Set<ArtifactKey> processedModules, ApplicationModelBuilder modelBuilder, DefaultWorkspaceModule parentModule, byte flags) {
        DefaultWorkspaceModule projectModule = null;
        for (ResolvedArtifact a : resolvedDep.getModuleArtifacts()) {
            ArtifactKey artifactKey = GradleApplicationModelBuilder.toAppDependenciesKey(a.getModuleVersion().getId().getGroup(), a.getName(), a.getClassifier());
            if (!GradleApplicationModelBuilder.isDependency(a) || appDependencies.containsKey(artifactKey)) continue;
            ArtifactCoords depCoords = GradleApplicationModelBuilder.toArtifactCoords(a);
            ResolvedDependencyBuilder depBuilder = (ResolvedDependencyBuilder)((ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setCoords(depCoords)).setRuntimeCp();
            if (GradleApplicationModelBuilder.isFlagOn(flags, (byte)2)) {
                depBuilder.setDirect(true);
                flags = GradleApplicationModelBuilder.clearFlag(flags, (byte)2);
            }
            if (parentModule != null) {
                parentModule.addDirectDependency((io.quarkus.maven.dependency.Dependency)new ArtifactDependency(depCoords, new int[0]));
            }
            PathList paths = null;
            if ((LaunchMode.DEVELOPMENT.equals((Object)mode) || LaunchMode.TEST.equals((Object)mode)) && a.getId().getComponentIdentifier() instanceof ProjectComponentIdentifier) {
                Project projectDep = project.getRootProject().findProject(((ProjectComponentIdentifier)a.getId().getComponentIdentifier()).getProjectPath());
                JavaPluginConvention javaExtension = projectDep == null ? null : (JavaPluginConvention)projectDep.getConvention().findPlugin(JavaPluginConvention.class);
                String classifier = a.getClassifier();
                if (classifier == null || classifier.isEmpty()) {
                    PathList.Builder pathBuilder;
                    IncludedBuild includedBuild = ToolingUtils.includedBuild(project.getRootProject(), a.getName());
                    if (includedBuild != null) {
                        pathBuilder = PathList.builder();
                        this.addSubstitutedProject(pathBuilder, includedBuild.getProjectDir());
                        paths = pathBuilder.build();
                    } else if (javaExtension != null) {
                        pathBuilder = PathList.builder();
                        projectModule = this.initProjectModuleAndBuildPaths(projectDep, a, modelBuilder, depBuilder, javaExtension, pathBuilder, "main", false);
                        paths = pathBuilder.build();
                    }
                } else if (javaExtension != null) {
                    PathList.Builder pathBuilder;
                    if ("test".equals(classifier)) {
                        pathBuilder = PathList.builder();
                        projectModule = this.initProjectModuleAndBuildPaths(projectDep, a, modelBuilder, depBuilder, javaExtension, pathBuilder, "test", true);
                        paths = pathBuilder.build();
                    } else if ("test-fixtures".equals(classifier)) {
                        pathBuilder = PathList.builder();
                        projectModule = this.initProjectModuleAndBuildPaths(projectDep, a, modelBuilder, depBuilder, javaExtension, pathBuilder, "testFixtures", true);
                        paths = pathBuilder.build();
                    }
                }
            }
            depBuilder.setResolvedPaths(paths == null ? PathList.of((Path[])new Path[]{a.getFile().toPath()}) : paths).setWorkspaceModule(projectModule);
            if (this.processQuarkusDependency(depBuilder, modelBuilder)) {
                if (GradleApplicationModelBuilder.isFlagOn(flags, (byte)1)) {
                    depBuilder.setFlags(128);
                    flags = GradleApplicationModelBuilder.clearFlag(flags, (byte)1);
                }
                flags = GradleApplicationModelBuilder.clearFlag(flags, (byte)4);
            }
            if (!GradleApplicationModelBuilder.isFlagOn(flags, (byte)4)) {
                depBuilder.clearFlag(64);
            }
            appDependencies.put(depBuilder.getKey(), depBuilder);
            if (artifactFiles == null) continue;
            artifactFiles.add(a.getFile());
        }
        processedModules.add((ArtifactKey)new GACT(resolvedDep.getModuleGroup(), resolvedDep.getModuleName()));
        for (org.gradle.api.artifacts.ResolvedDependency child : resolvedDep.getChildren()) {
            if (processedModules.contains(new GACT(child.getModuleGroup(), child.getModuleName()))) continue;
            this.collectDependencies(child, mode, project, appDependencies, artifactFiles, processedModules, modelBuilder, projectModule, flags);
        }
    }

    private static String toNonNullClassifier(String resolvedClassifier) {
        return resolvedClassifier == null ? "" : resolvedClassifier;
    }

    private DefaultWorkspaceModule initProjectModuleAndBuildPaths(Project project, ResolvedArtifact resolvedArtifact, ApplicationModelBuilder appModel, ResolvedDependencyBuilder appDep, JavaPluginConvention javaExt, PathList.Builder buildPaths, String sourceName, boolean test) {
        ((ResolvedDependencyBuilder)appDep.setWorkspaceModule()).setReloadable();
        DefaultWorkspaceModule projectModule = appModel.getOrCreateProjectModule((WorkspaceModuleId)new GAV(resolvedArtifact.getModuleVersion().getId().getGroup(), resolvedArtifact.getName(), resolvedArtifact.getModuleVersion().getId().getVersion()), project.getProjectDir(), project.getBuildDir());
        projectModule.setBuildFiles((PathCollection)PathList.of((Path[])new Path[]{project.getBuildFile().toPath()}));
        String classifier = GradleApplicationModelBuilder.toNonNullClassifier(resolvedArtifact.getClassifier());
        GradleApplicationModelBuilder.initProjectModule(project, projectModule, (SourceSet)javaExt.getSourceSets().findByName(sourceName), sourceName, classifier);
        GradleApplicationModelBuilder.collectDestinationDirs(projectModule.getSources(classifier).getSourceDirs(), buildPaths);
        GradleApplicationModelBuilder.collectDestinationDirs(projectModule.getSources(classifier).getResourceDirs(), buildPaths);
        appModel.addReloadableWorkspaceModule((ArtifactKey)new GACT(resolvedArtifact.getModuleVersion().getId().getGroup(), resolvedArtifact.getName(), classifier, "jar"));
        return projectModule;
    }

    private boolean processQuarkusDependency(ResolvedDependencyBuilder artifactBuilder, ApplicationModelBuilder modelBuilder) {
        Path artifactPath;
        Iterator iterator = artifactBuilder.getResolvedPaths().iterator();
        if (iterator.hasNext() && Files.exists(artifactPath = (Path)iterator.next(), new LinkOption[0]) && artifactBuilder.getType().equals("jar")) {
            boolean bl;
            block10: {
                if (Files.isDirectory(artifactPath, new LinkOption[0])) {
                    return GradleApplicationModelBuilder.processQuarkusDir(artifactBuilder, artifactPath.resolve("META-INF"), modelBuilder);
                }
                FileSystem artifactFs = ZipUtils.newFileSystem((Path)artifactPath);
                try {
                    bl = GradleApplicationModelBuilder.processQuarkusDir(artifactBuilder, artifactFs.getPath("META-INF", new String[0]), modelBuilder);
                    if (artifactFs == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (artifactFs != null) {
                            try {
                                artifactFs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to process " + artifactPath, e);
                    }
                }
                artifactFs.close();
            }
            return bl;
        }
        return false;
    }

    private static boolean processQuarkusDir(ResolvedDependencyBuilder artifactBuilder, Path quarkusDir, ApplicationModelBuilder modelBuilder) {
        if (!Files.exists(quarkusDir, new LinkOption[0])) {
            return false;
        }
        Path quarkusDescr = quarkusDir.resolve("quarkus-extension.properties");
        if (!Files.exists(quarkusDescr, new LinkOption[0])) {
            return false;
        }
        Properties extProps = GradleApplicationModelBuilder.readDescriptor(quarkusDescr);
        if (extProps == null) {
            return false;
        }
        artifactBuilder.setRuntimeExtensionArtifact();
        String extensionCoords = artifactBuilder.toGACTVString();
        modelBuilder.handleExtensionProperties(extProps, extensionCoords);
        String providesCapabilities = extProps.getProperty("provides-capabilities");
        if (providesCapabilities != null) {
            modelBuilder.addExtensionCapabilities((ExtensionCapabilities)CapabilityContract.providesCapabilities((String)extensionCoords, (String)providesCapabilities));
        }
        return true;
    }

    private static Properties readDescriptor(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        Properties rtProps = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(path);){
            rtProps.load(reader);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to load extension description " + path, e);
        }
        return rtProps;
    }

    private static void initProjectModule(Project project, DefaultWorkspaceModule module, SourceSet sourceSet, String sourceName, String classifier) {
        if (sourceSet == null) {
            return;
        }
        FileCollection allClassesDirs = sourceSet.getOutput().getClassesDirs();
        ArrayList sourceDirs = new ArrayList(1);
        ArrayList resourceDirs = new ArrayList(1);
        project.getTasks().withType(AbstractCompile.class, t -> {
            if (!t.getEnabled()) {
                return;
            }
            FileTree source = t.getSource();
            if (source.isEmpty()) {
                return;
            }
            File destDir = (File)t.getDestinationDirectory().getAsFile().get();
            if (!allClassesDirs.contains(destDir)) {
                return;
            }
            ArrayList srcDirs = new ArrayList(1);
            source.visit(a -> {
                File srcDir;
                if (a.getRelativePath().getSegments().length == 1 && srcDirs.add(srcDir = a.getFile().getParentFile())) {
                    DefaultSourceDir sources = new DefaultSourceDir(srcDir, destDir, Collections.singletonMap("compiler", t.getName()));
                    sourceDirs.add(sources);
                }
            });
        });
        File resourcesOutputDir = sourceSet.getOutput().getResourcesDir();
        project.getTasks().withType(ProcessResources.class, t -> {
            if (!t.getEnabled()) {
                return;
            }
            FileCollection source = t.getSource();
            if (source.isEmpty()) {
                return;
            }
            File destDir = t.getDestinationDir();
            if (!destDir.equals(resourcesOutputDir)) {
                return;
            }
            ArrayList srcDirs = new ArrayList(1);
            source.getAsFileTree().visit(a -> {
                File srcDir;
                if (a.getRelativePath().getSegments().length == 1 && srcDirs.add(srcDir = a.getFile().getParentFile())) {
                    resourceDirs.add(new DefaultSourceDir(srcDir, destDir));
                }
            });
        });
        if (resourcesOutputDir.exists() && resourceDirs.isEmpty()) {
            sourceSet.getResources().getSrcDirs().forEach(srcDir -> resourceDirs.add(new DefaultSourceDir(srcDir, resourcesOutputDir)));
        }
        module.addArtifactSources((ArtifactSources)new DefaultArtifactSources(classifier, sourceDirs, resourceDirs));
    }

    private void addSubstitutedProject(PathList.Builder paths, File projectFile) {
        File classesOutput;
        File[] languageDirectories;
        File mainResourceDirectory = new File(projectFile, MAIN_RESOURCES_OUTPUT);
        if (mainResourceDirectory.exists()) {
            paths.add(mainResourceDirectory.toPath());
        }
        if ((languageDirectories = (classesOutput = new File(projectFile, CLASSES_OUTPUT)).listFiles()) == null) {
            throw new GradleException("The project does not contain a class output directory. " + classesOutput.getPath() + " must exist.");
        }
        for (File languageDirectory : languageDirectories) {
            if (!languageDirectory.isDirectory()) continue;
            for (File sourceSet : languageDirectory.listFiles()) {
                if (!sourceSet.isDirectory() || !sourceSet.getName().equals("main")) continue;
                paths.add(sourceSet.toPath());
            }
        }
    }

    private static byte setFlag(byte flags, byte flag) {
        flags = (byte)(flags | flag);
        return flags;
    }

    private static boolean isFlagOn(byte walkingFlags, byte flag) {
        return (walkingFlags & flag) > 0;
    }

    private static byte clearFlag(byte flags, byte flag) {
        if ((flags & flag) > 0) {
            flags = (byte)(flags ^ flag);
        }
        return flags;
    }

    private static boolean isDependency(ResolvedArtifact a) {
        return "jar".equalsIgnoreCase(a.getExtension()) || "exe".equalsIgnoreCase(a.getExtension()) || a.getFile().isDirectory();
    }

    static ResolvedDependencyBuilder toDependency(ResolvedArtifact a, int ... flags) {
        return GradleApplicationModelBuilder.toDependency(a, (PathCollection)PathList.of((Path[])new Path[]{a.getFile().toPath()}), null, flags);
    }

    static ResolvedDependencyBuilder toDependency(ResolvedArtifact a, SourceSet s) {
        PathList.Builder resolvedPathBuilder = PathList.builder();
        for (File classesDir : s.getOutput().getClassesDirs()) {
            resolvedPathBuilder.add(classesDir.toPath());
        }
        File resourceDir = s.getOutput().getResourcesDir();
        if (resourceDir != null && resourceDir.exists()) {
            resolvedPathBuilder.add(resourceDir.toPath());
        }
        return (ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setResolvedPaths((PathCollection)resolvedPathBuilder.build()).setCoords(GradleApplicationModelBuilder.toArtifactCoords(a));
    }

    static ResolvedDependencyBuilder toDependency(ResolvedArtifact a, PathCollection paths, DefaultWorkspaceModule module, int ... flags) {
        int allFlags = 0;
        for (int f : flags) {
            allFlags |= f;
        }
        return (ResolvedDependencyBuilder)((ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setCoords(GradleApplicationModelBuilder.toArtifactCoords(a))).setResolvedPaths(paths).setWorkspaceModule((WorkspaceModule)module).setFlags(allFlags);
    }

    private static ArtifactCoords toArtifactCoords(ResolvedArtifact a) {
        String[] split = a.getModuleVersion().toString().split(":");
        return new GACTV(split[0], split[1], a.getClassifier(), a.getType(), split.length > 2 ? split[2] : null);
    }

    private static ArtifactKey toAppDependenciesKey(String groupId, String artifactId, String classifier) {
        return new GACT(groupId, artifactId, classifier, "jar");
    }
}

