/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.dependency;

import io.quarkus.gradle.dependency.ConditionalDependenciesEnabler;
import io.quarkus.gradle.tooling.ToolingUtils;
import io.quarkus.gradle.tooling.dependency.DependencyUtils;
import io.quarkus.gradle.tooling.dependency.ExtensionDependency;
import io.quarkus.gradle.tooling.dependency.LocalExtensionDependency;
import io.quarkus.runtime.LaunchMode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;

public class ApplicationDeploymentClasspathBuilder {
    private final Project project;
    private final Collection<Dependency> enforcedPlatforms;
    private final LaunchMode mode;
    private ConditionalDependenciesEnabler cdEnabler;
    private Configuration runtimeConfig;

    private static String getRuntimeConfigName(LaunchMode mode, boolean base) {
        StringBuilder sb = new StringBuilder();
        sb.append("quarkus");
        if (mode == LaunchMode.DEVELOPMENT) {
            sb.append("Dev");
        } else if (mode == LaunchMode.TEST) {
            sb.append("Test");
        } else {
            sb.append("Prod");
        }
        if (base) {
            sb.append("Base");
        }
        sb.append("RuntimeClasspathConfiguration");
        return sb.toString();
    }

    public static String getBaseRuntimeConfigName(LaunchMode mode) {
        return ApplicationDeploymentClasspathBuilder.getRuntimeConfigName(mode, true);
    }

    public static String getFinalRuntimeConfigName(LaunchMode mode) {
        return ApplicationDeploymentClasspathBuilder.getRuntimeConfigName(mode, false);
    }

    public static void initConfigurations(Project project) {
        ConfigurationContainer configContainer = project.getConfigurations();
        ((Configuration)configContainer.create("quarkusDev")).extendsFrom(new Configuration[]{configContainer.getByName("implementation")});
        ((Configuration)configContainer.create(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName(LaunchMode.TEST))).extendsFrom(new Configuration[]{configContainer.getByName("testRuntimeClasspath")});
        ((Configuration)configContainer.create(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName(LaunchMode.NORMAL))).extendsFrom(new Configuration[]{configContainer.getByName("runtimeClasspath")});
        ((Configuration)configContainer.create(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName(LaunchMode.DEVELOPMENT))).extendsFrom(new Configuration[]{configContainer.getByName("quarkusDev"), configContainer.getByName("compileClasspath"), configContainer.getByName("runtimeClasspath")});
        configContainer.getByName("annotationProcessor").withDependencies(annotationProcessors -> {
            Set compileClasspathArtifacts = DependencyUtils.duplicateConfiguration(project, configContainer.getByName("compileClasspath")).getResolvedConfiguration().getResolvedArtifacts();
            for (ResolvedArtifact artifact : compileClasspathArtifacts) {
                if (!"quarkus-panache-common".equals(artifact.getName()) || !"io.quarkus".equals(artifact.getModuleVersion().getId().getGroup())) continue;
                project.getDependencies().add("annotationProcessor", (Object)("io.quarkus:quarkus-panache-common:" + artifact.getModuleVersion().getId().getVersion()));
            }
        });
    }

    public ApplicationDeploymentClasspathBuilder(Project project, LaunchMode mode, Collection<Dependency> enforcedPlatforms) {
        this.project = project;
        this.mode = mode;
        this.enforcedPlatforms = enforcedPlatforms;
    }

    public Configuration getRuntimeConfiguration() {
        if (this.runtimeConfig == null) {
            String configName = ApplicationDeploymentClasspathBuilder.getFinalRuntimeConfigName(this.mode);
            this.runtimeConfig = (Configuration)this.project.getConfigurations().findByName(configName);
            if (this.runtimeConfig == null) {
                this.runtimeConfig = DependencyUtils.duplicateConfiguration(this.project, configName, this.getConditionalDependenciesEnabler().getBaseRuntimeConfiguration());
            }
        }
        return this.runtimeConfig;
    }

    public Configuration getDeploymentConfiguration() {
        String deploymentConfigurationName = ToolingUtils.toDeploymentConfigurationName(this.runtimeConfig.getName());
        Configuration deploymentConfig = (Configuration)this.project.getConfigurations().findByName(deploymentConfigurationName);
        if (deploymentConfig != null) {
            return deploymentConfig;
        }
        Collection<ExtensionDependency> allExtensions = this.getConditionalDependenciesEnabler().getAllExtensions();
        Set<ExtensionDependency> extensions = this.collectFirstMetQuarkusExtensions(this.getRuntimeConfiguration(), allExtensions);
        for (ExtensionDependency knownExtension : allExtensions) {
            if (!knownExtension.isConditional()) continue;
            extensions.add(knownExtension);
        }
        return (Configuration)this.project.getConfigurations().create(deploymentConfigurationName, config -> {
            config.withDependencies(ds -> ds.addAll(this.enforcedPlatforms));
            HashSet<ModuleVersionIdentifier> alreadyProcessed = new HashSet<ModuleVersionIdentifier>(extensions.size());
            DependencyHandler dependencies = this.project.getDependencies();
            for (ExtensionDependency extension : extensions) {
                if (extension instanceof LocalExtensionDependency) {
                    DependencyUtils.addLocalDeploymentDependency(deploymentConfigurationName, (LocalExtensionDependency)extension, dependencies);
                    continue;
                }
                if (!alreadyProcessed.add(extension.getExtensionId())) continue;
                DependencyUtils.requireDeploymentDependency(deploymentConfigurationName, extension, dependencies);
            }
        });
    }

    private ConditionalDependenciesEnabler getConditionalDependenciesEnabler() {
        if (this.cdEnabler == null) {
            this.cdEnabler = new ConditionalDependenciesEnabler(this.project, this.mode, this.enforcedPlatforms);
        }
        return this.cdEnabler;
    }

    private Set<ExtensionDependency> collectFirstMetQuarkusExtensions(Configuration configuration, Collection<ExtensionDependency> knownExtensions) {
        HashSet<ExtensionDependency> firstLevelExtensions = new HashSet<ExtensionDependency>();
        Set firstLevelModuleDependencies = configuration.getResolvedConfiguration().getFirstLevelModuleDependencies();
        HashSet<String> visitedArtifacts = new HashSet<String>();
        for (ResolvedDependency firstLevelModuleDependency : firstLevelModuleDependencies) {
            firstLevelExtensions.addAll(this.collectQuarkusExtensions(firstLevelModuleDependency, visitedArtifacts, knownExtensions));
        }
        return firstLevelExtensions;
    }

    private Set<ExtensionDependency> collectQuarkusExtensions(ResolvedDependency dependency, Set<String> visitedArtifacts, Collection<ExtensionDependency> knownExtensions) {
        String artifactKey = String.format("%s:%s", dependency.getModuleGroup(), dependency.getModuleName());
        if (!visitedArtifacts.add(artifactKey)) {
            return Collections.emptySet();
        }
        LinkedHashSet<ExtensionDependency> extensions = new LinkedHashSet<ExtensionDependency>();
        ExtensionDependency extension = this.getExtensionOrNull(dependency.getModuleGroup(), dependency.getModuleName(), dependency.getModuleVersion(), knownExtensions);
        if (extension != null) {
            extensions.add(extension);
        } else {
            for (ResolvedDependency child : dependency.getChildren()) {
                extensions.addAll(this.collectQuarkusExtensions(child, visitedArtifacts, knownExtensions));
            }
        }
        return extensions;
    }

    private ExtensionDependency getExtensionOrNull(String group, String artifact, String version, Collection<ExtensionDependency> knownExtensions) {
        for (ExtensionDependency knownExtension : knownExtensions) {
            if (!group.equals(knownExtension.getGroup()) || !artifact.equals(knownExtension.getName()) || !version.equals(knownExtension.getVersion())) continue;
            return knownExtension;
        }
        return null;
    }
}

