/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.extension;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.gradle.api.GradleException;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.jetbrains.annotations.NotNull;

public class ConfigurationUtils {
    private static Object callGetter(@NotNull Object extensionConfiguration, String getterName) {
        Method getterMethod;
        try {
            getterMethod = extensionConfiguration.getClass().getMethod(getterName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new GradleException("Didn't find method " + getterName + " on class " + extensionConfiguration.getClass().getName(), (Throwable)e);
        }
        try {
            return getterMethod.invoke(extensionConfiguration, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new GradleException("Failed to call method " + getterName + " on class " + extensionConfiguration.getClass().getName(), (Throwable)e);
        }
    }

    public static Property<String> getDeploymentModule(@NotNull Object extensionConfiguration) {
        return (Property)ConfigurationUtils.callGetter(extensionConfiguration, "getDeploymentModule");
    }

    public static ListProperty<String> getConditionalDependencies(@NotNull Object extensionConfiguration) {
        return (ListProperty)ConfigurationUtils.callGetter(extensionConfiguration, "getConditionalDependencies");
    }

    public static ListProperty<String> getDependencyConditions(@NotNull Object extensionConfiguration) {
        return (ListProperty)ConfigurationUtils.callGetter(extensionConfiguration, "getDependencyConditions");
    }
}

