/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tooling;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.model.gradle.ModelParameter;
import io.quarkus.bootstrap.model.gradle.impl.ModelParameterImpl;
import io.quarkus.gradle.tooling.GradleApplicationModelBuilder;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.runtime.LaunchMode;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.attributes.Category;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.composite.internal.DefaultIncludedBuild;
import org.gradle.internal.composite.IncludedBuildInternal;
import org.gradle.internal.composite.IncludedRootBuild;

public class ToolingUtils {
    private static final String DEPLOYMENT_CONFIGURATION_SUFFIX = "Deployment";
    private static final String PLATFORM_CONFIGURATION_SUFFIX = "Platform";
    public static final String DEV_MODE_CONFIGURATION_NAME = "quarkusDev";

    public static String toDeploymentConfigurationName(String baseConfigurationName) {
        return baseConfigurationName + DEPLOYMENT_CONFIGURATION_SUFFIX;
    }

    public static String toPlatformConfigurationName(String baseConfigurationName) {
        return baseConfigurationName + PLATFORM_CONFIGURATION_SUFFIX;
    }

    public static boolean isEnforcedPlatform(ModuleDependency module) {
        Category category = (Category)module.getAttributes().getAttribute(Category.CATEGORY_ATTRIBUTE);
        return category != null && ("enforced-platform".equals(category.getName()) || "platform".equals(category.getName()));
    }

    public static IncludedBuild includedBuild(Project project, String buildName) {
        for (Gradle currentGradle = project.getRootProject().getGradle(); null != currentGradle; currentGradle = currentGradle.getParent()) {
            for (IncludedBuild ib : currentGradle.getIncludedBuilds()) {
                if (ib instanceof IncludedRootBuild || !ib.getName().equals(buildName)) continue;
                return ib;
            }
        }
        return null;
    }

    public static Project includedBuildProject(IncludedBuildInternal includedBuild, String projectPath) {
        return includedBuild.getTarget().getMutableModel().getRootProject().findProject(projectPath);
    }

    public static Project findLocalProject(Project project, String projectPath) {
        if (projectPath.startsWith(":")) {
            return project.getRootProject().findProject(projectPath);
        }
        for (Project currentProject = project; currentProject != null; currentProject = currentProject.getParent()) {
            Project foundProject = currentProject.findProject(projectPath);
            if (foundProject == null) continue;
            return foundProject;
        }
        return null;
    }

    public static Project findLocalProject(Project project, ArtifactCoords artifactCoords) {
        for (Project subproject : project.getRootProject().getSubprojects()) {
            if (!subproject.getGroup().equals(artifactCoords.getGroupId()) || !subproject.getName().equals(artifactCoords.getArtifactId()) || artifactCoords.getVersion() != null && !subproject.getVersion().equals(artifactCoords.getVersion())) continue;
            return subproject;
        }
        return null;
    }

    public static Project findIncludedProject(Project project, ExternalModuleDependency dependency) {
        for (IncludedBuild ib : project.getRootProject().getGradle().getIncludedBuilds()) {
            Project includedBuildProject;
            if (ib instanceof IncludedRootBuild || (includedBuildProject = ToolingUtils.findIncludedBuildProject(ib, dependency)) == null) continue;
            return includedBuildProject;
        }
        try {
            Gradle parentGradle = project.getRootProject().getGradle().getParent();
            if (parentGradle != null) {
                return ToolingUtils.findIncludedProject(parentGradle.getRootProject(), dependency);
            }
            return null;
        }
        catch (IllegalStateException ise) {
            return null;
        }
    }

    private static Project findLocalProject(Project project, ExternalModuleDependency dependency) {
        for (Project p : project.getRootProject().getSubprojects()) {
            if (!Objects.equals(p.getGroup(), dependency.getGroup()) || !Objects.equals(p.getName(), dependency.getName()) || dependency.getVersion() != null && !Objects.equals(p.getVersion(), dependency.getVersion())) continue;
            return p;
        }
        return null;
    }

    private static Project findIncludedBuildProject(IncludedBuild ib, ExternalModuleDependency dependency) {
        if (!(ib instanceof DefaultIncludedBuild.IncludedBuildImpl)) {
            return null;
        }
        DefaultIncludedBuild.IncludedBuildImpl dib = (DefaultIncludedBuild.IncludedBuildImpl)ib;
        try {
            ProjectInternal rootProject = dib.getTarget().getMutableModel().getRootProject();
            return ToolingUtils.findLocalProject((Project)rootProject, dependency);
        }
        catch (IllegalStateException ise) {
            return null;
        }
    }

    public static Path serializeAppModel(ApplicationModel appModel, Task context, boolean test) throws IOException {
        Path serializedModel = context.getTemporaryDir().toPath().resolve("quarkus-app" + (test ? "-test" : "") + "-model.dat");
        try (ObjectOutputStream out = new ObjectOutputStream(Files.newOutputStream(serializedModel, new OpenOption[0]));){
            out.writeObject(appModel);
        }
        return serializedModel;
    }

    public static ApplicationModel create(Project project, LaunchMode mode) {
        ModelParameterImpl params = new ModelParameterImpl();
        params.setMode(mode.toString());
        return ToolingUtils.create(project, (ModelParameter)params);
    }

    public static ApplicationModel create(Project project, ModelParameter params) {
        return (ApplicationModel)new GradleApplicationModelBuilder().buildAll(ApplicationModel.class.getName(), params, project);
    }
}

