/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tooling.dependency;

import io.quarkus.bootstrap.util.BootstrapUtils;
import io.quarkus.fs.util.ZipUtils;
import io.quarkus.gradle.extension.ConfigurationUtils;
import io.quarkus.gradle.tooling.ToolingUtils;
import io.quarkus.gradle.tooling.dependency.ArtifactExtensionDependency;
import io.quarkus.gradle.tooling.dependency.ExtensionDependency;
import io.quarkus.gradle.tooling.dependency.ProjectExtensionDependency;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.maven.dependency.GACTV;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.dependencies.DefaultExternalModuleDependency;
import org.gradle.api.internal.artifacts.dependencies.DefaultProjectDependency;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.internal.composite.IncludedBuildInternal;
import org.jetbrains.annotations.Nullable;

public class DependencyUtils {
    private static final String COPY_CONFIGURATION_NAME = "quarkusDependency";
    private static final String TEST_FIXTURE_SUFFIX = "-test-fixtures";

    public static Configuration duplicateConfiguration(Project project, Configuration toDuplicate) {
        Configuration configurationCopy = (Configuration)project.getConfigurations().findByName(COPY_CONFIGURATION_NAME);
        if (configurationCopy != null) {
            project.getConfigurations().remove((Object)configurationCopy);
        }
        return DependencyUtils.duplicateConfiguration(project, COPY_CONFIGURATION_NAME, toDuplicate);
    }

    public static Configuration duplicateConfiguration(Project project, String name, Configuration toDuplicate) {
        Configuration configurationCopy = (Configuration)project.getConfigurations().create(name);
        configurationCopy.getDependencies().addAll((Collection)toDuplicate.getAllDependencies());
        configurationCopy.getDependencyConstraints().addAll((Collection)toDuplicate.getAllDependencyConstraints());
        return configurationCopy;
    }

    public static boolean isTestFixtureDependency(Dependency dependency) {
        if (!(dependency instanceof ModuleDependency)) {
            return false;
        }
        ModuleDependency module = (ModuleDependency)dependency;
        for (Capability requestedCapability : module.getRequestedCapabilities()) {
            if (!requestedCapability.getName().endsWith(TEST_FIXTURE_SUFFIX)) continue;
            return true;
        }
        return false;
    }

    public static String asDependencyNotation(Dependency dependency) {
        return String.join((CharSequence)":", dependency.getGroup(), dependency.getName(), dependency.getVersion());
    }

    public static String asDependencyNotation(ArtifactCoords artifactCoords) {
        return String.join((CharSequence)":", artifactCoords.getGroupId(), artifactCoords.getArtifactId(), artifactCoords.getVersion());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ExtensionDependency<?> getExtensionInfoOrNull(Project project, ResolvedArtifact artifact) {
        ProjectComponentIdentifier componentId;
        ExtensionDependency<?> projectDependency;
        ModuleVersionIdentifier artifactId = artifact.getModuleVersion().getId();
        if (artifact.getId().getComponentIdentifier() instanceof ProjectComponentIdentifier && (projectDependency = DependencyUtils.getProjectExtensionDependencyOrNull(project, (componentId = (ProjectComponentIdentifier)artifact.getId().getComponentIdentifier()).getProjectPath(), componentId.getBuild().getName())) != null) {
            return projectDependency;
        }
        Project localExtensionProject = ToolingUtils.findLocalProject(project, ArtifactCoords.of((String)artifactId.getGroup(), (String)artifactId.getName(), null, null, (String)artifactId.getVersion()));
        if (localExtensionProject != null && (projectDependency = DependencyUtils.getExtensionInfoOrNull(project, localExtensionProject)) != null) {
            return projectDependency;
        }
        File artifactFile = artifact.getFile();
        if (!artifactFile.exists()) {
            return null;
        }
        if (artifactFile.isDirectory()) {
            Path descriptorPath = artifactFile.toPath().resolve("META-INF/quarkus-extension.properties");
            if (!Files.isRegularFile(descriptorPath, new LinkOption[0])) return null;
            return DependencyUtils.createExtensionDependency(project, artifactId, descriptorPath);
        }
        if (!"jar".equals(artifact.getExtension())) return null;
        try (FileSystem artifactFs = ZipUtils.newFileSystem((Path)artifactFile.toPath());){
            Path descriptorPath = artifactFs.getPath("META-INF/quarkus-extension.properties", new String[0]);
            if (!Files.exists(descriptorPath, new LinkOption[0])) return null;
            ArtifactExtensionDependency artifactExtensionDependency = DependencyUtils.createExtensionDependency(project, artifactId, descriptorPath);
            return artifactExtensionDependency;
        }
        catch (IOException x) {
            throw new GradleException("Failed to read " + String.valueOf(artifactFile), (Throwable)x);
        }
    }

    public static ExtensionDependency<?> getExtensionInfoOrNull(Project project, Project extensionProject) {
        boolean isIncludedBuild = !project.getRootProject().getGradle().equals((Object)extensionProject.getRootProject().getGradle());
        ModuleVersionIdentifier extensionArtifactId = DefaultModuleVersionIdentifier.newId((String)extensionProject.getGroup().toString(), (String)extensionProject.getName(), (String)extensionProject.getVersion().toString());
        Object extensionConfiguration = extensionProject.getExtensions().findByName("quarkusExtension");
        Path descriptorPath = DependencyUtils.findLocalExtensionDescriptorPath(extensionProject);
        if (extensionConfiguration != null || descriptorPath != null) {
            return DependencyUtils.createExtensionDependency(project, extensionArtifactId, extensionProject, extensionConfiguration, descriptorPath != null ? DependencyUtils.loadLocalExtensionDescriptor(descriptorPath) : null, isIncludedBuild);
        }
        return null;
    }

    private static Path findLocalExtensionDescriptorPath(Project extensionProject) {
        SourceSetContainer sourceSets = (SourceSetContainer)extensionProject.getExtensions().getByType(SourceSetContainer.class);
        SourceSet mainSourceSet = (SourceSet)sourceSets.findByName("main");
        if (mainSourceSet == null) {
            return null;
        }
        Set resourcesSourceDirs = mainSourceSet.getResources().getSrcDirs();
        for (File resourceSourceDir : resourcesSourceDirs) {
            Path descriptorPath = resourceSourceDir.toPath().resolve("META-INF/quarkus-extension.properties");
            if (!Files.isRegularFile(descriptorPath, new LinkOption[0])) continue;
            return descriptorPath;
        }
        return null;
    }

    private static Properties loadLocalExtensionDescriptor(Path descriptorPath) {
        Properties descriptor = new Properties();
        try (InputStream inputStream = Files.newInputStream(descriptorPath, new OpenOption[0]);){
            descriptor.load(inputStream);
        }
        catch (IOException x) {
            throw new GradleException("Failed to load extension descriptor at " + String.valueOf(descriptorPath), (Throwable)x);
        }
        return descriptor;
    }

    @Nullable
    public static ExtensionDependency<?> getProjectExtensionDependencyOrNull(Project project, String projectPath, @Nullable String buildName) {
        IncludedBuild extProjIncludedBuild;
        Project extensionProject = project.getRootProject().findProject(projectPath);
        if (extensionProject == null && (extProjIncludedBuild = ToolingUtils.includedBuild(project, buildName)) instanceof IncludedBuildInternal) {
            extensionProject = ToolingUtils.includedBuildProject((IncludedBuildInternal)extProjIncludedBuild, projectPath);
        }
        if (extensionProject != null) {
            return DependencyUtils.getExtensionInfoOrNull(project, extensionProject);
        }
        return null;
    }

    private static ProjectExtensionDependency createExtensionDependency(Project project, ModuleVersionIdentifier extensionArtifactId, Project extensionProject, @Nullable Object extensionConfiguration, @Nullable Properties extensionDescriptor, boolean isIncludedBuild) {
        GACTV deploymentArtifact;
        if (extensionConfiguration == null && extensionDescriptor == null) {
            throw new IllegalArgumentException("both extensionConfiguration and extensionDescriptor are null");
        }
        Project deploymentProject = null;
        if (extensionConfiguration != null) {
            String deploymentProjectPath = (String)ConfigurationUtils.getDeploymentModule(extensionConfiguration).get();
            deploymentProject = ToolingUtils.findLocalProject(extensionProject, deploymentProjectPath);
            if (deploymentProject == null) {
                throw new GradleException("Cannot find deployment project for extension " + String.valueOf(extensionArtifactId) + " at path " + deploymentProjectPath);
            }
        } else if (extensionDescriptor.containsKey("deployment-artifact") && (deploymentProject = ToolingUtils.findLocalProject(project, (ArtifactCoords)(deploymentArtifact = GACTV.fromString((String)extensionDescriptor.getProperty("deployment-artifact"))))) == null) {
            throw new GradleException("Cannot find deployment project for extension " + String.valueOf(extensionArtifactId) + " with artifact coordinates " + String.valueOf(deploymentArtifact));
        }
        ArrayList<Dependency> conditionalDependencies = new ArrayList<Dependency>();
        ArrayList<ArtifactKey> dependencyConditions = new ArrayList<ArtifactKey>();
        if (extensionConfiguration != null) {
            ListProperty<String> dependencyConditionsProp;
            ListProperty<String> conditionalDependenciesProp = ConfigurationUtils.getConditionalDependencies(extensionConfiguration);
            if (conditionalDependenciesProp.isPresent()) {
                for (String rawDep : (List)conditionalDependenciesProp.get()) {
                    conditionalDependencies.add(DependencyUtils.create(project.getDependencies(), rawDep));
                }
            }
            if ((dependencyConditionsProp = ConfigurationUtils.getDependencyConditions(extensionConfiguration)).isPresent()) {
                for (String rawCond : (List)dependencyConditionsProp.get()) {
                    dependencyConditions.add((ArtifactKey)GACT.fromString((String)rawCond));
                }
            }
        }
        if (extensionDescriptor != null && extensionDescriptor.containsKey("conditional-dependencies")) {
            String[] deps;
            for (String condDep : deps = BootstrapUtils.splitByWhitespace((String)extensionDescriptor.getProperty("conditional-dependencies"))) {
                conditionalDependencies.add(DependencyUtils.create(project.getDependencies(), condDep));
            }
        }
        if (extensionDescriptor != null && extensionDescriptor.containsKey("dependency-condition")) {
            ArtifactKey[] conditions = BootstrapUtils.parseDependencyCondition((String)extensionDescriptor.getProperty("dependency-condition"));
            dependencyConditions.addAll(Arrays.asList(conditions));
        }
        return new ProjectExtensionDependency(extensionProject, deploymentProject, isIncludedBuild, conditionalDependencies, dependencyConditions);
    }

    private static ArtifactExtensionDependency createExtensionDependency(Project project, ModuleVersionIdentifier extensionArtifactId, Path descriptorPath) {
        ArtifactKey[] conditions;
        List<Dependency> conditionalDependencies;
        Properties extensionProperties = DependencyUtils.loadLocalExtensionDescriptor(descriptorPath);
        GACTV deploymentArtifact = GACTV.fromString((String)extensionProperties.getProperty("deployment-artifact"));
        if (extensionProperties.containsKey("conditional-dependencies")) {
            String[] deps = BootstrapUtils.splitByWhitespace((String)extensionProperties.getProperty("conditional-dependencies"));
            if (deps.length > 0) {
                conditionalDependencies = new ArrayList(deps.length);
                for (String condDep : deps) {
                    conditionalDependencies.add(DependencyUtils.create(project.getDependencies(), condDep));
                }
            } else {
                conditionalDependencies = Collections.emptyList();
            }
        } else {
            conditionalDependencies = Collections.emptyList();
        }
        List<Object> dependencyConditions = extensionProperties.containsKey("dependency-condition") ? ((conditions = BootstrapUtils.parseDependencyCondition((String)extensionProperties.getProperty("dependency-condition"))).length > 0 ? Arrays.asList(conditions) : Collections.emptyList()) : Collections.emptyList();
        return new ArtifactExtensionDependency(extensionArtifactId, (ArtifactCoords)deploymentArtifact, conditionalDependencies, dependencyConditions);
    }

    public static Dependency create(DependencyHandler dependencies, String conditionalDependency) {
        GACTV dependencyCoords = GACTV.fromString((String)conditionalDependency);
        return dependencies.create((Object)String.join((CharSequence)":", dependencyCoords.getGroupId(), dependencyCoords.getArtifactId(), dependencyCoords.getVersion()));
    }

    public static Dependency createDeploymentDependency(DependencyHandler dependencyHandler, ExtensionDependency<?> dependency) {
        if (dependency instanceof ProjectExtensionDependency) {
            ProjectExtensionDependency ped = (ProjectExtensionDependency)dependency;
            return DependencyUtils.createDeploymentProjectDependency(dependencyHandler, ped);
        }
        if (dependency instanceof ArtifactExtensionDependency) {
            ArtifactExtensionDependency aed = (ArtifactExtensionDependency)dependency;
            return DependencyUtils.createArtifactDeploymentDependency(dependencyHandler, aed);
        }
        throw new IllegalArgumentException("Unknown ExtensionDependency type: " + dependency.getClass().getName());
    }

    private static Dependency createDeploymentProjectDependency(DependencyHandler handler, ProjectExtensionDependency ped) {
        if (ped.isIncludedBuild().booleanValue()) {
            return new DefaultExternalModuleDependency(((Project)ped.getDeploymentModule()).getGroup().toString(), ((Project)ped.getDeploymentModule()).getName(), ((Project)ped.getDeploymentModule()).getVersion().toString());
        }
        if (ped.getDeploymentModule() instanceof ProjectInternal) {
            return handler.create((Object)new DefaultProjectDependency((ProjectInternal)ped.getDeploymentModule(), true));
        }
        return handler.create((Object)handler.project(Collections.singletonMap("path", ((Project)ped.getDeploymentModule()).getPath())));
    }

    private static Dependency createArtifactDeploymentDependency(DependencyHandler handler, ArtifactExtensionDependency dependency) {
        return handler.create((Object)(((ArtifactCoords)dependency.getDeploymentModule()).getGroupId() + ":" + ((ArtifactCoords)dependency.getDeploymentModule()).getArtifactId() + ":" + ((ArtifactCoords)dependency.getDeploymentModule()).getVersion()));
    }
}

