/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tooling.dependency;

import io.quarkus.gradle.tooling.dependency.DependencyUtils;
import io.quarkus.maven.dependency.ArtifactKey;
import java.util.List;
import java.util.Objects;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;

public abstract class ExtensionDependency<T> {
    private final ModuleVersionIdentifier extensionId;
    private final T deploymentModule;
    private final List<Dependency> conditionalDependencies;
    private final List<ArtifactKey> dependencyConditions;
    private boolean isConditional;

    public ExtensionDependency(ModuleVersionIdentifier extensionId, T deploymentModule, List<Dependency> conditionalDependencies, List<ArtifactKey> dependencyConditions) {
        this.extensionId = extensionId;
        this.deploymentModule = deploymentModule;
        this.conditionalDependencies = conditionalDependencies;
        this.dependencyConditions = dependencyConditions;
    }

    public void importConditionalDependency(DependencyHandler dependencies, ModuleVersionIdentifier capability) {
        Dependency dependency = this.findConditionalDependency(capability);
        if (dependency == null) {
            throw new GradleException("Trying to add " + capability.getName() + " variant which is not declared by " + this.extensionId.getName() + " extension.");
        }
        dependencies.components(handler -> handler.withModule((Object)this.toModuleName(), componentMetadataDetails -> componentMetadataDetails.allVariants(variantMetadata -> variantMetadata.withDependencies(d -> d.add(DependencyUtils.asDependencyNotation(dependency))))));
    }

    private Dependency findConditionalDependency(ModuleVersionIdentifier capability) {
        for (Dependency conditionalDependency : this.conditionalDependencies) {
            if (!conditionalDependency.getGroup().equals(capability.getGroup()) || !conditionalDependency.getName().equals(capability.getName())) continue;
            return conditionalDependency;
        }
        return null;
    }

    public String toModuleName() {
        return String.join((CharSequence)":", this.extensionId.getGroup(), this.extensionId.getName());
    }

    public String getGroup() {
        return this.extensionId.getGroup();
    }

    public String getName() {
        return this.extensionId.getName();
    }

    public String getVersion() {
        return this.extensionId.getVersion();
    }

    public ModuleVersionIdentifier getExtensionId() {
        return this.extensionId;
    }

    public List<ArtifactKey> getDependencyConditions() {
        return this.dependencyConditions;
    }

    public List<Dependency> getConditionalDependencies() {
        return this.conditionalDependencies;
    }

    public T getDeploymentModule() {
        return this.deploymentModule;
    }

    public boolean isConditional() {
        return this.isConditional;
    }

    public void setConditional(boolean isConditional) {
        this.isConditional = isConditional;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionDependency that = (ExtensionDependency)o;
        return Objects.equals(this.extensionId, that.extensionId) && Objects.equals(this.conditionalDependencies, that.conditionalDependencies) && Objects.equals(this.dependencyConditions, that.dependencyConditions);
    }

    public int hashCode() {
        return Objects.hash(this.extensionId, this.conditionalDependencies, this.dependencyConditions);
    }
}

