/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tooling;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.model.ApplicationModelBuilder;
import io.quarkus.bootstrap.model.CapabilityContract;
import io.quarkus.bootstrap.model.ExtensionCapabilities;
import io.quarkus.bootstrap.model.PlatformImports;
import io.quarkus.bootstrap.model.gradle.ModelParameter;
import io.quarkus.bootstrap.model.gradle.impl.ModelParameterImpl;
import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.DefaultArtifactSources;
import io.quarkus.bootstrap.workspace.DefaultSourceDir;
import io.quarkus.bootstrap.workspace.DefaultWorkspaceModule;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.bootstrap.workspace.WorkspaceModuleId;
import io.quarkus.fs.util.ZipUtils;
import io.quarkus.gradle.dependency.ApplicationDeploymentClasspathBuilder;
import io.quarkus.gradle.tooling.ProjectDescriptorBuilder;
import io.quarkus.gradle.tooling.ToolingUtils;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactDependency;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.maven.dependency.GACTV;
import io.quarkus.maven.dependency.ResolvedDependencyBuilder;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.util.HashUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.composite.IncludedBuildInternal;
import org.gradle.language.jvm.tasks.ProcessResources;
import org.gradle.tooling.provider.model.ParameterizedToolingModelBuilder;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompileTool;

public class GradleApplicationModelBuilder
implements ParameterizedToolingModelBuilder<ModelParameter> {
    private static final String MAIN_RESOURCES_OUTPUT = "build/resources/main";
    private static final String CLASSES_OUTPUT = "build/classes";
    private static final byte COLLECT_TOP_EXTENSION_RUNTIME_NODES = 1;
    private static final byte COLLECT_DIRECT_DEPS = 2;
    private static final byte COLLECT_RELOADABLE_MODULES = 4;

    public boolean canBuild(String modelName) {
        return modelName.equals(ApplicationModel.class.getName());
    }

    public Class<ModelParameter> getParameterType() {
        return ModelParameter.class;
    }

    public Object buildAll(String modelName, Project project) {
        ModelParameterImpl modelParameter = new ModelParameterImpl();
        modelParameter.setMode(LaunchMode.DEVELOPMENT.toString());
        return this.buildAll(modelName, (ModelParameter)modelParameter, project);
    }

    public Object buildAll(String modelName, ModelParameter parameter, Project project) {
        Object o;
        boolean workspaceDiscovery;
        LaunchMode mode = LaunchMode.valueOf((String)parameter.getMode());
        ApplicationDeploymentClasspathBuilder classpathBuilder = new ApplicationDeploymentClasspathBuilder(project, mode);
        Configuration classpathConfig = classpathBuilder.getRuntimeConfiguration();
        Configuration deploymentConfig = classpathBuilder.getDeploymentConfiguration();
        PlatformImports platformImports = classpathBuilder.getPlatformImports();
        boolean bl = workspaceDiscovery = LaunchMode.DEVELOPMENT.equals((Object)mode) || LaunchMode.TEST.equals((Object)mode) || Boolean.parseBoolean(System.getProperty("quarkus.bootstrap.workspace-discovery"));
        if (!workspaceDiscovery && (o = project.getProperties().get("quarkus.bootstrap.workspace-discovery")) != null) {
            workspaceDiscovery = Boolean.parseBoolean(o.toString());
        }
        ResolvedDependencyBuilder appArtifact = GradleApplicationModelBuilder.getProjectArtifact(project, workspaceDiscovery);
        ApplicationModelBuilder modelBuilder = new ApplicationModelBuilder().setAppArtifact(appArtifact).addReloadableWorkspaceModule(appArtifact.getKey()).setPlatformImports(platformImports);
        this.collectDependencies(classpathConfig.getResolvedConfiguration(), workspaceDiscovery, project, modelBuilder, appArtifact.getWorkspaceModule().mutable());
        this.collectExtensionDependencies(project, deploymentConfig, modelBuilder);
        GradleApplicationModelBuilder.addCompileOnly(project, classpathBuilder, modelBuilder);
        return modelBuilder.build();
    }

    private static void addCompileOnly(Project project, ApplicationDeploymentClasspathBuilder classpathBuilder, ApplicationModelBuilder modelBuilder) {
        Configuration compileOnlyConfig = classpathBuilder.getCompileOnly();
        ArrayList queue = new ArrayList(compileOnlyConfig.getResolvedConfiguration().getFirstLevelModuleDependencies());
        for (int i = 0; i < queue.size(); ++i) {
            ResolvedDependency d = (ResolvedDependency)queue.get(i);
            boolean skip = true;
            for (ResolvedArtifact a : d.getModuleArtifacts()) {
                if (!GradleApplicationModelBuilder.isDependency(a)) continue;
                ModuleVersionIdentifier moduleId = a.getModuleVersion().getId();
                ArtifactKey key = ArtifactKey.of((String)moduleId.getGroup(), (String)moduleId.getName(), (String)a.getClassifier(), (String)a.getType());
                ResolvedDependencyBuilder appDep = modelBuilder.getDependency(key);
                if (appDep == null) {
                    GradleApplicationModelBuilder.addArtifactDependency(project, modelBuilder, a);
                    appDep = modelBuilder.getDependency(key);
                    appDep.clearFlag(8);
                }
                if (appDep.isFlagSet(4096)) continue;
                skip = false;
                appDep.setFlags(4096);
            }
            if (skip) continue;
            queue.addAll(d.getChildren());
        }
    }

    public static ResolvedDependencyBuilder getProjectArtifact(Project project, boolean workspaceDiscovery) {
        TaskCollection testTasks;
        ResolvedDependencyBuilder appArtifact = (ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setGroupId(project.getGroup().toString())).setArtifactId(project.getName())).setVersion(project.getVersion().toString());
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        WorkspaceModule.Mutable mainModule = WorkspaceModule.builder().setModuleId(WorkspaceModuleId.of((String)appArtifact.getGroupId(), (String)appArtifact.getArtifactId(), (String)appArtifact.getVersion())).setModuleDir(project.getProjectDir().toPath()).setBuildDir(project.getBuildDir().toPath()).setBuildFile(project.getBuildFile().toPath());
        GradleApplicationModelBuilder.initProjectModule(project, mainModule, (SourceSet)sourceSets.getByName("main"), "");
        if (workspaceDiscovery && !(testTasks = project.getTasks().withType(Test.class)).isEmpty()) {
            HashMap sourceSetsByClassesDir = new HashMap();
            sourceSets.forEach(s -> s.getOutput().getClassesDirs().forEach(d -> {
                if (d.exists()) {
                    sourceSetsByClassesDir.put(d, s);
                }
            }));
            testTasks.forEach(t -> {
                if (t.getEnabled()) {
                    t.getTestClassesDirs().forEach(d -> {
                        SourceSet sourceSet;
                        if (d.exists() && (sourceSet = (SourceSet)sourceSetsByClassesDir.remove(d)) != null) {
                            GradleApplicationModelBuilder.initProjectModule(project, mainModule, sourceSet, sourceSet.getName().equals("test") ? "tests" : sourceSet.getName());
                        }
                    });
                }
            });
        }
        PathList.Builder paths = PathList.builder();
        GradleApplicationModelBuilder.collectDestinationDirs(mainModule.getMainSources().getSourceDirs(), paths);
        GradleApplicationModelBuilder.collectDestinationDirs(mainModule.getMainSources().getResourceDirs(), paths);
        return appArtifact.setWorkspaceModule((WorkspaceModule)mainModule).setResolvedPaths((PathCollection)paths.build());
    }

    private static void collectDestinationDirs(Collection<SourceDir> sources, PathList.Builder paths) {
        for (SourceDir src : sources) {
            Path path = src.getOutputDir();
            if (paths.contains(path) || !Files.exists(path, new LinkOption[0])) continue;
            paths.add(path);
        }
    }

    private void collectExtensionDependencies(Project project, Configuration deploymentConfiguration, ApplicationModelBuilder modelBuilder) {
        ResolvedConfiguration rc = deploymentConfiguration.getResolvedConfiguration();
        for (ResolvedArtifact a : rc.getResolvedArtifacts()) {
            GradleApplicationModelBuilder.addArtifactDependency(project, modelBuilder, a);
        }
    }

    private static void addArtifactDependency(Project project, ApplicationModelBuilder modelBuilder, ResolvedArtifact a) {
        if (a.getId().getComponentIdentifier() instanceof ProjectComponentIdentifier) {
            ProjectComponentIdentifier projectComponentIdentifier = (ProjectComponentIdentifier)a.getId().getComponentIdentifier();
            IncludedBuild includedBuild = ToolingUtils.includedBuild(project, projectComponentIdentifier.getBuild().getName());
            Project projectDep = includedBuild != null ? ToolingUtils.includedBuildProject((IncludedBuildInternal)includedBuild, projectComponentIdentifier.getProjectPath()) : project.getRootProject().findProject(projectComponentIdentifier.getProjectPath());
            Objects.requireNonNull(projectDep, () -> "project " + projectComponentIdentifier.getProjectPath() + " should exist");
            SourceSetContainer sourceSets = (SourceSetContainer)projectDep.getExtensions().getByType(SourceSetContainer.class);
            SourceSet mainSourceSet = (SourceSet)sourceSets.getByName("main");
            ResolvedDependencyBuilder dep = modelBuilder.getDependency(GradleApplicationModelBuilder.toAppDependenciesKey(a.getModuleVersion().getId().getGroup(), a.getName(), a.getClassifier()));
            if (dep == null) {
                dep = GradleApplicationModelBuilder.toDependency(a, mainSourceSet);
                modelBuilder.addDependency(dep);
            }
            dep.setDeploymentCp();
            dep.clearFlag(64);
        } else if (GradleApplicationModelBuilder.isDependency(a)) {
            ResolvedDependencyBuilder dep = modelBuilder.getDependency(GradleApplicationModelBuilder.toAppDependenciesKey(a.getModuleVersion().getId().getGroup(), a.getName(), a.getClassifier()));
            if (dep == null) {
                dep = GradleApplicationModelBuilder.toDependency(a, new int[0]);
                modelBuilder.addDependency(dep);
            }
            dep.setDeploymentCp();
            dep.clearFlag(64);
        }
    }

    private void collectDependencies(ResolvedConfiguration configuration, boolean workspaceDiscovery, Project project, ApplicationModelBuilder modelBuilder, WorkspaceModule.Mutable wsModule) {
        Set resolvedArtifacts = configuration.getResolvedArtifacts();
        HashSet artifactFiles = resolvedArtifacts.size() < configuration.getFiles().size() ? new HashSet(resolvedArtifacts.size()) : null;
        configuration.getFirstLevelModuleDependencies().forEach(d -> this.collectDependencies((ResolvedDependency)d, workspaceDiscovery, project, artifactFiles, (Set<ArtifactKey>)new HashSet<ArtifactKey>(), modelBuilder, wsModule, (byte)7));
        if (artifactFiles != null) {
            for (File f : configuration.getFiles()) {
                int dot;
                if (artifactFiles.contains(f) || !f.exists()) continue;
                String parentPath = f.getParent();
                String group = HashUtil.sha1((String)(parentPath == null ? f.getName() : parentPath));
                String name = f.getName();
                String type = "jar";
                if (!f.isDirectory() && (dot = f.getName().lastIndexOf(46)) > 0) {
                    name = f.getName().substring(0, dot);
                    type = f.getName().substring(dot + 1);
                }
                String version = String.valueOf(f.lastModified());
                ResolvedDependencyBuilder artifactBuilder = (ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setGroupId(group)).setArtifactId(name)).setType(type)).setVersion(version)).setResolvedPath(f.toPath()).setDirect(true)).setRuntimeCp()).setDeploymentCp();
                this.processQuarkusDependency(artifactBuilder, modelBuilder);
                modelBuilder.addDependency(artifactBuilder);
            }
        }
    }

    private void collectDependencies(ResolvedDependency resolvedDep, boolean workspaceDiscovery, Project project, Set<File> artifactFiles, Set<ArtifactKey> processedModules, ApplicationModelBuilder modelBuilder, WorkspaceModule.Mutable parentModule, byte flags) {
        WorkspaceModule.Mutable projectModule = null;
        for (ResolvedArtifact a : resolvedDep.getModuleArtifacts()) {
            ComponentIdentifier componentIdentifier;
            ArtifactKey artifactKey = GradleApplicationModelBuilder.toAppDependenciesKey(a.getModuleVersion().getId().getGroup(), a.getName(), a.getClassifier());
            if (!GradleApplicationModelBuilder.isDependency(a)) continue;
            ResolvedDependencyBuilder depBuilder = modelBuilder.getDependency(artifactKey);
            if (depBuilder != null) {
                if (!GradleApplicationModelBuilder.isFlagOn(flags, (byte)2)) continue;
                depBuilder.setDirect(true);
                continue;
            }
            ArtifactCoords depCoords = GradleApplicationModelBuilder.toArtifactCoords(a);
            depBuilder = (ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setCoords(depCoords)).setRuntimeCp()).setDeploymentCp();
            if (GradleApplicationModelBuilder.isFlagOn(flags, (byte)2)) {
                depBuilder.setDirect(true);
                flags = GradleApplicationModelBuilder.clearFlag(flags, (byte)2);
            }
            if (parentModule != null) {
                parentModule.addDependency((Dependency)new ArtifactDependency(depCoords, new int[0]));
            }
            PathList paths = null;
            if (workspaceDiscovery && (componentIdentifier = a.getId().getComponentIdentifier()) instanceof ProjectComponentIdentifier) {
                ProjectComponentIdentifier compId = (ProjectComponentIdentifier)componentIdentifier;
                Project projectDep = project.getRootProject().findProject(compId.getProjectPath());
                String classifier = a.getClassifier();
                if (classifier == null || classifier.isEmpty()) {
                    IncludedBuild includedBuild = ToolingUtils.includedBuild(project.getRootProject(), compId.getBuild().getName());
                    if (includedBuild != null) {
                        if (includedBuild instanceof IncludedBuildInternal) {
                            IncludedBuildInternal ib = (IncludedBuildInternal)includedBuild;
                            projectDep = ToolingUtils.includedBuildProject(ib, compId.getProjectPath());
                        }
                        if (projectDep != null) {
                            this.initProjectModuleAndBuildPaths(projectDep, a, modelBuilder, depBuilder);
                        } else {
                            PathList.Builder pathBuilder = PathList.builder();
                            this.addSubstitutedProject(pathBuilder, includedBuild.getProjectDir());
                            paths = pathBuilder.build();
                        }
                    } else {
                        this.initProjectModuleAndBuildPaths(projectDep, a, modelBuilder, depBuilder);
                    }
                } else {
                    this.initProjectModuleAndBuildPaths(projectDep, a, modelBuilder, depBuilder);
                }
            }
            depBuilder.setResolvedPaths(paths == null ? PathList.of((Path[])new Path[]{a.getFile().toPath()}) : paths);
            if (this.processQuarkusDependency(depBuilder, modelBuilder)) {
                if (GradleApplicationModelBuilder.isFlagOn(flags, (byte)1)) {
                    depBuilder.setFlags(128);
                    flags = GradleApplicationModelBuilder.clearFlag(flags, (byte)1);
                }
                flags = GradleApplicationModelBuilder.clearFlag(flags, (byte)4);
            }
            if (!GradleApplicationModelBuilder.isFlagOn(flags, (byte)4)) {
                depBuilder.clearFlag(64);
            }
            modelBuilder.addDependency(depBuilder);
            if (projectModule == null && depBuilder.getWorkspaceModule() != null) {
                projectModule = depBuilder.getWorkspaceModule().mutable();
            }
            if (artifactFiles == null) continue;
            artifactFiles.add(a.getFile());
        }
        processedModules.add(ArtifactKey.ga((String)resolvedDep.getModuleGroup(), (String)resolvedDep.getModuleName()));
        for (ResolvedDependency child : resolvedDep.getChildren()) {
            if (processedModules.contains(new GACT(child.getModuleGroup(), child.getModuleName()))) continue;
            this.collectDependencies(child, workspaceDiscovery, project, artifactFiles, processedModules, modelBuilder, projectModule, flags);
        }
    }

    private static String toNonNullClassifier(String resolvedClassifier) {
        return resolvedClassifier == null ? "" : resolvedClassifier;
    }

    private void initProjectModuleAndBuildPaths(Project project, ResolvedArtifact resolvedArtifact, ApplicationModelBuilder appModel, ResolvedDependencyBuilder appDep) {
        ((ResolvedDependencyBuilder)appDep.setWorkspaceModule()).setReloadable();
        if (appDep.getWorkspaceModule() == null) {
            WorkspaceModule.Mutable projectModule = appModel.getOrCreateProjectModule(WorkspaceModuleId.of((String)resolvedArtifact.getModuleVersion().getId().getGroup(), (String)resolvedArtifact.getName(), (String)resolvedArtifact.getModuleVersion().getId().getVersion()), project.getProjectDir(), ((Directory)project.getLayout().getBuildDirectory().get()).getAsFile()).setBuildFile(project.getBuildFile().toPath());
            ProjectDescriptorBuilder.initSourceDirs(project, projectModule);
            appDep.setWorkspaceModule((WorkspaceModule)projectModule);
        }
        appModel.addReloadableWorkspaceModule(appDep.getKey());
    }

    private boolean processQuarkusDependency(ResolvedDependencyBuilder artifactBuilder, ApplicationModelBuilder modelBuilder) {
        Path artifactPath;
        Iterator iterator = artifactBuilder.getResolvedPaths().iterator();
        if (iterator.hasNext() && Files.exists(artifactPath = (Path)iterator.next(), new LinkOption[0]) && artifactBuilder.getType().equals("jar")) {
            boolean bl;
            block10: {
                if (Files.isDirectory(artifactPath, new LinkOption[0])) {
                    return GradleApplicationModelBuilder.processQuarkusDir(artifactBuilder, artifactPath.resolve("META-INF"), modelBuilder);
                }
                FileSystem artifactFs = ZipUtils.newFileSystem((Path)artifactPath);
                try {
                    bl = GradleApplicationModelBuilder.processQuarkusDir(artifactBuilder, artifactFs.getPath("META-INF", new String[0]), modelBuilder);
                    if (artifactFs == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (artifactFs != null) {
                            try {
                                artifactFs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to process " + String.valueOf(artifactPath), e);
                    }
                }
                artifactFs.close();
            }
            return bl;
        }
        return false;
    }

    private static boolean processQuarkusDir(ResolvedDependencyBuilder artifactBuilder, Path quarkusDir, ApplicationModelBuilder modelBuilder) {
        if (!Files.exists(quarkusDir, new LinkOption[0])) {
            return false;
        }
        Path quarkusDescr = quarkusDir.resolve("quarkus-extension.properties");
        if (!Files.exists(quarkusDescr, new LinkOption[0])) {
            return false;
        }
        Properties extProps = GradleApplicationModelBuilder.readDescriptor(quarkusDescr);
        if (extProps == null) {
            return false;
        }
        artifactBuilder.setRuntimeExtensionArtifact();
        modelBuilder.handleExtensionProperties(extProps, artifactBuilder.getKey());
        String providesCapabilities = extProps.getProperty("provides-capabilities");
        if (providesCapabilities != null) {
            modelBuilder.addExtensionCapabilities((ExtensionCapabilities)CapabilityContract.of((String)artifactBuilder.toGACTVString(), (String)providesCapabilities, null));
        }
        return true;
    }

    private static Properties readDescriptor(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        Properties rtProps = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(path);){
            rtProps.load(reader);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to load extension description " + String.valueOf(path), e);
        }
        return rtProps;
    }

    private static void initProjectModule(Project project, WorkspaceModule.Mutable module, SourceSet sourceSet, String classifier) {
        if (sourceSet == null) {
            return;
        }
        FileCollection allClassesDirs = sourceSet.getOutput().getClassesDirs();
        ArrayList<SourceDir> sourceDirs = new ArrayList<SourceDir>(1);
        project.getTasks().withType(AbstractCompile.class, t -> GradleApplicationModelBuilder.configureCompileTask(t.getSource(), t.getDestinationDirectory(), allClassesDirs, sourceDirs, (Task)t, sourceSet));
        GradleApplicationModelBuilder.maybeConfigureKotlinJvmCompile(project, allClassesDirs, sourceDirs, sourceSet);
        LinkedHashMap resourceDirs = new LinkedHashMap(1);
        File resourcesOutputDir = sourceSet.getOutput().getResourcesDir();
        project.getTasks().withType(ProcessResources.class, t -> {
            if (!t.getEnabled()) {
                return;
            }
            FileCollection source = t.getSource();
            if (source.isEmpty()) {
                return;
            }
            if (!t.getDestinationDir().equals(resourcesOutputDir)) {
                return;
            }
            Path destDir = t.getDestinationDir().toPath();
            source.getAsFileTree().visit(a -> {
                if (a.getRelativePath().getSegments().length == 1) {
                    File srcDir = a.getFile().getParentFile();
                    resourceDirs.put(srcDir, destDir);
                }
            });
        });
        if (resourcesOutputDir.exists() && resourceDirs.isEmpty()) {
            sourceSet.getResources().getSrcDirs().forEach(srcDir -> resourceDirs.put(srcDir, resourcesOutputDir.toPath()));
        }
        ArrayList<DefaultSourceDir> resources = new ArrayList<DefaultSourceDir>(resourceDirs.size());
        for (Map.Entry e : resourceDirs.entrySet()) {
            resources.add(new DefaultSourceDir(((File)e.getKey()).toPath(), (Path)e.getValue(), null));
        }
        module.addArtifactSources((ArtifactSources)new DefaultArtifactSources(classifier, sourceDirs, resources));
    }

    private static void maybeConfigureKotlinJvmCompile(Project project, FileCollection allClassesDirs, List<SourceDir> sourceDirs, SourceSet sourceSet) {
        for (Task task : project.getTasks()) {
            if (!task.getName().contains("compileKotlin") || !task.getEnabled()) continue;
            int originalSourceDirsSize = sourceDirs.size();
            try {
                Class.forName("org.jetbrains.kotlin.gradle.tasks.KotlinCompileTool");
                GradleApplicationModelBuilder.doConfigureKotlinJvmCompile(project, allClassesDirs, sourceDirs, sourceSet);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (originalSourceDirsSize != sourceDirs.size()) continue;
            File outputDir = ToolingUtils.getClassesOutputDir(task);
            if (outputDir == null || !task.getInputs().getHasInputs()) break;
            task.getInputs().getSourceFiles().getAsFileTree().visit(visitor -> {
                if (visitor.getRelativePath().getSegments().length == 1) {
                    sourceDirs.add(SourceDir.of((Path)visitor.getFile().getParentFile().toPath(), (Path)outputDir.toPath()));
                }
            });
            break;
        }
    }

    private static void doConfigureKotlinJvmCompile(Project project, FileCollection allClassesDirs, List<SourceDir> sourceDirs, SourceSet sourceSet) {
        project.getTasks().withType(KotlinCompileTool.class, t -> GradleApplicationModelBuilder.configureCompileTask(t.getSources().getAsFileTree(), t.getDestinationDirectory(), allClassesDirs, sourceDirs, (Task)t, sourceSet));
    }

    private static void configureCompileTask(FileTree sources, DirectoryProperty destinationDirectory, FileCollection allClassesDirs, List<SourceDir> sourceDirs, Task task, SourceSet sourceSet) {
        if (!task.getEnabled() || sources.isEmpty()) {
            return;
        }
        File destDir = (File)destinationDirectory.getAsFile().get();
        if (!allClassesDirs.contains(destDir)) {
            return;
        }
        sources.visit(visitor -> {
            if (visitor.getRelativePath().getSegments().length == 1) {
                File srcDir = visitor.getFile().getParentFile();
                sourceDirs.add((SourceDir)new DefaultSourceDir(srcDir.toPath(), destDir.toPath(), GradleApplicationModelBuilder.findGeneratedSourceDir(destDir, sourceSet), Map.of("compiler", task.getName())));
            }
        });
    }

    private static Path findGeneratedSourceDir(File destDir, SourceSet sourceSet) {
        if (destDir.getParentFile() == null) {
            return null;
        }
        String language = destDir.getParentFile().getName();
        String sourceSetName = destDir.getName();
        for (File generatedDir : sourceSet.getOutput().getGeneratedSourcesDirs().getFiles()) {
            if (generatedDir.getParentFile() == null || !generatedDir.getName().equals(sourceSetName) || !generatedDir.getParentFile().getName().equals(language)) continue;
            return generatedDir.toPath();
        }
        return null;
    }

    private void addSubstitutedProject(PathList.Builder paths, File projectFile) {
        File classesOutput;
        File[] languageDirectories;
        File mainResourceDirectory = new File(projectFile, MAIN_RESOURCES_OUTPUT);
        if (mainResourceDirectory.exists()) {
            paths.add(mainResourceDirectory.toPath());
        }
        if ((languageDirectories = (classesOutput = new File(projectFile, CLASSES_OUTPUT)).listFiles()) != null) {
            for (File languageDirectory : languageDirectories) {
                if (!languageDirectory.isDirectory()) continue;
                for (File sourceSet : languageDirectory.listFiles()) {
                    if (!sourceSet.isDirectory() || !sourceSet.getName().equals("main")) continue;
                    paths.add(sourceSet.toPath());
                }
            }
        }
    }

    public static boolean isFlagOn(byte walkingFlags, byte flag) {
        return (walkingFlags & flag) > 0;
    }

    public static byte clearFlag(byte flags, byte flag) {
        if ((flags & flag) > 0) {
            flags = (byte)(flags ^ flag);
        }
        return flags;
    }

    private static boolean isDependency(ResolvedArtifact a) {
        return "jar".equalsIgnoreCase(a.getExtension()) || "exe".equalsIgnoreCase(a.getExtension()) || a.getFile().isDirectory();
    }

    static ResolvedDependencyBuilder toDependency(ResolvedArtifact a, int ... flags) {
        return GradleApplicationModelBuilder.toDependency(a, (PathCollection)PathList.of((Path[])new Path[]{a.getFile().toPath()}), null, flags);
    }

    static ResolvedDependencyBuilder toDependency(ResolvedArtifact a, SourceSet s) {
        PathList.Builder resolvedPathBuilder = PathList.builder();
        for (File classesDir : s.getOutput().getClassesDirs()) {
            if (!classesDir.exists()) continue;
            resolvedPathBuilder.add(classesDir.toPath());
        }
        File resourceDir = s.getOutput().getResourcesDir();
        if (resourceDir != null && resourceDir.exists()) {
            resolvedPathBuilder.add(resourceDir.toPath());
        }
        return (ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setResolvedPaths((PathCollection)resolvedPathBuilder.build()).setCoords(GradleApplicationModelBuilder.toArtifactCoords(a));
    }

    static ResolvedDependencyBuilder toDependency(ResolvedArtifact a, PathCollection paths, DefaultWorkspaceModule module, int ... flags) {
        int allFlags = 0;
        for (int f : flags) {
            allFlags |= f;
        }
        return (ResolvedDependencyBuilder)((ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setCoords(GradleApplicationModelBuilder.toArtifactCoords(a))).setResolvedPaths(paths).setWorkspaceModule((WorkspaceModule)module).setFlags(allFlags);
    }

    private static ArtifactCoords toArtifactCoords(ResolvedArtifact a) {
        String[] split = a.getModuleVersion().toString().split(":");
        return new GACTV(split[0], split[1], a.getClassifier(), a.getType(), split.length > 2 ? split[2] : null);
    }

    private static ArtifactKey toAppDependenciesKey(String groupId, String artifactId, String classifier) {
        return ArtifactKey.of((String)groupId, (String)artifactId, (String)classifier, (String)"jar");
    }
}

