/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.dependency;

import io.quarkus.gradle.dependency.ApplicationDeploymentClasspathBuilder;
import io.quarkus.gradle.tooling.dependency.DependencyUtils;
import io.quarkus.gradle.tooling.dependency.ExtensionDependency;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.runtime.LaunchMode;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ComponentMetadataDetails;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DirectDependencyMetadata;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.attributes.java.TargetJvmEnvironment;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;

public class QuarkusComponentVariants {
    private static final String ON = "on";
    private static final String RUNTIME_ELEMENTS = "runtimeElements";
    private static final String RUNTIME = "runtime";
    private final Attribute<String> quarkusDepAttr;
    private final Project project;
    private final Map<ArtifactKey, ProcessedDependency> processedDeps = new HashMap<ArtifactKey, ProcessedDependency>();
    private final Map<ArtifactKey, ConditionalDependency> allConditionalDeps = new HashMap<ArtifactKey, ConditionalDependency>();
    private final List<ConditionalDependencyVariant> dependencyVariantQueue = new ArrayList<ConditionalDependencyVariant>();
    private final Map<String, SatisfiedExtensionDeps> satisfiedExtensionDeps = new HashMap<String, SatisfiedExtensionDeps>();
    private final LaunchMode mode;
    private final AtomicInteger configCopyCounter = new AtomicInteger();

    private static String toUpperCaseName(String s) {
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static String getConditionalConfigurationName(LaunchMode mode) {
        return "quarkusConditional" + ApplicationDeploymentClasspathBuilder.getLaunchModeAlias(mode) + "RuntimeClasspath";
    }

    private static Attribute<String> getConditionalDependencyAttribute(String projectName, LaunchMode mode) {
        StringBuilder sb = new StringBuilder().append("quarkus.").append(mode.getDefaultProfile()).append(".conditional-dependency.").append(projectName);
        return Attribute.of((String)sb.toString(), String.class);
    }

    private static Attribute<String> getDeploymentDependencyAttribute(String projectName, LaunchMode mode) {
        StringBuilder sb = new StringBuilder().append("quarkus.").append(mode.getDefaultProfile()).append(".deployment-dependency.").append(projectName);
        return Attribute.of((String)sb.toString(), String.class);
    }

    public static void setConditionalAttributes(Configuration config, Project project, LaunchMode mode) {
        config.attributes(attrs -> {
            QuarkusComponentVariants.setCommonAttributes(attrs, project.getObjects());
            attrs.attribute(QuarkusComponentVariants.getConditionalDependencyAttribute(project.getName(), mode), (Object)ON);
        });
    }

    public static void setDeploymentAndConditionalAttributes(Configuration config, Project project, LaunchMode mode) {
        QuarkusComponentVariants.setConditionalAttributes(config, project, mode);
        config.attributes(attrs -> attrs.attribute(QuarkusComponentVariants.getDeploymentDependencyAttribute(project.getName(), mode), (Object)ON));
    }

    private static void setIterativeConditionalAttributes(Configuration config, Project project, Collection<SatisfiedExtensionDeps> satisfiedExtDeps) {
        config.attributes(attrs -> {
            QuarkusComponentVariants.setCommonAttributes(attrs, project.getObjects());
            for (SatisfiedExtensionDeps satisfiedDep : satisfiedExtDeps) {
                satisfiedDep.setItrativeAttribute((AttributeContainer)attrs);
            }
        });
    }

    public static void setCommonAttributes(AttributeContainer attrs, ObjectFactory objectFactory) {
        attrs.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)objectFactory.named(Category.class, "library")));
        attrs.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)objectFactory.named(Usage.class, "java-runtime")));
        attrs.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)objectFactory.named(LibraryElements.class, "jar")));
        attrs.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)objectFactory.named(Bundling.class, "external")));
        attrs.attribute(TargetJvmEnvironment.TARGET_JVM_ENVIRONMENT_ATTRIBUTE, (Object)((TargetJvmEnvironment)objectFactory.named(TargetJvmEnvironment.class, "standard-jvm")));
    }

    public static void addVariants(Project project, LaunchMode mode) {
        new QuarkusComponentVariants(project, mode).configureAndAddVariants();
    }

    private QuarkusComponentVariants(Project project, LaunchMode mode) {
        this.project = project;
        this.mode = mode;
        this.quarkusDepAttr = QuarkusComponentVariants.getConditionalDependencyAttribute(project.getName(), mode);
        project.getDependencies().getAttributesSchema().attribute(this.quarkusDepAttr);
        project.getDependencies().getAttributesSchema().attribute(QuarkusComponentVariants.getDeploymentDependencyAttribute(project.getName(), mode));
    }

    private Configuration getBaseConfiguration() {
        return this.project.getConfigurations().getByName(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName(this.mode));
    }

    private void configureAndAddVariants() {
        this.project.getConfigurations().resolvable(QuarkusComponentVariants.getConditionalConfigurationName(this.mode), config -> {
            config.setCanBeConsumed(false);
            config.extendsFrom(new Configuration[]{this.getBaseConfiguration()});
            QuarkusComponentVariants.setConditionalAttributes((Configuration)config, this.project, this.mode);
            ListProperty dependencyProperty = this.project.getObjects().listProperty(Dependency.class);
            AtomicInteger invocations = new AtomicInteger();
            config.getDependencies().addAllLater((Provider)dependencyProperty.value(this.project.provider(() -> {
                if (invocations.getAndIncrement() == 0) {
                    this.addConditionalVariants(this.getBaseConfiguration());
                    this.addDeploymentVariants();
                }
                return Set.of();
            })));
        });
    }

    private void addConditionalVariants(Configuration baseConfig) {
        this.processConfiguration(baseConfig);
        while (!this.dependencyVariantQueue.isEmpty()) {
            boolean satisfiedConditions = false;
            Iterator<ConditionalDependencyVariant> i = this.dependencyVariantQueue.iterator();
            while (i.hasNext()) {
                ConditionalDependencyVariant conditionalVariant = i.next();
                if (!conditionalVariant.conditionalDep.isConditionSatisfied()) continue;
                satisfiedConditions = true;
                i.remove();
                this.satisfiedExtensionDeps.computeIfAbsent((String)conditionalVariant.parent.toModuleName(), (Function<String, SatisfiedExtensionDeps>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$addConditionalVariants$5(io.quarkus.gradle.dependency.QuarkusComponentVariants$ConditionalDependencyVariant java.lang.String ), (Ljava/lang/String;)Lio/quarkus/gradle/dependency/QuarkusComponentVariants$SatisfiedExtensionDeps;)((QuarkusComponentVariants)this, (ConditionalDependencyVariant)conditionalVariant)).deps.add(conditionalVariant.conditionalDep);
            }
            if (!satisfiedConditions) break;
            for (SatisfiedExtensionDeps satisfiedDeps : this.satisfiedExtensionDeps.values()) {
                this.project.getDependencies().getComponents().withModule((Object)satisfiedDeps.getModuleId(), satisfiedDeps::addIterativeConditionalVariants);
            }
            this.processConfiguration(baseConfig);
        }
    }

    private void addConditionalVariant(String variantName, ComponentMetadataDetails compDetails, Attribute<String> attr, List<ConditionalDependency> deps) {
        this.addConditionalVariant(variantName, RUNTIME_ELEMENTS, compDetails, attr, deps);
        this.addConditionalVariant(variantName, RUNTIME, compDetails, attr, deps);
    }

    private void addConditionalVariant(String variantName, String baseVariant, ComponentMetadataDetails compDetails, Attribute<String> attr, List<ConditionalDependency> satisfiedDeps) {
        compDetails.maybeAddVariant(variantName, baseVariant, variant -> {
            AtomicInteger selectCounter = new AtomicInteger();
            variant.attributes(attrs -> {
                if (selectCounter.getAndIncrement() == 0) {
                    attrs.attribute(attr, (Object)ON);
                }
            });
            variant.withDependencies(directDeps -> {
                for (ConditionalDependency satisfiedDep : satisfiedDeps) {
                    boolean alreadyAdded = false;
                    for (DirectDependencyMetadata directDep : directDeps) {
                        if (!directDep.getName().equals(satisfiedDep.key.getArtifactId()) || !directDep.getGroup().equals(satisfiedDep.key.getGroupId())) continue;
                        alreadyAdded = true;
                        break;
                    }
                    if (alreadyAdded) continue;
                    ResolvedArtifact a = satisfiedDep.artifact;
                    directDeps.add(DependencyUtils.asDependencyNotation((Dependency)this.project.getDependencyFactory().create(a.getModuleVersion().getId().getGroup(), a.getName(), a.getModuleVersion().getId().getVersion(), a.getClassifier(), a.getExtension())));
                }
            });
        });
    }

    private void addDeploymentVariants() {
        HashMap deploymentDeps = new HashMap();
        for (SatisfiedExtensionDeps satisfiedExtensionDeps : this.satisfiedExtensionDeps.values()) {
            this.project.getDependencies().getComponents().withModule((Object)satisfiedExtensionDeps.getModuleId(), satisfiedExtensionDeps::addFinalConditionalVariants);
            satisfiedExtensionDeps.collectExtensionDeps(deploymentDeps);
        }
        for (ProcessedDependency processedDependency : this.processedDeps.values()) {
            processedDependency.addDeploymentDependency(deploymentDeps);
        }
        for (Map.Entry entry : deploymentDeps.entrySet()) {
            this.addDeploymentVariant((String)entry.getKey(), (List)entry.getValue());
        }
    }

    private void addDeploymentVariant(String parentModule, List<ExtensionDependency<?>> extDeps) {
        this.project.getDependencies().getComponents().withModule((Object)parentModule, compDetails -> QuarkusComponentVariants.addDeploymentVariant(QuarkusComponentVariants.getDeploymentDependencyAttribute(this.project.getName(), this.mode), compDetails, extDeps));
    }

    private static void addDeploymentVariant(Attribute<String> attribute, ComponentMetadataDetails compDetails, List<ExtensionDependency<?>> deploymentDeps) {
        QuarkusComponentVariants.addDeploymentVariant(attribute, RUNTIME_ELEMENTS, compDetails, deploymentDeps);
        QuarkusComponentVariants.addDeploymentVariant(attribute, RUNTIME, compDetails, deploymentDeps);
    }

    private static void addDeploymentVariant(Attribute<String> attribute, String baseVariant, ComponentMetadataDetails compDetails, List<ExtensionDependency<?>> deploymentDeps) {
        compDetails.maybeAddVariant(attribute.getName(), baseVariant, variant -> {
            variant.attributes(attrs -> attrs.attribute(attribute, (Object)ON));
            variant.withDependencies(directDeps -> {
                for (ExtensionDependency deploymentDep : deploymentDeps) {
                    boolean alreadyAdded = false;
                    for (DirectDependencyMetadata directDep : directDeps) {
                        if (!directDep.getName().equals(deploymentDep.getDeploymentName()) || !directDep.getGroup().equals(deploymentDep.getDeploymentGroup())) continue;
                        alreadyAdded = true;
                        break;
                    }
                    if (alreadyAdded) continue;
                    directDeps.add(deploymentDep.getDeploymentGroup() + ":" + deploymentDep.getDeploymentName() + ":" + deploymentDep.getDeploymentVersion());
                }
            });
        });
    }

    private Configuration copyBaseConfig(Configuration baseConfig) {
        return (Configuration)this.project.getConfigurations().resolvable(baseConfig.getName() + "Copy" + this.configCopyCounter.incrementAndGet(), c -> {
            c.setCanBeConsumed(false);
            c.extendsFrom(new Configuration[]{baseConfig});
            QuarkusComponentVariants.setIterativeConditionalAttributes((Configuration)c, this.project, this.satisfiedExtensionDeps.values());
        }).get();
    }

    private void processConfiguration(Configuration baseConfig) {
        Configuration config = this.copyBaseConfig(baseConfig);
        HashSet<ModuleVersionIdentifier> visited = new HashSet<ModuleVersionIdentifier>();
        for (ResolvedDependency dep : config.getResolvedConfiguration().getFirstLevelModuleDependencies()) {
            this.processDependency(null, dep, visited, true);
        }
    }

    private void processDependency(ProcessedDependency parent, ResolvedDependency dep, Set<ModuleVersionIdentifier> visited, boolean collectTopExtensions) {
        if (!visited.add(dep.getModule().getId())) {
            return;
        }
        Set artifacts = dep.getModuleArtifacts();
        ProcessedDependency nextParent = null;
        if (!artifacts.isEmpty()) {
            for (ResolvedArtifact a : artifacts) {
                nextParent = this.processedDeps.computeIfAbsent(DependencyUtils.getKey(a), key -> {
                    ProcessedDependency processedDep = new ProcessedDependency(a, DependencyUtils.getExtensionInfoOrNull(this.project, a), a.getId().getComponentIdentifier() instanceof ProjectComponentIdentifier);
                    processedDep.parent = parent;
                    processedDep.queueConditionalDeps();
                    return processedDep;
                });
                if (nextParent.extension == null || !collectTopExtensions) continue;
                nextParent.topLevelExt = true;
                nextParent.parent = parent;
                collectTopExtensions = false;
            }
        }
        for (ResolvedDependency c : dep.getChildren()) {
            this.processDependency(nextParent, c, visited, collectTopExtensions);
        }
    }

    private void queueConditionalDependency(ProcessedDependency parent, Dependency dep) {
        this.dependencyVariantQueue.add(new ConditionalDependencyVariant(parent.extension, this.getOrCreateConditionalDep(dep)));
    }

    private ConditionalDependency getOrCreateConditionalDep(Dependency dep) {
        return this.allConditionalDeps.computeIfAbsent(ArtifactKey.of((String)dep.getGroup(), (String)dep.getName(), (String)dep.getVersion(), (String)"jar"), key -> this.newConditionalDep(dep));
    }

    private ConditionalDependency newConditionalDep(Dependency dep) {
        Configuration config = this.project.getConfigurations().detachedConfiguration(new Dependency[]{dep}).setTransitive(false);
        QuarkusComponentVariants.setConditionalAttributes(config, this.project, this.mode);
        Iterator iterator = config.getResolvedConfiguration().getResolvedArtifacts().iterator();
        if (iterator.hasNext()) {
            ResolvedArtifact a = (ResolvedArtifact)iterator.next();
            return new ConditionalDependency(DependencyUtils.getKey(a), a, DependencyUtils.getExtensionInfoOrNull(this.project, a));
        }
        throw new RuntimeException(String.valueOf(dep) + " did not resolve to any artifacts");
    }

    private /* synthetic */ SatisfiedExtensionDeps lambda$addConditionalVariants$5(ConditionalDependencyVariant conditionalVariant, String key) {
        return new SatisfiedExtensionDeps(conditionalVariant.parent, this.project.getName(), this.mode);
    }

    private record ConditionalDependencyVariant(ExtensionDependency<?> parent, ConditionalDependency conditionalDep) {
    }

    private class ConditionalDependency {
        private final ArtifactKey key;
        private final ResolvedArtifact artifact;
        private final ExtensionDependency<?> extension;

        private ConditionalDependency(ArtifactKey key, ResolvedArtifact artifact, ExtensionDependency<?> extension) {
            this.key = key;
            this.artifact = artifact;
            this.extension = extension;
        }

        private boolean isConditionSatisfied() {
            if (this.extension == null || this.extension.getDependencyConditions().isEmpty()) {
                return true;
            }
            for (ArtifactKey key : this.extension.getDependencyConditions()) {
                if (QuarkusComponentVariants.this.processedDeps.containsKey(key)) continue;
                return false;
            }
            return true;
        }
    }

    private class SatisfiedExtensionDeps {
        private final ExtensionDependency<?> parent;
        private final List<ConditionalDependency> deps = new ArrayList<ConditionalDependency>(4);
        private int depsInLastAddedVariant;
        private String iterativeVariantName;
        private int variantIteration;

        private SatisfiedExtensionDeps(ExtensionDependency<?> parent, String projectName, LaunchMode mode) {
            this.parent = parent;
            this.iterativeVariantName = "quarkus" + ApplicationDeploymentClasspathBuilder.getLaunchModeAlias(mode) + "Iterative" + QuarkusComponentVariants.toUpperCaseName(projectName) + QuarkusComponentVariants.toUpperCaseName(parent.getName());
        }

        private String getModuleId() {
            return this.parent.getGroup() + ":" + this.parent.getName();
        }

        private boolean hasNewDepsSinceLastAddedVariant() {
            return this.deps.size() > this.depsInLastAddedVariant;
        }

        private void setItrativeAttribute(AttributeContainer attrs) {
            attrs.attribute(Attribute.of((String)(this.iterativeVariantName + (this.variantIteration + 1)), String.class), (Object)QuarkusComponentVariants.ON);
        }

        private void addIterativeConditionalVariants(ComponentMetadataDetails compDetails) {
            String variantName = this.iterativeVariantName + ++this.variantIteration;
            this.depsInLastAddedVariant = this.deps.size();
            Attribute attr = Attribute.of((String)variantName, String.class);
            QuarkusComponentVariants.this.project.getDependencies().getAttributesSchema().attribute(attr);
            QuarkusComponentVariants.this.addConditionalVariant(variantName, compDetails, (Attribute<String>)attr, this.deps);
        }

        private void addFinalConditionalVariants(ComponentMetadataDetails compDetails) {
            QuarkusComponentVariants.this.addConditionalVariant(QuarkusComponentVariants.this.quarkusDepAttr.getName(), compDetails, QuarkusComponentVariants.this.quarkusDepAttr, this.deps);
        }

        private void collectExtensionDeps(Map<String, List<ExtensionDependency<?>>> extMap) {
            for (ConditionalDependency dep : this.deps) {
                if (dep.extension == null) continue;
                extMap.computeIfAbsent(this.parent.getDeploymentGroup() + ":" + this.parent.getDeploymentName(), k -> new ArrayList(4)).add(dep.extension);
            }
        }
    }

    private class ProcessedDependency {
        private final ResolvedArtifact artifact;
        private final ExtensionDependency<?> extension;
        private final boolean local;
        private ProcessedDependency parent;
        private boolean topLevelExt;

        private ProcessedDependency(ResolvedArtifact artifact, ExtensionDependency<?> extension, boolean local) {
            this.artifact = artifact;
            this.extension = extension;
            this.local = local;
        }

        private void queueConditionalDeps() {
            if (this.extension == null) {
                return;
            }
            for (Dependency dep : this.extension.getConditionalDependencies()) {
                QuarkusComponentVariants.this.queueConditionalDependency(this, dep);
            }
            if (QuarkusComponentVariants.this.mode == LaunchMode.DEVELOPMENT) {
                for (Dependency dep : this.extension.getConditionalDevDependencies()) {
                    QuarkusComponentVariants.this.queueConditionalDependency(this, dep);
                }
            }
        }

        private void addDeploymentDependency(Map<String, List<ExtensionDependency<?>>> deploymentDeps) {
            if (this.extension == null || this.parent == null || this.parent.local || this.parent.extension != null && !this.topLevelExt) {
                return;
            }
            String parentModule = this.parent.extension == null ? this.parent.artifact.getModuleVersion().getId().getGroup() + ":" + this.parent.artifact.getModuleVersion().getId().getName() : this.parent.extension.getDeploymentGroup() + ":" + this.parent.extension.getDeploymentName();
            deploymentDeps.computeIfAbsent(parentModule, k -> new ArrayList(1)).add(this.extension);
        }
    }
}

