/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.dependency;

import io.quarkus.gradle.dependency.ApplicationDeploymentClasspathBuilder;
import io.quarkus.gradle.dependency.QuarkusComponentVariants;
import io.quarkus.gradle.tooling.dependency.DependencyUtils;
import io.quarkus.gradle.tooling.dependency.ExtensionDependency;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.runtime.LaunchMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;

public class DeploymentConfigurationResolver {
    private static final byte COLLECT_TOP_EXTENSIONS = 1;
    private final Project project;
    private final TaskDependencyFactory taskDependencyFactory;
    private byte walkingFlags;

    public static void registerDeploymentConfiguration(Project project, LaunchMode mode, String configurationName, TaskDependencyFactory taskDependencyFactory) {
        project.getConfigurations().register(configurationName, config -> new DeploymentConfigurationResolver(project, (Configuration)config, mode, taskDependencyFactory));
    }

    private DeploymentConfigurationResolver(Project project, Configuration deploymentConfig, LaunchMode mode, TaskDependencyFactory taskDependencyFactory) {
        this.project = project;
        this.taskDependencyFactory = taskDependencyFactory;
        Configuration baseRuntimeConfig = project.getConfigurations().getByName(ApplicationDeploymentClasspathBuilder.getFinalRuntimeConfigName(mode));
        deploymentConfig.setCanBeConsumed(false);
        deploymentConfig.extendsFrom(new Configuration[]{baseRuntimeConfig});
        deploymentConfig.shouldResolveConsistentlyWith(baseRuntimeConfig);
        ListProperty dependencyListProperty = project.getObjects().listProperty(Dependency.class);
        AtomicReference directDeploymentDeps = new AtomicReference();
        deploymentConfig.getDependencies().addAllLater((Provider)dependencyListProperty.value(project.provider(() -> {
            Collection<Object> directDeps = (List)directDeploymentDeps.get();
            if (directDeps == null) {
                directDeps = !baseRuntimeConfig.getIncoming().getDependencies().isEmpty() ? this.collectDirectDeploymentDeps(baseRuntimeConfig.getResolvedConfiguration()) : List.of();
                directDeploymentDeps.set(directDeps);
            }
            return directDeps;
        })));
        QuarkusComponentVariants.setDeploymentAndConditionalAttributes(deploymentConfig, project, mode);
    }

    private Collection<Dependency> collectDirectDeploymentDeps(ResolvedConfiguration baseConfig) {
        return this.collectDirectDeploymentDeps(this.processRuntimeDeps(baseConfig));
    }

    private Map<ArtifactKey, ProcessedDependency> processRuntimeDeps(ResolvedConfiguration baseConfig) {
        HashMap<ArtifactKey, ProcessedDependency> allDeps = new HashMap<ArtifactKey, ProcessedDependency>();
        this.setWalkingFlags((byte)1);
        for (ResolvedDependency dep : baseConfig.getFirstLevelModuleDependencies()) {
            this.processDependency(null, dep, allDeps);
        }
        this.walkingFlags = 0;
        return allDeps;
    }

    private void processDependency(ProcessedDependency parent, ResolvedDependency dep, Map<ArtifactKey, ProcessedDependency> allDeps) {
        boolean processChildren = false;
        int depFlags = 0;
        Set artifacts = dep.getModuleArtifacts();
        ProcessedDependency processedDep = null;
        if (artifacts.isEmpty()) {
            processChildren = true;
        } else {
            for (ResolvedArtifact artifact : artifacts) {
                processedDep = allDeps.computeIfAbsent(DependencyUtils.getKey(artifact), key -> {
                    ProcessedDependency pd = new ProcessedDependency(parent, dep, artifact.getId().getComponentIdentifier() instanceof ProjectComponentIdentifier);
                    if (this.isWalkingFlagsOn((byte)1)) {
                        pd.ext = DependencyUtils.getExtensionInfoOrNull(this.project, artifact);
                        if (pd.ext != null) {
                            pd.setFlags(128);
                        }
                    }
                    return pd;
                });
                if (!processedDep.setFlags(2048)) continue;
                processChildren = true;
                depFlags |= processedDep.flags;
            }
        }
        if (processChildren) {
            boolean stopCollectingTopExt;
            boolean bl = stopCollectingTopExt = this.isWalkingFlagsOn((byte)1) && (depFlags & 0x80) > 0;
            if (stopCollectingTopExt) {
                this.clearWalkingFlags((byte)1);
            }
            for (ResolvedDependency child : dep.getChildren()) {
                this.processDependency(processedDep, child, allDeps);
            }
            if (stopCollectingTopExt) {
                this.setWalkingFlags((byte)1);
            }
        }
    }

    private Collection<Dependency> collectDirectDeploymentDeps(Map<ArtifactKey, ProcessedDependency> allRuntimeDeps) {
        ArrayList<Dependency> directDeploymentDeps = new ArrayList<Dependency>();
        for (ProcessedDependency processedDep : allRuntimeDeps.values()) {
            if (processedDep.ext == null || !processedDep.hasLocalParent() || allRuntimeDeps.containsKey(ArtifactKey.of((String)processedDep.ext.getDeploymentGroup(), (String)processedDep.ext.getDeploymentName(), (String)"", (String)"jar"))) continue;
            directDeploymentDeps.add(DependencyUtils.createDeploymentDependency(this.project.getDependencies(), processedDep.ext));
        }
        return directDeploymentDeps;
    }

    private boolean isWalkingFlagsOn(byte flags) {
        return (this.walkingFlags & flags) == flags;
    }

    private void clearWalkingFlags(byte flags) {
        this.walkingFlags = (byte)(this.walkingFlags & (byte)(this.walkingFlags ^ flags));
    }

    private boolean setWalkingFlags(byte flags) {
        this.walkingFlags = (byte)(this.walkingFlags | flags);
        return this.walkingFlags != this.walkingFlags;
    }

    private static class ProcessedDependency {
        final ProcessedDependency parent;
        final ResolvedDependency dep;
        final boolean local;
        int flags;
        ExtensionDependency<?> ext;

        private ProcessedDependency(ProcessedDependency parent, ResolvedDependency dep, boolean local) {
            this.parent = parent;
            this.dep = dep;
            this.local = local;
        }

        private boolean setFlags(int flags) {
            return (this.flags |= flags) != this.flags;
        }

        private boolean hasLocalParent() {
            return this.parent == null || this.parent.local;
        }
    }
}

