/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc;

import io.grpc.Metadata;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import io.quarkus.grpc.MutinyClient;

public class GrpcClientUtils {
    public static <T> T attachHeaders(T client, Metadata extraHeaders) {
        if (client == null) {
            throw new NullPointerException("Cannot attach headers to a null client");
        }
        if (client instanceof AbstractStub) {
            return (T)MetadataUtils.attachHeaders((AbstractStub)((AbstractStub)client), (Metadata)extraHeaders);
        }
        if (client instanceof MutinyClient) {
            MutinyClient mutinyClient = (MutinyClient)client;
            AbstractStub stub = MetadataUtils.attachHeaders(mutinyClient.getStub(), (Metadata)extraHeaders);
            return (T)((MutinyClient)client).newInstanceWithStub(stub);
        }
        throw new IllegalArgumentException("Unsupported client type " + client.getClass());
    }
}

