/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.ArrayDeque;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class MultiSelectLastOp<T>
extends AbstractMultiOperator<T, T> {
    private final int numberOfItems;

    public MultiSelectLastOp(Multi<? extends T> upstream, int numberOfItems) {
        super(upstream);
        this.numberOfItems = ParameterValidation.positiveOrZero(numberOfItems, "numberOfItems");
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> subscriber) {
        if (this.numberOfItems == 0) {
            this.upstream.subscribe(new TakeSelectLastZeroProcessor<T>(subscriber));
        } else {
            this.upstream.subscribe(new MultiSelectLastProcessor<T>(subscriber, this.numberOfItems));
        }
    }

    static final class MultiSelectLastProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        private final int numberOfItems;
        private final ArrayDeque<T> queue;
        private final AtomicLong requested = new AtomicLong();
        private final AtomicInteger wip = new AtomicInteger();
        volatile boolean upstreamCompleted;

        MultiSelectLastProcessor(MultiSubscriber<? super T> downstream, int numberOfItems) {
            super(downstream);
            this.numberOfItems = numberOfItems;
            this.queue = new ArrayDeque(numberOfItems);
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                this.onFailure(Subscriptions.getInvalidRequestException());
                return;
            }
            Subscriptions.add(this.requested, n);
            this.drain();
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            if (this.compareAndSetUpstreamSubscription(null, subscription)) {
                this.downstream.onSubscribe(this);
                subscription.request(Long.MAX_VALUE);
            } else {
                subscription.cancel();
            }
        }

        @Override
        public void onItem(T t) {
            if (this.queue.size() == this.numberOfItems) {
                this.queue.poll();
            }
            this.queue.offer(t);
        }

        @Override
        public void onCompletion() {
            this.upstreamCompleted = true;
            this.drain();
        }

        private void drain() {
            if (this.wip.getAndIncrement() == 0) {
                long req = this.requested.get();
                do {
                    long count;
                    if (this.getUpstreamSubscription() == Subscriptions.CANCELLED) {
                        return;
                    }
                    if (!this.upstreamCompleted) continue;
                    for (count = 0L; count != req; ++count) {
                        if (this.getUpstreamSubscription() == Subscriptions.CANCELLED) {
                            return;
                        }
                        T item = this.queue.poll();
                        if (item == null) {
                            this.downstream.onCompletion();
                            return;
                        }
                        this.downstream.onItem(item);
                    }
                    if (count == 0L || req == Long.MAX_VALUE) continue;
                    req = this.requested.addAndGet(-count);
                } while (this.wip.decrementAndGet() != 0);
            }
        }
    }

    static final class TakeSelectLastZeroProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        TakeSelectLastZeroProcessor(MultiSubscriber<? super T> downstream) {
            super(downstream);
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            if (this.compareAndSetUpstreamSubscription(null, subscription)) {
                this.downstream.onSubscribe(this);
                subscription.request(Long.MAX_VALUE);
            } else {
                subscription.cancel();
            }
        }

        @Override
        public void onItem(T t) {
        }
    }
}

