/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.cli;

import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ProtocolStringList;
import io.grpc.Channel;
import io.grpc.reflection.v1.MutinyServerReflectionGrpc;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.grpc.client.GrpcClient;
import io.vertx.grpc.client.GrpcClientChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import picocli.CommandLine;

public abstract class GcurlBaseCommand
implements Callable<Integer> {
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Unmatched
    List<String> unmatched;
    Vertx vertx = Vertx.vertx();

    protected abstract String getAction();

    protected abstract void execute(MutinyServerReflectionGrpc.MutinyServerReflectionStub var1);

    protected void log(String msg) {
        System.out.println(msg);
    }

    protected void err(String msg) {
        System.err.println(msg);
    }

    protected static List<Descriptors.FileDescriptor> getFileDescriptorsFromProtos(List<ByteString> protos) {
        try {
            Map<String, DescriptorProtos.FileDescriptorProto> all = protos.stream().map(bs -> {
                try {
                    return DescriptorProtos.FileDescriptorProto.parseFrom(bs);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toMap(DescriptorProtos.FileDescriptorProto::getName, Function.identity(), (a, b) -> a));
            ArrayList<Descriptors.FileDescriptor> fds = new ArrayList<Descriptors.FileDescriptor>();
            HashMap<String, Descriptors.FileDescriptor> resolved = new HashMap<String, Descriptors.FileDescriptor>();
            for (DescriptorProtos.FileDescriptorProto fdp : all.values()) {
                fds.add(GcurlBaseCommand.toFileDescriptor(fdp, all, resolved));
            }
            return fds;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Descriptors.FileDescriptor toFileDescriptor(DescriptorProtos.FileDescriptorProto fdp, Map<String, DescriptorProtos.FileDescriptorProto> all, Map<String, Descriptors.FileDescriptor> resolved) {
        int n = fdp.getDependencyCount();
        ProtocolStringList list = fdp.getDependencyList();
        Descriptors.FileDescriptor[] fds = new Descriptors.FileDescriptor[n];
        for (int i = 0; i < n; ++i) {
            String dep = (String)list.get(i);
            fds[i] = resolved.computeIfAbsent(dep, key -> {
                DescriptorProtos.FileDescriptorProto proto = (DescriptorProtos.FileDescriptorProto)all.get(key);
                return GcurlBaseCommand.toFileDescriptor(proto, all, resolved);
            });
        }
        try {
            return Descriptors.FileDescriptor.buildFrom(fdp, fds);
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Integer call() {
        if (this.unmatched == null || this.unmatched.isEmpty()) {
            this.log("Missing host:port");
            return 2;
        }
        return this.execute((Channel channel) -> {
            try {
                MutinyServerReflectionGrpc.MutinyServerReflectionStub stub = MutinyServerReflectionGrpc.newMutinyStub(channel);
                this.execute(stub);
                return 0;
            }
            catch (Exception e) {
                this.err("Failed to execute grpc " + this.getAction() + ", due to: " + e.getMessage());
                return 1;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <X> X execute(Function<Channel, X> fn) {
        HttpClientOptions options = new HttpClientOptions();
        options.setHttp2ClearTextUpgrade(false);
        GrpcClient client = GrpcClient.client(this.vertx, options);
        String[] split = this.unmatched.get(0).split(":");
        String host = split[0];
        int port = Integer.parseInt(split[1]);
        GrpcClientChannel channel = new GrpcClientChannel(client, SocketAddress.inetSocketAddress(port, host));
        try {
            X x = fn.apply(channel);
            return x;
        }
        finally {
            client.close().toCompletionStage().toCompletableFuture().join();
        }
    }
}

