/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.common.deployment;

import io.grpc.internal.DnsNameResolverProvider;
import io.grpc.internal.PickFirstLoadBalancerProvider;
import io.grpc.netty.NettyChannelProvider;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.grpc.common.deployment.GrpcDotNames;
import java.util.Collection;
import org.jboss.jandex.ClassInfo;

public class GrpcCommonProcessor {
    @BuildStep
    public void configureNativeExecutable(CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        Collection messages = combinedIndex.getIndex().getAllKnownSubclasses(GrpcDotNames.GENERATED_MESSAGE_V3);
        for (Object message : messages) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new String[]{message.name().toString()}));
        }
        Collection builders = combinedIndex.getIndex().getAllKnownSubclasses(GrpcDotNames.MESSAGE_BUILDER);
        for (Object builder : builders) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new String[]{builder.name().toString()}));
        }
        Collection lbs = combinedIndex.getIndex().getAllKnownSubclasses(GrpcDotNames.LOAD_BALANCER_PROVIDER);
        for (ClassInfo lb : lbs) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, false, new String[]{lb.name().toString()}));
        }
        Collection nrs = combinedIndex.getIndex().getAllKnownSubclasses(GrpcDotNames.NAME_RESOLVER_PROVIDER);
        for (ClassInfo nr : nrs) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, false, new String[]{nr.name().toString()}));
        }
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, false, new Class[]{DnsNameResolverProvider.class}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, false, new Class[]{PickFirstLoadBalancerProvider.class}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, false, new String[]{"io.grpc.util.SecretRoundRobinLoadBalancerProvider$Provider"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, false, new Class[]{NettyChannelProvider.class}));
    }

    @BuildStep
    NativeImageConfigBuildItem nativeImageConfiguration() {
        NativeImageConfigBuildItem.Builder builder = NativeImageConfigBuildItem.builder().addRuntimeInitializedClass("io.grpc.netty.Utils$ByteBufAllocatorPreferDirectHolder").addRuntimeInitializedClass("io.grpc.netty.Utils$ByteBufAllocatorPreferHeapHolder").addRuntimeInitializedClass("io.grpc.netty.Utils").addRuntimeInitializedClass("io.grpc.netty.NettyServerBuilder").addRuntimeInitializedClass("io.grpc.netty.NettyChannelBuilder");
        return builder.build();
    }
}

