/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.deployment;

import io.grpc.Channel;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.processor.BeanConfigurator;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.grpc.deployment.GrpcDotNames;
import io.quarkus.grpc.deployment.GrpcServiceBuildItem;
import io.quarkus.grpc.deployment.ResourceRegistrationUtils;
import io.quarkus.grpc.runtime.GrpcClientInterceptorContainer;
import io.quarkus.grpc.runtime.annotations.GrpcService;
import io.quarkus.grpc.runtime.supports.Channels;
import io.quarkus.grpc.runtime.supports.GrpcClientConfigProvider;
import io.quarkus.grpc.runtime.supports.IOThreadClientInterceptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.enterprise.inject.spi.DeploymentException;
import javax.inject.Singleton;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class GrpcClientProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)GrpcClientProcessor.class.getName());
    private static final String SSL_PREFIX = "quarkus\\.grpc\\.clients\\..*.ssl\\.";
    private static final Pattern KEY_PATTERN = Pattern.compile("quarkus\\.grpc\\.clients\\..*.ssl\\.key");
    private static final Pattern CERTIFICATE_PATTERN = Pattern.compile("quarkus\\.grpc\\.clients\\..*.ssl\\.certificate");
    private static final Pattern TRUST_STORE_PATTERN = Pattern.compile("quarkus\\.grpc\\.clients\\..*.ssl\\.trust-store");

    @BuildStep
    void registerBeans(BuildProducer<AdditionalBeanBuildItem> beans) {
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(GrpcService.class));
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(GrpcClientConfigProvider.class));
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(GrpcClientInterceptorContainer.class));
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(IOThreadClientInterceptor.class));
    }

    @BuildStep
    void discoverInjectedGrpcServices(BeanRegistrationPhaseBuildItem phase, final BuildProducer<GrpcServiceBuildItem> services, BuildProducer<FeatureBuildItem> features) {
        HashMap<String, GrpcServiceBuildItem> items = new HashMap<String, GrpcServiceBuildItem>();
        for (InjectionPointInfo injectionPoint : (Collection)phase.getContext().get(BuildExtension.Key.INJECTION_POINTS)) {
            Type injectionType;
            ClassType type;
            GrpcServiceBuildItem item;
            AnnotationInstance instance = injectionPoint.getRequiredQualifier(GrpcDotNames.GRPC_SERVICE);
            if (instance == null) continue;
            String name = instance.value().asString();
            if (name.trim().isEmpty()) {
                throw new DeploymentException("Invalid @GrpcService `" + injectionPoint.getTargetInfo() + "` - missing configuration key");
            }
            if (items.containsKey(name)) {
                item = (GrpcServiceBuildItem)((Object)items.get(name));
            } else {
                item = new GrpcServiceBuildItem(name);
                items.put(name, item);
            }
            if ((type = (injectionType = injectionPoint.getRequiredType()).kind() == Type.Kind.PARAMETERIZED_TYPE ? ((Type)injectionType.asParameterizedType().arguments().get(0)).asClassType() : injectionType.asClassType()).name().equals((Object)GrpcDotNames.CHANNEL)) continue;
            item.addStubClass(type);
        }
        items.values().forEach(new Consumer<GrpcServiceBuildItem>(){

            @Override
            public void accept(GrpcServiceBuildItem item) {
                services.produce((BuildItem)item);
                LOGGER.debugf("Detected GrpcService associated with the '%s' configuration prefix", (Object)item.name);
            }
        });
        if (!items.isEmpty()) {
            features.produce((BuildItem)new FeatureBuildItem(Feature.GRPC_CLIENT));
        }
    }

    private boolean isMutinyStub(DotName name) {
        return name.local().startsWith("Mutiny") && name.local().endsWith("Stub");
    }

    @BuildStep
    public void generateGrpcServicesProducers(List<GrpcServiceBuildItem> services, BeanRegistrationPhaseBuildItem phase, BuildProducer<BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem> beans) {
        for (final GrpcServiceBuildItem svc : services) {
            BeanConfigurator channelProducer = (BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)phase.getContext().configure(GrpcDotNames.CHANNEL).types(new Class[]{Channel.class})).addQualifier().annotation(GrpcDotNames.GRPC_SERVICE).addValue("value", (Object)svc.getServiceName()).done()).scope(Singleton.class)).unremovable()).creator((Consumer)new Consumer<MethodCreator>(){

                @Override
                public void accept(MethodCreator mc) {
                    GrpcClientProcessor.this.generateChannelProducer(mc, svc);
                }
            })).destroyer(Channels.ChannelDestroyer.class);
            channelProducer.done();
            beans.produce((BuildItem)new BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem(new BeanConfigurator[]{channelProducer}));
            final String svcName = svc.getServiceName();
            for (ClassType stubClass : svc.getStubClasses()) {
                final DotName stubClassName = stubClass.name();
                BeanConfigurator stubProducer = (BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)phase.getContext().configure(stubClassName).types(new Type[]{stubClass})).addQualifier().annotation(GrpcDotNames.GRPC_SERVICE).addValue("value", (Object)svcName).done()).scope(Singleton.class)).creator((Consumer)new Consumer<MethodCreator>(){

                    @Override
                    public void accept(MethodCreator mc) {
                        GrpcClientProcessor.this.generateStubProducer(mc, svcName, stubClassName, GrpcClientProcessor.this.isMutinyStub(stubClassName));
                    }
                });
                stubProducer.done();
                beans.produce((BuildItem)new BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem(new BeanConfigurator[]{stubProducer}));
            }
        }
    }

    @BuildStep
    void registerSslResources(BuildProducer<NativeImageResourceBuildItem> resourceBuildItem) {
        Config config = ConfigProvider.getConfig();
        ResourceRegistrationUtils.registerResourcesForProperties(config, resourceBuildItem, TRUST_STORE_PATTERN, CERTIFICATE_PATTERN, KEY_PATTERN);
    }

    @BuildStep
    void runtimeInitialize(BuildProducer<RuntimeInitializedClassBuildItem> producer) {
        producer.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.grpc.internal.RetriableStream"));
    }

    private void generateChannelProducer(MethodCreator mc, GrpcServiceBuildItem svc) {
        ResultHandle name = mc.load(svc.getServiceName());
        ResultHandle result = mc.invokeStaticMethod(GrpcDotNames.CREATE_CHANNEL_METHOD, new ResultHandle[]{name});
        mc.returnValue(result);
        mc.close();
    }

    private void generateStubProducer(MethodCreator mc, String svcName, DotName stubClassName, boolean mutiny) {
        ResultHandle prefix = mc.load(svcName);
        ResultHandle channel = mc.invokeStaticMethod(GrpcDotNames.RETRIEVE_CHANNEL_METHOD, new ResultHandle[]{prefix});
        MethodDescriptor descriptor = mutiny ? MethodDescriptor.ofMethod((String)this.convertToServiceName(stubClassName), (String)"newMutinyStub", (String)stubClassName.toString(), (String[])new String[]{Channel.class.getName()}) : MethodDescriptor.ofMethod((String)this.convertToServiceName(stubClassName), (String)"newBlockingStub", (String)stubClassName.toString(), (String[])new String[]{Channel.class.getName()});
        ResultHandle stub = mc.invokeStaticMethod(descriptor, new ResultHandle[]{channel});
        mc.returnValue(stub);
        mc.close();
    }

    private String convertToServiceName(DotName stubName) {
        if (stubName.isInner()) {
            return stubName.prefix().toString();
        }
        return stubName.toString();
    }
}

