/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.deployment;

import io.grpc.Channel;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.processor.BeanConfigurator;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.grpc.deployment.GrpcDotNames;
import io.quarkus.grpc.deployment.GrpcServiceBuildItem;
import io.quarkus.grpc.runtime.GrpcClientInterceptorContainer;
import io.quarkus.grpc.runtime.annotations.GrpcService;
import io.quarkus.grpc.runtime.supports.GrpcClientConfigProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.enterprise.inject.spi.DeploymentException;
import javax.inject.Singleton;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class GrpcClientProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)GrpcClientProcessor.class.getName());

    @BuildStep
    void registerBeans(BuildProducer<AdditionalBeanBuildItem> beans) {
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(GrpcService.class));
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(GrpcClientConfigProvider.class));
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(GrpcClientInterceptorContainer.class));
    }

    @BuildStep
    void discoverInjectedGrpcServices(BeanRegistrationPhaseBuildItem phase, final BuildProducer<GrpcServiceBuildItem> services, BuildProducer<FeatureBuildItem> features) {
        HashMap<String, GrpcServiceBuildItem> items = new HashMap<String, GrpcServiceBuildItem>();
        for (InjectionPointInfo injectionPoint : (Collection)phase.getContext().get(BuildExtension.Key.INJECTION_POINTS)) {
            Type injectionType;
            ClassType type;
            GrpcServiceBuildItem item;
            AnnotationInstance instance = injectionPoint.getRequiredQualifier(GrpcDotNames.GRPC_SERVICE);
            if (instance == null) continue;
            String name = instance.value().asString();
            if (name.trim().isEmpty()) {
                throw new DeploymentException("Invalid @GrpcService `" + injectionPoint.getTargetInfo() + "` - missing configuration key");
            }
            if (items.containsKey(name)) {
                item = (GrpcServiceBuildItem)((Object)items.get(name));
            } else {
                item = new GrpcServiceBuildItem(name);
                items.put(name, item);
            }
            if ((type = (injectionType = injectionPoint.getRequiredType()).kind() == Type.Kind.PARAMETERIZED_TYPE ? ((Type)injectionType.asParameterizedType().arguments().get(0)).asClassType() : injectionType.asClassType()).name().equals((Object)GrpcDotNames.CHANNEL)) continue;
            if (this.isMutinyStub(type.name())) {
                item.setMutinyStubClass(type);
                continue;
            }
            item.setBlockingStubClass(type);
        }
        items.values().forEach(new Consumer<GrpcServiceBuildItem>(){

            @Override
            public void accept(GrpcServiceBuildItem item) {
                services.produce((BuildItem)item);
                LOGGER.debugf("Detected GrpcService associated with the '%s' configuration prefix", (Object)item.name);
            }
        });
        if (!items.isEmpty()) {
            features.produce((BuildItem)new FeatureBuildItem(Feature.GRPC_CLIENT));
        }
    }

    private boolean isMutinyStub(DotName name) {
        return name.local().startsWith("Mutiny") && name.local().endsWith("Stub");
    }

    @BuildStep
    public void generateGrpcServicesProducers(List<GrpcServiceBuildItem> services, BeanRegistrationPhaseBuildItem phase, BuildProducer<BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem> beans) {
        for (final GrpcServiceBuildItem svc : services) {
            BeanConfigurator blockingStubProducer;
            BeanConfigurator channelProducer = (BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)phase.getContext().configure(GrpcDotNames.CHANNEL).types(new Class[]{Channel.class})).addQualifier().annotation(GrpcDotNames.GRPC_SERVICE).addValue("value", (Object)svc.getServiceName()).done()).scope(Singleton.class)).unremovable()).creator((Consumer)new Consumer<MethodCreator>(){

                @Override
                public void accept(MethodCreator mc) {
                    GrpcClientProcessor.this.generateChannelProducer(mc, svc);
                }
            });
            channelProducer.done();
            beans.produce((BuildItem)new BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem(new BeanConfigurator[]{channelProducer}));
            if (svc.blockingStubClass != null) {
                blockingStubProducer = (BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)phase.getContext().configure(svc.blockingStubClass.name()).types(new Type[]{svc.blockingStubClass})).addQualifier().annotation(GrpcDotNames.GRPC_SERVICE).addValue("value", (Object)svc.getServiceName()).done()).scope(Singleton.class)).creator((Consumer)new Consumer<MethodCreator>(){

                    @Override
                    public void accept(MethodCreator mc) {
                        GrpcClientProcessor.this.generateStubProducer(mc, svc, false);
                    }
                });
                blockingStubProducer.done();
                beans.produce((BuildItem)new BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem(new BeanConfigurator[]{blockingStubProducer}));
            }
            if (svc.mutinyStubClass == null) continue;
            blockingStubProducer = (BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)phase.getContext().configure(svc.mutinyStubClass.name()).types(new Type[]{svc.mutinyStubClass})).addQualifier().annotation(GrpcDotNames.GRPC_SERVICE).addValue("value", (Object)svc.getServiceName()).done()).scope(Singleton.class)).creator((Consumer)new Consumer<MethodCreator>(){

                @Override
                public void accept(MethodCreator mc) {
                    GrpcClientProcessor.this.generateStubProducer(mc, svc, true);
                }
            });
            blockingStubProducer.done();
            beans.produce((BuildItem)new BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem(new BeanConfigurator[]{blockingStubProducer}));
        }
    }

    private void generateChannelProducer(MethodCreator mc, GrpcServiceBuildItem svc) {
        ResultHandle name = mc.load(svc.getServiceName());
        ResultHandle result = mc.invokeStaticMethod(GrpcDotNames.CREATE_CHANNEL_METHOD, new ResultHandle[]{name});
        mc.returnValue(result);
        mc.close();
    }

    private void generateStubProducer(MethodCreator mc, GrpcServiceBuildItem svc, boolean mutiny) {
        ResultHandle prefix = mc.load(svc.getServiceName());
        ResultHandle channel = mc.invokeStaticMethod(GrpcDotNames.RETRIEVE_CHANNEL_METHOD, new ResultHandle[]{prefix});
        MethodDescriptor descriptor = mutiny ? MethodDescriptor.ofMethod((String)svc.getMutinyGrpcServiceName(), (String)"newMutinyStub", (String)svc.mutinyStubClass.name().toString(), (String[])new String[]{Channel.class.getName()}) : MethodDescriptor.ofMethod((String)svc.getBlockingGrpcServiceName(), (String)"newBlockingStub", (String)svc.blockingStubClass.name().toString(), (String[])new String[]{Channel.class.getName()});
        ResultHandle stub = mc.invokeStaticMethod(descriptor, new ResultHandle[]{channel});
        mc.returnValue(stub);
        mc.close();
    }
}

