/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.deployment;

import io.quarkus.builder.item.MultiBuildItem;
import javax.enterprise.inject.spi.DeploymentException;
import org.jboss.jandex.ClassType;

public final class GrpcServiceBuildItem
extends MultiBuildItem {
    ClassType blockingStubClass;
    ClassType mutinyStubClass;
    final String name;

    public GrpcServiceBuildItem(String name) {
        this.name = name;
    }

    public void setBlockingStubClass(ClassType blockingStubClass) {
        if (this.blockingStubClass != null && !this.blockingStubClass.name().equals((Object)blockingStubClass.name())) {
            throw new DeploymentException("Invalid gRPC Service - multiple stubs founds for " + this.name);
        }
        this.blockingStubClass = blockingStubClass;
    }

    public void setMutinyStubClass(ClassType mutinyStubClass) {
        if (this.mutinyStubClass != null && !this.mutinyStubClass.name().equals((Object)mutinyStubClass.name())) {
            throw new DeploymentException("Invalid gRPC Service - multiple stubs founds for " + this.name);
        }
        this.mutinyStubClass = mutinyStubClass;
    }

    public String getServiceName() {
        return this.name;
    }

    public String getBlockingGrpcServiceName() {
        if (this.blockingStubClass.name().isInner()) {
            return this.blockingStubClass.name().prefix().toString();
        }
        return this.blockingStubClass.name().toString();
    }

    public String getMutinyGrpcServiceName() {
        if (this.mutinyStubClass.name().isInner()) {
            return this.mutinyStubClass.name().prefix().toString();
        }
        return this.mutinyStubClass.name().toString();
    }
}

