/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.deployment;

import io.quarkus.builder.item.MultiBuildItem;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jboss.jandex.DotName;

public final class GrpcClientBuildItem
extends MultiBuildItem {
    private final String clientName;
    private final Set<ClientInfo> clients;

    public GrpcClientBuildItem(String name) {
        this.clientName = name;
        this.clients = new HashSet<ClientInfo>();
    }

    public Set<ClientInfo> getClients() {
        return this.clients;
    }

    public void addClient(ClientInfo client) {
        this.clients.add(client);
    }

    public String getClientName() {
        return this.clientName;
    }

    public static enum ClientType {
        BLOCKING_STUB("newBlockingStub"),
        MUTINY_STUB("newMutinyStub"),
        MUTINY_CLIENT(null);

        private final String factoryMethodName;

        private ClientType(String factoryMethodName) {
            this.factoryMethodName = factoryMethodName;
        }

        public String getFactoryMethodName() {
            return this.factoryMethodName;
        }
    }

    public static final class ClientInfo {
        public final DotName className;
        public final ClientType type;
        public final DotName implName;

        public ClientInfo(DotName className, ClientType type) {
            this(className, type, null);
        }

        public ClientInfo(DotName className, ClientType type, DotName implName) {
            this.className = className;
            this.type = type;
            this.implName = implName;
        }

        public int hashCode() {
            return Objects.hash(this.className);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClientInfo other = (ClientInfo)obj;
            return Objects.equals(this.className, other.className);
        }
    }
}

