/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.deployment;

import io.grpc.internal.ServerImpl;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.deployment.SyntheticBeansRuntimeInitBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.grpc.GrpcService;
import io.quarkus.grpc.deployment.BindableServiceBuildItem;
import io.quarkus.grpc.deployment.GrpcBuildTimeConfig;
import io.quarkus.grpc.deployment.GrpcDotNames;
import io.quarkus.grpc.deployment.ResourceRegistrationUtils;
import io.quarkus.grpc.deployment.devmode.FieldDefinalizingVisitor;
import io.quarkus.grpc.runtime.GrpcContainer;
import io.quarkus.grpc.runtime.GrpcServerRecorder;
import io.quarkus.grpc.runtime.config.GrpcConfiguration;
import io.quarkus.grpc.runtime.config.GrpcServerBuildTimeConfig;
import io.quarkus.grpc.runtime.health.GrpcHealthEndpoint;
import io.quarkus.grpc.runtime.health.GrpcHealthStorage;
import io.quarkus.kubernetes.spi.KubernetesPortBuildItem;
import io.quarkus.netty.deployment.MinNettyAllocatorMaxOrderBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import io.quarkus.vertx.deployment.VertxBuildItem;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class GrpcServerProcessor {
    private static final Set<String> BLOCKING_SKIPPED_METHODS = Set.of("bindService", "<init>", "withCompression");
    private static final Logger logger = Logger.getLogger(GrpcServerProcessor.class);
    private static final String SSL_PREFIX = "quarkus.grpc.server.ssl.";
    private static final String CERTIFICATE = "quarkus.grpc.server.ssl.certificate";
    private static final String KEY = "quarkus.grpc.server.ssl.key";
    private static final String KEY_STORE = "quarkus.grpc.server.ssl.key-store";
    private static final String TRUST_STORE = "quarkus.grpc.server.ssl.trust-store";

    @BuildStep
    MinNettyAllocatorMaxOrderBuildItem setMinimalNettyMaxOrderSize() {
        return new MinNettyAllocatorMaxOrderBuildItem(3);
    }

    @BuildStep
    void processGeneratedBeans(CombinedIndexBuildItem index, BuildProducer<AnnotationsTransformerBuildItem> transformers, BuildProducer<BindableServiceBuildItem> bindables) {
        final HashMap<DotName, Set<MethodInfo>> generatedBeans = new HashMap<DotName, Set<MethodInfo>>();
        String[] excludedPackages = new String[]{"grpc.health.v1", "io.grpc.reflection"};
        for (ClassInfo classInfo : index.getIndex().getKnownDirectImplementors(GrpcDotNames.MUTINY_BEAN)) {
            FieldInfo delegateField = classInfo.field("delegate");
            if (delegateField == null) {
                throw new IllegalStateException("A generated bean does not declare the delegate field: " + classInfo);
            }
            DotName serviceInterface = delegateField.type().name();
            Collection serviceCandidates = index.getIndex().getAllKnownImplementors(serviceInterface);
            if (serviceCandidates.isEmpty()) continue;
            ClassInfo userDefinedBean = null;
            for (ClassInfo candidate : serviceCandidates) {
                if (candidate.classAnnotation(GrpcDotNames.GRPC_SERVICE) == null) continue;
                userDefinedBean = candidate;
                break;
            }
            if (userDefinedBean == null) continue;
            DotName mutinyImplBase = classInfo.superName();
            if (index.getIndex().getAllKnownSubclasses(mutinyImplBase).size() != 1) continue;
            String mutinyImplBaseName = mutinyImplBase.toString();
            DotName implBase = DotName.createSimple((String)mutinyImplBaseName.replace("Mutiny", ""));
            if (!index.getIndex().getAllKnownSubclasses(implBase).isEmpty()) continue;
            boolean excluded = false;
            for (String excludedPackage : excludedPackages) {
                if (!mutinyImplBaseName.startsWith(excludedPackage)) continue;
                excluded = true;
                break;
            }
            if (excluded) continue;
            logger.debugf("Registering generated gRPC bean %s that will delegate to %s", (Object)classInfo, (Object)userDefinedBean);
            Set<MethodInfo> blockingMethods = this.gatherBlockingMethods(userDefinedBean);
            generatedBeans.put(classInfo.name(), blockingMethods);
        }
        if (!generatedBeans.isEmpty()) {
            for (Map.Entry entry : generatedBeans.entrySet()) {
                BindableServiceBuildItem bindableService = new BindableServiceBuildItem((DotName)entry.getKey());
                for (MethodInfo blockingMethod : (Set)entry.getValue()) {
                    bindableService.registerBlockingMethod(blockingMethod.name());
                }
                bindables.produce((BuildItem)bindableService);
            }
            transformers.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

                public boolean appliesTo(AnnotationTarget.Kind kind) {
                    return kind == AnnotationTarget.Kind.CLASS;
                }

                public void transform(AnnotationsTransformer.TransformationContext context) {
                    if (generatedBeans.containsKey(context.getTarget().asClass().name())) {
                        ((Transformation)((Transformation)context.transform().add(BuiltinScope.SINGLETON.getName(), new AnnotationValue[0])).add(GrpcDotNames.GRPC_SERVICE, new AnnotationValue[0])).done();
                    }
                }
            }));
        }
    }

    @BuildStep
    void discoverBindableServices(BuildProducer<BindableServiceBuildItem> bindables, CombinedIndexBuildItem combinedIndexBuildItem) {
        Collection bindableServices = combinedIndexBuildItem.getIndex().getAllKnownImplementors(GrpcDotNames.BINDABLE_SERVICE);
        for (ClassInfo service : bindableServices) {
            if (service.interfaceNames().contains(GrpcDotNames.MUTINY_BEAN) || Modifier.isAbstract(service.flags())) continue;
            BindableServiceBuildItem item = new BindableServiceBuildItem(service.name());
            Set<MethodInfo> blockingMethods = this.gatherBlockingMethods(service);
            for (MethodInfo method : blockingMethods) {
                item.registerBlockingMethod(method.name());
            }
            bindables.produce((BuildItem)item);
        }
    }

    private Set<MethodInfo> gatherBlockingMethods(ClassInfo service) {
        HashSet<MethodInfo> result = new HashSet<MethodInfo>();
        boolean classHasBlocking = service.classAnnotation(GrpcDotNames.BLOCKING) != null;
        for (MethodInfo method : service.methods()) {
            if (BLOCKING_SKIPPED_METHODS.contains(method.name()) || !method.hasAnnotation(GrpcDotNames.BLOCKING) && (!classHasBlocking || method.hasAnnotation(GrpcDotNames.NON_BLOCKING))) continue;
            result.add(method);
        }
        return result;
    }

    @BuildStep
    AnnotationsTransformerBuildItem transformUserDefinedServices(CombinedIndexBuildItem combinedIndexBuildItem, final CustomScopeAnnotationsBuildItem customScopes) {
        final HashSet<DotName> userDefinedServices = new HashSet<DotName>();
        for (AnnotationInstance annotation : combinedIndexBuildItem.getIndex().getAnnotations(GrpcDotNames.GRPC_SERVICE)) {
            if (annotation.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            userDefinedServices.add(annotation.target().asClass().name());
        }
        if (userDefinedServices.isEmpty()) {
            return null;
        }
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                ClassInfo clazz = context.getTarget().asClass();
                if (userDefinedServices.contains(clazz.name()) && !customScopes.isScopeDeclaredOn(clazz)) {
                    ((Transformation)context.transform().add(BuiltinScope.SINGLETON.getName(), new AnnotationValue[0])).done();
                }
            }
        });
    }

    @BuildStep
    void validateBindableServices(ValidationPhaseBuildItem validationPhase, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors) {
        Type mutinyBeanType = Type.create((DotName)GrpcDotNames.MUTINY_BEAN, (Type.Kind)Type.Kind.CLASS);
        final Type mutinyServiceType = Type.create((DotName)GrpcDotNames.MUTINY_SERVICE, (Type.Kind)Type.Kind.CLASS);
        final Type bindableServiceType = Type.create((DotName)GrpcDotNames.BINDABLE_SERVICE, (Type.Kind)Type.Kind.CLASS);
        Predicate<Set<Type>> predicate = new Predicate<Set<Type>>(){

            @Override
            public boolean test(Set<Type> types) {
                return types.contains(bindableServiceType) || types.contains(mutinyServiceType);
            }
        };
        for (BeanInfo bean : validationPhase.getContext().beans().classBeans().matchBeanTypes((Predicate)predicate)) {
            this.validateBindableService(bean, mutinyBeanType, errors);
        }
        for (BeanInfo bean : validationPhase.getContext().removedBeans().classBeans().matchBeanTypes((Predicate)predicate)) {
            this.validateBindableService(bean, mutinyBeanType, errors);
        }
    }

    private void validateBindableService(BeanInfo bean, Type generatedBeanType, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors) {
        if (!bean.getTypes().contains(generatedBeanType)) {
            if (bean.getQualifiers().stream().map(AnnotationInstance::name).noneMatch(arg_0 -> ((DotName)GrpcDotNames.GRPC_SERVICE).equals(arg_0))) {
                errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException("A gRPC service bean must be annotated with @io.quarkus.grpc.GrpcService: " + bean)}));
            }
        }
        if (!bean.getScope().getDotName().equals((Object)BuiltinScope.SINGLETON.getName())) {
            errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException("A gRPC service bean must have the javax.inject.Singleton scope: " + bean)}));
        }
    }

    @BuildStep(onlyIf={IsNormal.class})
    KubernetesPortBuildItem registerGrpcServiceInKubernetes(List<BindableServiceBuildItem> bindables) {
        if (!bindables.isEmpty()) {
            int port = ConfigProvider.getConfig().getOptionalValue("quarkus.grpc.server.port", Integer.class).orElse(9000);
            return new KubernetesPortBuildItem(port, Feature.GRPC_SERVER);
        }
        return null;
    }

    @BuildStep
    void registerBeans(BuildProducer<AdditionalBeanBuildItem> beans, List<BindableServiceBuildItem> bindables, BuildProducer<FeatureBuildItem> features) {
        beans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{GrpcService.class}));
        if (!bindables.isEmpty() || LaunchMode.current() == LaunchMode.DEVELOPMENT) {
            beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(GrpcContainer.class));
            features.produce((BuildItem)new FeatureBuildItem(Feature.GRPC_SERVER));
        } else {
            logger.debug((Object)"Unable to find beans exposing the `BindableService` interface - not starting the gRPC server");
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Consume(value=SyntheticBeansRuntimeInitBuildItem.class)
    ServiceStartBuildItem initializeServer(GrpcServerRecorder recorder, GrpcConfiguration config, ShutdownContextBuildItem shutdown, List<BindableServiceBuildItem> bindables, LaunchModeBuildItem launchModeBuildItem, VertxBuildItem vertx) {
        HashMap<String, List<String>> blocking = new HashMap<String, List<String>>();
        for (BindableServiceBuildItem bindable : bindables) {
            if (!bindable.hasBlockingMethods()) continue;
            blocking.put(bindable.serviceClass.toString(), bindable.blockingMethods);
        }
        if (!bindables.isEmpty() || LaunchMode.current() == LaunchMode.DEVELOPMENT) {
            recorder.initializeGrpcServer(vertx.getVertx(), config, (ShutdownContext)shutdown, blocking, launchModeBuildItem.getLaunchMode());
            return new ServiceStartBuildItem(Feature.GRPC_SERVER);
        }
        return null;
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void definializeGrpcFieldsForDevMode(BuildProducer<BytecodeTransformerBuildItem> transformers) {
        transformers.produce((BuildItem)new BytecodeTransformerBuildItem("io.grpc.internal.InternalHandlerRegistry", (BiFunction)new FieldDefinalizingVisitor("services", "methods")));
        transformers.produce((BuildItem)new BytecodeTransformerBuildItem(ServerImpl.class.getName(), (BiFunction)new FieldDefinalizingVisitor("interceptors")));
    }

    @BuildStep
    void addHealthChecks(GrpcServerBuildTimeConfig config, List<BindableServiceBuildItem> bindables, BuildProducer<HealthBuildItem> healthBuildItems, BuildProducer<AdditionalBeanBuildItem> beans) {
        boolean healthEnabled = false;
        if (!bindables.isEmpty()) {
            healthEnabled = config.mpHealthEnabled;
            if (config.grpcHealthEnabled) {
                beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(GrpcHealthEndpoint.class));
                healthEnabled = true;
            }
            healthBuildItems.produce((BuildItem)new HealthBuildItem("io.quarkus.grpc.runtime.health.GrpcHealthCheck", config.mpHealthEnabled));
        }
        if (healthEnabled || LaunchMode.current() == LaunchMode.DEVELOPMENT) {
            beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(GrpcHealthStorage.class));
        }
    }

    @BuildStep
    void registerSslResources(BuildProducer<NativeImageResourceBuildItem> resourceBuildItem) {
        Config config = ConfigProvider.getConfig();
        for (String sslProperty : Arrays.asList(CERTIFICATE, KEY, KEY_STORE, TRUST_STORE)) {
            config.getOptionalValue(sslProperty, String.class).ifPresent(value -> ResourceRegistrationUtils.registerResourceForProperty(resourceBuildItem, value));
        }
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem extensionSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(Feature.GRPC_SERVER);
    }

    @BuildStep
    void configureMetrics(GrpcBuildTimeConfig configuration, Optional<MetricsCapabilityBuildItem> metricsCapability, BuildProducer<AdditionalBeanBuildItem> beans) {
        if (configuration.metricsEnabled && metricsCapability.isPresent()) {
            if (metricsCapability.get().metricsSupported("micrometer")) {
                beans.produce((BuildItem)new AdditionalBeanBuildItem(new String[]{"io.quarkus.grpc.runtime.metrics.GrpcMetricsServerInterceptor", "io.quarkus.grpc.runtime.metrics.GrpcMetricsClientInterceptor"}));
            } else {
                logger.warn((Object)"Only Micrometer-based metrics system is supported by quarkus-grpc");
            }
        }
    }
}

