/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.deployment.devmode;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import grpc.health.v1.HealthGrpc;
import io.grpc.MethodDescriptor;
import io.grpc.ServiceDescriptor;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.arc.runtime.BeanLookupSupplier;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.RuntimeConfigSetupCompleteBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.dev.testing.GrpcWebSocketProxy;
import io.quarkus.devconsole.spi.DevConsoleRouteBuildItem;
import io.quarkus.devconsole.spi.DevConsoleRuntimeTemplateInfoBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.grpc.deployment.DelegatingGrpcBeanBuildItem;
import io.quarkus.grpc.deployment.GrpcDotNames;
import io.quarkus.grpc.deployment.devmode.GrpcDevConsoleWebSocketListener;
import io.quarkus.grpc.runtime.config.GrpcConfiguration;
import io.quarkus.grpc.runtime.devmode.CollectStreams;
import io.quarkus.grpc.runtime.devmode.DelegatingGrpcBeansStorage;
import io.quarkus.grpc.runtime.devmode.GrpcDevConsoleRecorder;
import io.quarkus.grpc.runtime.devmode.GrpcServices;
import io.quarkus.grpc.runtime.devmode.StreamCollectorInterceptor;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Singleton;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class GrpcDevConsoleProcessor {
    @BuildStep(onlyIf={IsDevelopment.class})
    public void devConsoleInfo(BuildProducer<DevConsoleRuntimeTemplateInfoBuildItem> infos, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        infos.produce((BuildItem)new DevConsoleRuntimeTemplateInfoBuildItem("grpcServices", (Supplier)new BeanLookupSupplier(GrpcServices.class), this.getClass(), curateOutcomeBuildItem));
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    public AdditionalBeanBuildItem beans() {
        return AdditionalBeanBuildItem.builder().addBeanClass(GrpcServices.class).addBeanClasses(new Class[]{StreamCollectorInterceptor.class, CollectStreams.class}).build();
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void prepareDelegatingBeanStorage(List<DelegatingGrpcBeanBuildItem> delegatingBeans, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, BuildProducer<GeneratedBeanBuildItem> generatedBeans) {
        String className = "io.quarkus.grpc.internal.DelegatingGrpcBeansStorageImpl";
        try (ClassCreator classCreator = ClassCreator.builder().className(className).classOutput((ClassOutput)new GeneratedBeanGizmoAdaptor(generatedBeans)).superClass(DelegatingGrpcBeansStorage.class).build();){
            classCreator.addAnnotation(Singleton.class.getName());
            MethodCreator constructor = classCreator.getMethodCreator(MethodDescriptor.ofConstructor((String)className, (String[])new String[0]));
            constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor(DelegatingGrpcBeansStorage.class, (Class[])new Class[0]), constructor.getThis(), new ResultHandle[0]);
            for (DelegatingGrpcBeanBuildItem delegatingBean : delegatingBeans) {
                constructor.invokeVirtualMethod(MethodDescriptor.ofMethod(DelegatingGrpcBeansStorage.class, (String)"addDelegatingMapping", Void.TYPE, (Class[])new Class[]{String.class, String.class}), constructor.getThis(), new ResultHandle[]{constructor.load(delegatingBean.userDefinedBean.name().toString()), constructor.load(delegatingBean.generatedBean.name().toString())});
            }
            constructor.returnValue(null);
        }
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassNames((String[])new String[]{className}));
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    public void collectMessagePrototypes(CombinedIndexBuildItem index, BuildProducer<ServiceStartBuildItem> service) throws ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, InvalidProtocolBufferException {
        HashMap<CallSite, String> messagePrototypes = new HashMap<CallSite, String>();
        Collection<Class<?>> grpcServices = this.getGrpcServices(index.getIndex());
        for (Class<?> grpcServiceClass : grpcServices) {
            Method method = grpcServiceClass.getDeclaredMethod("getServiceDescriptor", new Class[0]);
            ServiceDescriptor serviceDescriptor = (ServiceDescriptor)method.invoke(null, new Object[0]);
            for (io.grpc.MethodDescriptor methodDescriptor : serviceDescriptor.getMethods()) {
                MethodDescriptor.Marshaller requestMarshaller = methodDescriptor.getRequestMarshaller();
                if (!(requestMarshaller instanceof MethodDescriptor.PrototypeMarshaller)) continue;
                MethodDescriptor.PrototypeMarshaller protoMarshaller = (MethodDescriptor.PrototypeMarshaller)requestMarshaller;
                Object prototype = protoMarshaller.getMessagePrototype();
                messagePrototypes.put((CallSite)((Object)(methodDescriptor.getFullMethodName() + "_REQUEST")), JsonFormat.printer().includingDefaultValueFields().print((MessageOrBuilder)prototype));
            }
        }
        DevConsoleManager.setGlobal((String)"io.quarkus.grpc.messagePrototypes", messagePrototypes);
        GrpcWebSocketProxy.setWebSocketListener((GrpcWebSocketProxy.WebSocketListener)new GrpcDevConsoleWebSocketListener(grpcServices, Thread.currentThread().getContextClassLoader()));
    }

    @Consume(value=RuntimeConfigSetupCompleteBuildItem.class)
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep(onlyIf={IsDevelopment.class})
    public DevConsoleRouteBuildItem createWebSocketEndpoint(GrpcDevConsoleRecorder recorder, HttpConfiguration httpConfiguration, GrpcConfiguration grpcConfiguration) {
        recorder.setServerConfiguration(httpConfiguration, grpcConfiguration);
        return DevConsoleRouteBuildItem.builder().path("grpc-test").method("GET").handler(recorder.handler()).build();
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    AnnotationsTransformerBuildItem transformUserDefinedServices(CombinedIndexBuildItem combinedIndexBuildItem) {
        final HashSet<DotName> servicesToTransform = new HashSet<DotName>();
        IndexView index = combinedIndexBuildItem.getIndex();
        for (AnnotationInstance annotation : index.getAnnotations(GrpcDotNames.GRPC_SERVICE)) {
            ClassInfo serviceClass;
            if (annotation.target().kind() != AnnotationTarget.Kind.CLASS || this.getRawTypesInHierarchy(serviceClass = annotation.target().asClass(), index).contains(GrpcDotNames.MUTINY_SERVICE)) continue;
            ClassInfo abstractBindableService = this.findAbstractBindableService(serviceClass, index);
            if (abstractBindableService != null) {
                ClassInfo enclosingClass;
                ClassInfo classInfo = enclosingClass = serviceClass.enclosingClass() != null ? index.getClassByName(serviceClass.enclosingClass()) : null;
                if (enclosingClass != null && this.getRawTypesInHierarchy(enclosingClass, index).contains(GrpcDotNames.MUTINY_GRPC)) continue;
            }
            servicesToTransform.add(annotation.target().asClass().name());
        }
        if (servicesToTransform.isEmpty()) {
            return null;
        }
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                ClassInfo clazz = context.getTarget().asClass();
                if (servicesToTransform.contains(clazz.name())) {
                    ((Transformation)context.transform().add(CollectStreams.class, new AnnotationValue[0])).done();
                }
            }
        });
    }

    Collection<Class<?>> getGrpcServices(IndexView index) throws ClassNotFoundException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        HashSet<String> serviceClassNames = new HashSet<String>();
        for (ClassInfo mutinyGrpc : index.getAllKnownImplementors(GrpcDotNames.MUTINY_GRPC)) {
            DotName originalImplName = DotName.createSimple((String)mutinyGrpc.name().toString().replace("Mutiny", ""));
            ClassInfo originalImpl = index.getClassByName(originalImplName);
            if (originalImpl == null) {
                throw new IllegalStateException("The original implementation class of a gRPC service not found:" + originalImplName);
            }
            MethodInfo getServiceDescriptor = originalImpl.method("getServiceDescriptor", new Type[0]);
            if (getServiceDescriptor == null || !Modifier.isStatic(getServiceDescriptor.flags()) || !getServiceDescriptor.returnType().name().toString().equals(ServiceDescriptor.class.getName())) continue;
            serviceClassNames.add(getServiceDescriptor.declaringClass().name().toString());
        }
        ArrayList serviceClasses = new ArrayList();
        for (String className : serviceClassNames) {
            serviceClasses.add(tccl.loadClass(className));
        }
        serviceClasses.add(HealthGrpc.class);
        return serviceClasses;
    }

    private Set<DotName> getRawTypesInHierarchy(ClassInfo clazz, IndexView index) {
        HashSet<DotName> rawTypes = new HashSet<DotName>();
        this.addRawTypes(clazz, index, rawTypes);
        return rawTypes;
    }

    private void addRawTypes(ClassInfo clazz, IndexView index, Set<DotName> rawTypes) {
        ClassInfo superClazz;
        rawTypes.add(clazz.name());
        for (DotName interfaceName : clazz.interfaceNames()) {
            rawTypes.add(interfaceName);
            ClassInfo interfaceClazz = index.getClassByName(interfaceName);
            if (interfaceClazz == null) continue;
            this.addRawTypes(interfaceClazz, index, rawTypes);
        }
        if (clazz.superName() != null && !clazz.superName().equals((Object)DotNames.OBJECT) && (superClazz = index.getClassByName(clazz.superName())) != null) {
            this.addRawTypes(superClazz, index, rawTypes);
        }
    }

    private ClassInfo findAbstractBindableService(ClassInfo clazz, IndexView index) {
        ClassInfo superClazz;
        if (clazz.interfaceNames().contains(GrpcDotNames.BINDABLE_SERVICE)) {
            return clazz;
        }
        if (clazz.superName() != null && !clazz.superName().equals((Object)DotNames.OBJECT) && (superClazz = index.getClassByName(clazz.superName())) != null) {
            return this.findAbstractBindableService(superClazz, index);
        }
        return null;
    }
}

