/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.deployment.devmode;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import grpc.health.v1.HealthGrpc;
import io.grpc.MethodDescriptor;
import io.grpc.ServiceDescriptor;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.runtime.BeanLookupSupplier;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.RuntimeConfigSetupCompleteBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.dev.testing.GrpcWebSocketProxy;
import io.quarkus.devconsole.spi.DevConsoleRuntimeTemplateInfoBuildItem;
import io.quarkus.grpc.deployment.GrpcDotNames;
import io.quarkus.grpc.deployment.devmode.GrpcDevConsoleWebSocketListener;
import io.quarkus.grpc.runtime.devmode.GrpcDevConsoleRecorder;
import io.quarkus.grpc.runtime.devmode.GrpcServices;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Supplier;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class GrpcDevConsoleProcessor {
    @BuildStep(onlyIf={IsDevelopment.class})
    public void devConsoleInfo(BuildProducer<AdditionalBeanBuildItem> beans, BuildProducer<DevConsoleRuntimeTemplateInfoBuildItem> infos) {
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(GrpcServices.class));
        infos.produce((BuildItem)new DevConsoleRuntimeTemplateInfoBuildItem("grpcServices", (Supplier)new BeanLookupSupplier(GrpcServices.class)));
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    public void collectMessagePrototypes(CombinedIndexBuildItem index, BuildProducer<ServiceStartBuildItem> service) throws ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, InvalidProtocolBufferException {
        HashMap<CallSite, String> messagePrototypes = new HashMap<CallSite, String>();
        Collection<Class<?>> grpcServices = this.getGrpcServices(index.getIndex());
        for (Class<?> grpcServiceClass : grpcServices) {
            Method method = grpcServiceClass.getDeclaredMethod("getServiceDescriptor", new Class[0]);
            ServiceDescriptor serviceDescriptor = (ServiceDescriptor)method.invoke(null, new Object[0]);
            for (MethodDescriptor methodDescriptor : serviceDescriptor.getMethods()) {
                MethodDescriptor.Marshaller requestMarshaller = methodDescriptor.getRequestMarshaller();
                if (!(requestMarshaller instanceof MethodDescriptor.PrototypeMarshaller)) continue;
                MethodDescriptor.PrototypeMarshaller protoMarshaller = (MethodDescriptor.PrototypeMarshaller)requestMarshaller;
                Object prototype = protoMarshaller.getMessagePrototype();
                messagePrototypes.put((CallSite)((Object)(methodDescriptor.getFullMethodName() + "_REQUEST")), JsonFormat.printer().includingDefaultValueFields().print((MessageOrBuilder)prototype));
            }
        }
        DevConsoleManager.setGlobal((String)"io.quarkus.grpc.messagePrototypes", messagePrototypes);
        GrpcWebSocketProxy.setWebSocketListener((GrpcWebSocketProxy.WebSocketListener)new GrpcDevConsoleWebSocketListener(grpcServices, Thread.currentThread().getContextClassLoader()));
    }

    @Consume(value=RuntimeConfigSetupCompleteBuildItem.class)
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep(onlyIf={IsDevelopment.class})
    public RouteBuildItem createWebSocketEndpoint(NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, GrpcDevConsoleRecorder recorder) {
        recorder.setServerConfiguration();
        return nonApplicationRootPathBuildItem.routeBuilder().route("dev/grpc-test").handler(recorder.handler()).build();
    }

    Collection<Class<?>> getGrpcServices(IndexView index) throws ClassNotFoundException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        HashSet<String> serviceClassNames = new HashSet<String>();
        for (ClassInfo mutinyGrpc : index.getAllKnownImplementors(GrpcDotNames.MUTINY_GRPC)) {
            DotName originalImplName = DotName.createSimple((String)mutinyGrpc.name().toString().replace("Mutiny", ""));
            ClassInfo originalImpl = index.getClassByName(originalImplName);
            if (originalImpl == null) {
                throw new IllegalStateException("The original implementation class of a gRPC service not found:" + originalImplName);
            }
            MethodInfo getServiceDescriptor = originalImpl.method("getServiceDescriptor", new Type[0]);
            if (getServiceDescriptor == null || !Modifier.isStatic(getServiceDescriptor.flags()) || !getServiceDescriptor.returnType().name().toString().equals(ServiceDescriptor.class.getName())) continue;
            serviceClassNames.add(getServiceDescriptor.declaringClass().name().toString());
        }
        ArrayList serviceClasses = new ArrayList();
        for (String className : serviceClassNames) {
            serviceClasses.add(tccl.loadClass(className));
        }
        serviceClasses.add(HealthGrpc.class);
        return serviceClasses;
    }
}

