/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.deployment.devmode;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.ServiceDescriptor;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.StreamObserver;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.dev.testing.GrpcWebSocketProxy;
import io.vertx.core.json.JsonObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

public class GrpcDevConsoleWebSocketListener
implements GrpcWebSocketProxy.WebSocketListener {
    private static final Logger log = Logger.getLogger(GrpcDevConsoleWebSocketListener.class);
    private Map<String, Object> grpcClientStubs;
    private Map<String, ServiceDescriptor> serviceDescriptors;
    private final ClassLoader deploymentClassLoader;
    private final Collection<Class<?>> grpcServices;
    private final Map<Integer, WebSocketData> webSocketConnections = new ConcurrentHashMap<Integer, WebSocketData>();

    public GrpcDevConsoleWebSocketListener(Collection<Class<?>> grpcServices, ClassLoader deploymentClassLoader) {
        this.grpcServices = grpcServices;
        this.deploymentClassLoader = deploymentClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(String input, final WebSocketData websocketData) {
        block19: {
            ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.deploymentClassLoader);
            try {
                GrpcCallData grpcCall;
                JsonObject grpcRequest = new JsonObject(input);
                final Integer id = grpcRequest.getInteger("id");
                String serviceName = grpcRequest.getString("serviceName");
                String methodName = grpcRequest.getString("methodName");
                if ("DISCONNECT".equals(grpcRequest.getString("command"))) {
                    GrpcCallData grpcCall2 = websocketData.callsInProgress.get(id);
                    if (grpcCall2 != null && grpcCall2.incomingStream != null) {
                        grpcCall2.incomingStream.onCompleted();
                    }
                    return;
                }
                if (websocketData.callsInProgress.containsKey(id)) {
                    grpcCall = websocketData.callsInProgress.get(id);
                } else {
                    Optional<GrpcCallData> maybeOldCall = websocketData.callsInProgress.values().stream().filter(call -> call.methodName.equals(methodName) && call.serviceName.equals(serviceName)).findAny();
                    maybeOldCall.ifPresent(call -> {
                        if (call.incomingStream != null) {
                            call.incomingStream.onCompleted();
                        }
                        websocketData.callsInProgress.remove(call.requestId);
                    });
                    grpcCall = new GrpcCallData();
                    grpcCall.serviceName = serviceName;
                    grpcCall.methodName = methodName;
                    grpcCall.requestId = id;
                    websocketData.callsInProgress.put(grpcCall.requestId, grpcCall);
                }
                String testJsonData = grpcRequest.getString("content");
                Object grpcStub = this.grpcClientStubs.get(serviceName);
                if (grpcStub == null) {
                    websocketData.responseConsumer.accept(this.jsonResponse(id, "NO_STUB").encode());
                    break block19;
                }
                ServiceDescriptor serviceDescriptor = this.serviceDescriptors.get(serviceName);
                MethodDescriptor methodDescriptor = null;
                for (MethodDescriptor method : serviceDescriptor.getMethods()) {
                    if (method.getBareMethodName() == null || !method.getBareMethodName().equals(methodName)) continue;
                    methodDescriptor = method;
                }
                if (methodDescriptor == null) {
                    websocketData.responseConsumer.accept(this.jsonResponse(id, "NO_DESCRIPTOR").encode());
                    break block19;
                }
                Method stubMethod = null;
                String realMethodName = GrpcDevConsoleWebSocketListener.decapitalize(methodDescriptor.getBareMethodName());
                for (Method method : grpcStub.getClass().getDeclaredMethods()) {
                    if (!method.getName().equals(realMethodName)) continue;
                    stubMethod = method;
                }
                if (stubMethod == null) {
                    websocketData.responseConsumer.accept(this.jsonResponse(id, "NO_METHOD").encode());
                    log.error((Object)(realMethodName + " method not declared on the " + grpcStub.getClass()));
                    break block19;
                }
                MethodDescriptor.Marshaller requestMarshaller = methodDescriptor.getRequestMarshaller();
                if (!(requestMarshaller instanceof MethodDescriptor.PrototypeMarshaller)) break block19;
                MethodDescriptor.PrototypeMarshaller protoMarshaller = (MethodDescriptor.PrototypeMarshaller)requestMarshaller;
                Class<?> requestType = protoMarshaller.getMessagePrototype().getClass();
                try {
                    Method newBuilderMethod = requestType.getDeclaredMethod("newBuilder", new Class[0]);
                    Message.Builder builder = (Message.Builder)newBuilderMethod.invoke(null, new Object[0]);
                    JsonFormat.parser().merge(testJsonData, builder);
                    Message message = builder.build();
                    if (grpcCall.incomingStream != null) {
                        grpcCall.incomingStream.onNext((Object)message);
                    } else {
                        StreamObserver<Object> responseObserver = new StreamObserver<Object>(){

                            public void onNext(Object value) {
                                String body = null;
                                try {
                                    body = JsonFormat.printer().print((MessageOrBuilder)value);
                                }
                                catch (InvalidProtocolBufferException e) {
                                    websocketData.responseConsumer.accept(GrpcDevConsoleWebSocketListener.this.jsonResponse(id, "ERROR").put("body", (Object)e.getMessage()).encode());
                                    log.error((Object)"Failed to transform response to JSON", (Throwable)e);
                                }
                                JsonObject reply = GrpcDevConsoleWebSocketListener.this.jsonResponse(id, "PAYLOAD");
                                reply.put("body", (Object)body);
                                websocketData.responseConsumer.accept(reply.encode());
                            }

                            public void onError(Throwable t) {
                                websocketData.responseConsumer.accept(GrpcDevConsoleWebSocketListener.this.jsonResponse(id, "ERROR").put("body", (Object)t.getMessage()).encode());
                                grpcCall.incomingStream = null;
                                log.error((Object)"Failure returned by gRPC service", t);
                            }

                            public void onCompleted() {
                                websocketData.responseConsumer.accept(GrpcDevConsoleWebSocketListener.this.jsonResponse(id, "COMPLETED").encode());
                                grpcCall.incomingStream = null;
                            }
                        };
                        if (stubMethod.getParameterCount() == 1 && stubMethod.getReturnType() == StreamObserver.class) {
                            grpcCall.incomingStream = (StreamObserver)stubMethod.invoke(grpcStub, responseObserver);
                            grpcCall.incomingStream.onNext((Object)message);
                        } else {
                            stubMethod.invoke(grpcStub, message, responseObserver);
                        }
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalCl);
            }
        }
    }

    static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private JsonObject jsonResponse(Integer id, String status) {
        return new JsonObject().put("id", (Object)id).put("status", (Object)status);
    }

    public void init() {
        block6: {
            Map serverConfig = (Map)DevConsoleManager.getGlobal((String)"io.quarkus.grpc.serverConfig");
            if (this.serviceDescriptors != null) {
                return;
            }
            this.serviceDescriptors = new HashMap<String, ServiceDescriptor>();
            this.grpcClientStubs = new HashMap<String, Object>();
            try {
                if (serverConfig != null && !Boolean.FALSE.equals(serverConfig.get("ssl"))) break block6;
                for (Class<?> grpcServiceClass : this.grpcServices) {
                    Method stubFactoryMethod;
                    Method method = grpcServiceClass.getDeclaredMethod("getServiceDescriptor", new Class[0]);
                    ServiceDescriptor serviceDescriptor = (ServiceDescriptor)method.invoke(null, new Object[0]);
                    this.serviceDescriptors.put(serviceDescriptor.getName(), serviceDescriptor);
                    ManagedChannel channel = NettyChannelBuilder.forAddress((String)serverConfig.get("host").toString(), (int)((Integer)serverConfig.get("port"))).usePlaintext().build();
                    try {
                        stubFactoryMethod = grpcServiceClass.getDeclaredMethod("newStub", Channel.class);
                    }
                    catch (NoSuchMethodException e) {
                        log.warnf("Ignoring gRPC service - newStub() method not declared on %s", grpcServiceClass);
                        continue;
                    }
                    Object stub = stubFactoryMethod.invoke(null, channel);
                    this.grpcClientStubs.put(serviceDescriptor.getName(), stub);
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException("Unable to initialize client stubs for gRPC Dev UI");
            }
        }
    }

    public void onOpen(int id, Consumer<String> responseConsumer) {
        this.init();
        this.webSocketConnections.put(id, new WebSocketData(responseConsumer));
    }

    public void newMessage(int id, String content) {
        WebSocketData webSocketData = this.webSocketConnections.get(id);
        if (webSocketData != null) {
            this.handle(content, webSocketData);
        } else {
            log.warn((Object)"gRPC Dev Console WebSocket message for an unregistered WebSocket id");
        }
    }

    public void onClose(int id) {
        this.closeAllClients(id);
        this.webSocketConnections.remove(id);
    }

    private void closeAllClients(int id) {
        WebSocketData webSocketData = this.webSocketConnections.get(id);
        if (webSocketData != null) {
            for (GrpcCallData callData : webSocketData.callsInProgress.values()) {
                try {
                    callData.incomingStream.onCompleted();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static class WebSocketData {
        final Consumer<String> responseConsumer;
        Map<Integer, GrpcCallData> callsInProgress = new HashMap<Integer, GrpcCallData>();

        private WebSocketData(Consumer<String> responseConsumer) {
            this.responseConsumer = responseConsumer;
        }
    }

    private static class GrpcCallData {
        Integer requestId;
        String serviceName;
        String methodName;
        StreamObserver<Message> incomingStream;

        private GrpcCallData() {
        }
    }
}

