/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.deployment;

import io.grpc.internal.ServerImpl;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanArchivePredicateBuildItem;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.SyntheticBeansRuntimeInitBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.grpc.GrpcService;
import io.quarkus.grpc.auth.DefaultAuthExceptionHandlerProvider;
import io.quarkus.grpc.auth.GrpcSecurityInterceptor;
import io.quarkus.grpc.deployment.AdditionalGlobalInterceptorBuildItem;
import io.quarkus.grpc.deployment.BindableServiceBuildItem;
import io.quarkus.grpc.deployment.DelegatingGrpcBeanBuildItem;
import io.quarkus.grpc.deployment.GrpcBuildTimeConfig;
import io.quarkus.grpc.deployment.GrpcDotNames;
import io.quarkus.grpc.deployment.ResourceRegistrationUtils;
import io.quarkus.grpc.deployment.devmode.FieldDefinalizingVisitor;
import io.quarkus.grpc.runtime.GrpcContainer;
import io.quarkus.grpc.runtime.GrpcServerRecorder;
import io.quarkus.grpc.runtime.InterceptorStorage;
import io.quarkus.grpc.runtime.config.GrpcConfiguration;
import io.quarkus.grpc.runtime.config.GrpcServerBuildTimeConfig;
import io.quarkus.grpc.runtime.health.GrpcHealthEndpoint;
import io.quarkus.grpc.runtime.health.GrpcHealthStorage;
import io.quarkus.grpc.runtime.supports.context.GrpcRequestContextGrpcInterceptor;
import io.quarkus.kubernetes.spi.KubernetesPortBuildItem;
import io.quarkus.netty.deployment.MinNettyAllocatorMaxOrderBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import io.quarkus.vertx.deployment.VertxBuildItem;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.enterprise.inject.spi.DeploymentException;
import javax.inject.Singleton;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class GrpcServerProcessor {
    private static final Set<String> BLOCKING_SKIPPED_METHODS = Set.of("bindService", "<init>", "withCompression");
    private static final Logger log = Logger.getLogger(GrpcServerProcessor.class);
    private static final String SSL_PREFIX = "quarkus.grpc.server.ssl.";
    private static final String CERTIFICATE = "quarkus.grpc.server.ssl.certificate";
    private static final String KEY = "quarkus.grpc.server.ssl.key";
    private static final String KEY_STORE = "quarkus.grpc.server.ssl.key-store";
    private static final String TRUST_STORE = "quarkus.grpc.server.ssl.trust-store";
    private static final String METRICS_SERVER_INTERCEPTOR = "io.quarkus.grpc.runtime.metrics.GrpcMetricsServerInterceptor";

    @BuildStep
    MinNettyAllocatorMaxOrderBuildItem setMinimalNettyMaxOrderSize() {
        return new MinNettyAllocatorMaxOrderBuildItem(3);
    }

    @BuildStep
    void processGeneratedBeans(CombinedIndexBuildItem index, BuildProducer<AnnotationsTransformerBuildItem> transformers, BuildProducer<BindableServiceBuildItem> bindables, BuildProducer<DelegatingGrpcBeanBuildItem> delegatingBeans) {
        final HashMap<DotName, Set<MethodInfo>> generatedBeans = new HashMap<DotName, Set<MethodInfo>>();
        String[] excludedPackages = new String[]{"grpc.health.v1", "io.grpc.reflection"};
        for (ClassInfo classInfo : index.getIndex().getKnownDirectImplementors(GrpcDotNames.MUTINY_BEAN)) {
            FieldInfo delegateField = classInfo.field("delegate");
            if (delegateField == null) {
                throw new IllegalStateException("A generated bean does not declare the delegate field: " + classInfo);
            }
            DotName serviceInterface = delegateField.type().name();
            Collection serviceCandidates = index.getIndex().getAllKnownImplementors(serviceInterface);
            if (serviceCandidates.isEmpty()) continue;
            ClassInfo userDefinedBean = null;
            for (ClassInfo candidate : serviceCandidates) {
                if (candidate.classAnnotation(GrpcDotNames.GRPC_SERVICE) == null) continue;
                userDefinedBean = candidate;
                break;
            }
            if (userDefinedBean == null) continue;
            DotName mutinyImplBase = classInfo.superName();
            if (index.getIndex().getAllKnownSubclasses(mutinyImplBase).size() != 1) continue;
            String mutinyImplBaseName = mutinyImplBase.toString();
            DotName implBase = DotName.createSimple((String)mutinyImplBaseName.replace("Mutiny", ""));
            if (!index.getIndex().getAllKnownSubclasses(implBase).isEmpty()) continue;
            boolean excluded = false;
            for (String excludedPackage : excludedPackages) {
                if (!mutinyImplBaseName.startsWith(excludedPackage)) continue;
                excluded = true;
                break;
            }
            if (excluded) continue;
            log.debugf("Registering generated gRPC bean %s that will delegate to %s", (Object)classInfo, (Object)userDefinedBean);
            delegatingBeans.produce((BuildItem)new DelegatingGrpcBeanBuildItem(classInfo, userDefinedBean));
            Set<MethodInfo> blockingMethods = this.gatherBlockingMethods(userDefinedBean);
            generatedBeans.put(classInfo.name(), blockingMethods);
        }
        if (!generatedBeans.isEmpty()) {
            for (Map.Entry entry : generatedBeans.entrySet()) {
                BindableServiceBuildItem bindableService = new BindableServiceBuildItem((DotName)entry.getKey());
                for (MethodInfo blockingMethod : (Set)entry.getValue()) {
                    bindableService.registerBlockingMethod(blockingMethod.name());
                }
                bindables.produce((BuildItem)bindableService);
            }
            transformers.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

                public boolean appliesTo(AnnotationTarget.Kind kind) {
                    return kind == AnnotationTarget.Kind.CLASS;
                }

                public void transform(AnnotationsTransformer.TransformationContext context) {
                    if (generatedBeans.containsKey(context.getTarget().asClass().name())) {
                        ((Transformation)((Transformation)context.transform().add(BuiltinScope.SINGLETON.getName(), new AnnotationValue[0])).add(GrpcDotNames.GRPC_SERVICE, new AnnotationValue[0])).done();
                    }
                }
            }));
        }
    }

    @BuildStep
    void discoverBindableServices(BuildProducer<BindableServiceBuildItem> bindables, CombinedIndexBuildItem combinedIndexBuildItem) {
        Collection bindableServices = combinedIndexBuildItem.getIndex().getAllKnownImplementors(GrpcDotNames.BINDABLE_SERVICE);
        for (ClassInfo service : bindableServices) {
            if (service.interfaceNames().contains(GrpcDotNames.MUTINY_BEAN) || Modifier.isAbstract(service.flags())) continue;
            BindableServiceBuildItem item = new BindableServiceBuildItem(service.name());
            Set<MethodInfo> blockingMethods = this.gatherBlockingMethods(service);
            for (MethodInfo method : blockingMethods) {
                item.registerBlockingMethod(method.name());
            }
            bindables.produce((BuildItem)item);
        }
    }

    private Set<MethodInfo> gatherBlockingMethods(ClassInfo service) {
        boolean blockingClass;
        HashSet<MethodInfo> result = new HashSet<MethodInfo>();
        boolean bl = blockingClass = service.classAnnotation(GrpcDotNames.BLOCKING) != null;
        if (blockingClass && service.classAnnotation(GrpcDotNames.NON_BLOCKING) != null) {
            throw new DeploymentException("Class '" + service.name() + "' contains both @Blocking and @NonBlocking annotations.");
        }
        blockingClass |= service.classAnnotation(GrpcDotNames.TRANSACTIONAL) != null && service.classAnnotation(GrpcDotNames.NON_BLOCKING) == null;
        for (MethodInfo method : service.methods()) {
            if (BLOCKING_SKIPPED_METHODS.contains(method.name())) continue;
            if (method.hasAnnotation(GrpcDotNames.BLOCKING)) {
                if (method.hasAnnotation(GrpcDotNames.NON_BLOCKING)) {
                    throw new DeploymentException("Method '" + method.declaringClass().name() + "#" + method.name() + "' contains both @Blocking and @NonBlocking annotations.");
                }
                result.add(method);
                continue;
            }
            if (!method.hasAnnotation(GrpcDotNames.TRANSACTIONAL) && !blockingClass || method.hasAnnotation(GrpcDotNames.NON_BLOCKING)) continue;
            result.add(method);
        }
        return result;
    }

    @BuildStep
    AnnotationsTransformerBuildItem transformUserDefinedServices(CombinedIndexBuildItem combinedIndexBuildItem, final CustomScopeAnnotationsBuildItem customScopes) {
        final HashSet<DotName> userDefinedServices = new HashSet<DotName>();
        for (AnnotationInstance annotation : combinedIndexBuildItem.getIndex().getAnnotations(GrpcDotNames.GRPC_SERVICE)) {
            if (annotation.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            userDefinedServices.add(annotation.target().asClass().name());
        }
        if (userDefinedServices.isEmpty()) {
            return null;
        }
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                ClassInfo clazz = context.getTarget().asClass();
                if (userDefinedServices.contains(clazz.name()) && !customScopes.isScopeDeclaredOn(clazz)) {
                    ((Transformation)context.transform().add(BuiltinScope.SINGLETON.getName(), new AnnotationValue[0])).done();
                }
            }
        });
    }

    @BuildStep
    void validateBindableServices(ValidationPhaseBuildItem validationPhase, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors) {
        Type mutinyBeanType = Type.create((DotName)GrpcDotNames.MUTINY_BEAN, (Type.Kind)Type.Kind.CLASS);
        final Type mutinyServiceType = Type.create((DotName)GrpcDotNames.MUTINY_SERVICE, (Type.Kind)Type.Kind.CLASS);
        final Type bindableServiceType = Type.create((DotName)GrpcDotNames.BINDABLE_SERVICE, (Type.Kind)Type.Kind.CLASS);
        Predicate<Set<Type>> predicate = new Predicate<Set<Type>>(){

            @Override
            public boolean test(Set<Type> types) {
                return types.contains(bindableServiceType) || types.contains(mutinyServiceType);
            }
        };
        for (BeanInfo bean : validationPhase.getContext().beans().classBeans().matchBeanTypes((Predicate)predicate)) {
            this.validateBindableService(bean, mutinyBeanType, errors);
        }
        for (BeanInfo bean : validationPhase.getContext().removedBeans().classBeans().matchBeanTypes((Predicate)predicate)) {
            this.validateBindableService(bean, mutinyBeanType, errors);
        }
    }

    private void validateBindableService(BeanInfo bean, Type generatedBeanType, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors) {
        if (!bean.getTypes().contains(generatedBeanType)) {
            if (bean.getQualifiers().stream().map(AnnotationInstance::name).noneMatch(arg_0 -> ((DotName)GrpcDotNames.GRPC_SERVICE).equals(arg_0))) {
                errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException("A gRPC service bean must be annotated with @io.quarkus.grpc.GrpcService: " + bean)}));
            }
        }
        if (!bean.getScope().getDotName().equals((Object)BuiltinScope.SINGLETON.getName())) {
            errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException("A gRPC service bean must have the javax.inject.Singleton scope: " + bean)}));
        }
    }

    @BuildStep(onlyIf={IsNormal.class})
    KubernetesPortBuildItem registerGrpcServiceInKubernetes(List<BindableServiceBuildItem> bindables) {
        if (!bindables.isEmpty()) {
            int port = ConfigProvider.getConfig().getOptionalValue("quarkus.grpc.server.port", Integer.class).orElse(9000);
            return new KubernetesPortBuildItem(port, Feature.GRPC_SERVER);
        }
        return null;
    }

    @BuildStep
    void registerBeans(BuildProducer<AdditionalBeanBuildItem> beans, Capabilities capabilities, List<BindableServiceBuildItem> bindables, BuildProducer<FeatureBuildItem> features) {
        beans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{GrpcService.class}));
        if (!bindables.isEmpty() || LaunchMode.current() == LaunchMode.DEVELOPMENT) {
            beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(GrpcContainer.class));
            beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(GrpcRequestContextGrpcInterceptor.class));
            features.produce((BuildItem)new FeatureBuildItem(Feature.GRPC_SERVER));
            if (capabilities.isPresent("io.quarkus.security")) {
                beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(GrpcSecurityInterceptor.class));
                beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(DefaultAuthExceptionHandlerProvider.class));
            }
        } else {
            log.debug((Object)"Unable to find beans exposing the `BindableService` interface - not starting the gRPC server");
        }
    }

    @BuildStep
    void registerAdditionalInterceptors(BuildProducer<AdditionalGlobalInterceptorBuildItem> additionalInterceptors, Capabilities capabilities) {
        additionalInterceptors.produce((BuildItem)new AdditionalGlobalInterceptorBuildItem(GrpcRequestContextGrpcInterceptor.class.getName()));
        if (capabilities.isPresent("io.quarkus.security")) {
            additionalInterceptors.produce((BuildItem)new AdditionalGlobalInterceptorBuildItem(GrpcSecurityInterceptor.class.getName()));
        }
    }

    @BuildStep
    void gatherGrpcInterceptors(CombinedIndexBuildItem indexBuildItem, List<AdditionalGlobalInterceptorBuildItem> additionalGlobalInterceptors, List<DelegatingGrpcBeanBuildItem> delegatingGrpcBeans, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        String targetClass;
        HashMap<String, String> delegateMap = new HashMap<String, String>();
        for (DelegatingGrpcBeanBuildItem delegatingGrpcBean : delegatingGrpcBeans) {
            delegateMap.put(delegatingGrpcBean.userDefinedBean.name().toString(), delegatingGrpcBean.generatedBean.name().toString());
        }
        IndexView index = indexBuildItem.getIndex();
        GrpcInterceptors interceptors = this.gatherInterceptors(index);
        HashSet<String> superfluousInterceptors = new HashSet<String>(interceptors.nonGlobalInterceptors);
        HashMap<String, List> annotationsByClassName = new HashMap<String, List>();
        for (AnnotationInstance annotation : index.getAnnotations(GrpcDotNames.REGISTER_INTERCEPTOR)) {
            targetClass = annotation.target().asClass().name().toString();
            annotationsByClassName.computeIfAbsent(targetClass, key -> new ArrayList()).add(annotation);
        }
        for (AnnotationInstance annotation : index.getAnnotations(GrpcDotNames.REGISTER_INTERCEPTORS)) {
            targetClass = annotation.target().asClass().name().toString();
            annotationsByClassName.computeIfAbsent(targetClass, key -> new ArrayList()).addAll(Arrays.asList(annotation.value().asNestedArray()));
        }
        String perServiceInterceptorsImpl = InterceptorStorage.class.getName() + "Impl";
        try (ClassCreator classCreator = ClassCreator.builder().className(perServiceInterceptorsImpl).classOutput((ClassOutput)new GeneratedBeanGizmoAdaptor(generatedBeans)).superClass(InterceptorStorage.class).build();){
            classCreator.addAnnotation(Singleton.class.getName());
            MethodCreator constructor = classCreator.getMethodCreator(MethodDescriptor.ofConstructor((String)perServiceInterceptorsImpl, (String[])new String[0]));
            constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor(InterceptorStorage.class, (Class[])new Class[0]), constructor.getThis(), new ResultHandle[0]);
            for (Map.Entry annotationsForClass : annotationsByClassName.entrySet()) {
                for (AnnotationInstance value : (List)annotationsForClass.getValue()) {
                    String className = (String)annotationsForClass.getKey();
                    className = delegateMap.getOrDefault(className, className);
                    String interceptorClassName = value.value().asString();
                    superfluousInterceptors.remove(interceptorClassName);
                    constructor.invokeVirtualMethod(MethodDescriptor.ofMethod(InterceptorStorage.class, (String)"addInterceptor", Void.TYPE, (Class[])new Class[]{String.class, Class.class}), constructor.getThis(), new ResultHandle[]{constructor.load(className), constructor.loadClass(interceptorClassName)});
                }
            }
            for (String globalInterceptor : interceptors.globalInterceptors) {
                constructor.invokeVirtualMethod(MethodDescriptor.ofMethod(InterceptorStorage.class, (String)"addGlobalInterceptor", Void.TYPE, (Class[])new Class[]{Class.class}), constructor.getThis(), new ResultHandle[]{constructor.loadClass(globalInterceptor)});
            }
            for (AdditionalGlobalInterceptorBuildItem globalInterceptorBuildItem : additionalGlobalInterceptors) {
                constructor.invokeVirtualMethod(MethodDescriptor.ofMethod(InterceptorStorage.class, (String)"addGlobalInterceptor", Void.TYPE, (Class[])new Class[]{Class.class}), constructor.getThis(), new ResultHandle[]{constructor.loadClass(globalInterceptorBuildItem.interceptorClass())});
            }
            constructor.returnValue(null);
        }
        if (!superfluousInterceptors.isEmpty()) {
            log.warnf("At least one unused gRPC interceptor found: %s. If there are meant to be used globally, annotate them with @GlobalInterceptor.", (Object)String.join((CharSequence)", ", superfluousInterceptors));
        }
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassNames((String[])new String[]{perServiceInterceptorsImpl}));
    }

    private GrpcInterceptors gatherInterceptors(IndexView index) {
        HashSet<String> globalInterceptors = new HashSet<String>();
        HashSet<String> nonGlobalInterceptors = new HashSet<String>();
        Collection interceptorImplClasses = index.getAllKnownImplementors(GrpcDotNames.SERVER_INTERCEPTOR);
        for (ClassInfo interceptorImplClass : interceptorImplClasses) {
            if (Modifier.isAbstract(interceptorImplClass.flags()) || Modifier.isInterface(interceptorImplClass.flags())) continue;
            if (interceptorImplClass.classAnnotation(GrpcDotNames.GLOBAL_INTERCEPTOR) == null) {
                nonGlobalInterceptors.add(interceptorImplClass.name().toString());
                continue;
            }
            globalInterceptors.add(interceptorImplClass.name().toString());
        }
        return new GrpcInterceptors(globalInterceptors, nonGlobalInterceptors);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Consume(value=SyntheticBeansRuntimeInitBuildItem.class)
    ServiceStartBuildItem initializeServer(GrpcServerRecorder recorder, GrpcConfiguration config, GrpcBuildTimeConfig buildTimeConfig, ShutdownContextBuildItem shutdown, List<BindableServiceBuildItem> bindables, LaunchModeBuildItem launchModeBuildItem, VertxBuildItem vertx) {
        HashMap<String, List<String>> blocking = new HashMap<String, List<String>>();
        for (BindableServiceBuildItem bindable : bindables) {
            if (!bindable.hasBlockingMethods()) continue;
            blocking.put(bindable.serviceClass.toString(), bindable.blockingMethods);
        }
        if (!bindables.isEmpty() || LaunchMode.current() == LaunchMode.DEVELOPMENT && buildTimeConfig.devMode.forceServerStart) {
            recorder.initializeGrpcServer(vertx.getVertx(), config, (ShutdownContext)shutdown, blocking, launchModeBuildItem.getLaunchMode());
            return new ServiceStartBuildItem(Feature.GRPC_SERVER);
        }
        return null;
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void definializeGrpcFieldsForDevMode(BuildProducer<BytecodeTransformerBuildItem> transformers) {
        transformers.produce((BuildItem)new BytecodeTransformerBuildItem("io.grpc.internal.InternalHandlerRegistry", (BiFunction)new FieldDefinalizingVisitor("services", "methods")));
        transformers.produce((BuildItem)new BytecodeTransformerBuildItem(ServerImpl.class.getName(), (BiFunction)new FieldDefinalizingVisitor("interceptors")));
    }

    @BuildStep
    void addHealthChecks(GrpcServerBuildTimeConfig config, List<BindableServiceBuildItem> bindables, BuildProducer<HealthBuildItem> healthBuildItems, BuildProducer<AdditionalBeanBuildItem> beans) {
        boolean healthEnabled = false;
        if (!bindables.isEmpty()) {
            healthEnabled = config.mpHealthEnabled;
            if (config.grpcHealthEnabled) {
                beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(GrpcHealthEndpoint.class));
                healthEnabled = true;
            }
            healthBuildItems.produce((BuildItem)new HealthBuildItem("io.quarkus.grpc.runtime.health.GrpcHealthCheck", config.mpHealthEnabled));
        }
        if (healthEnabled || LaunchMode.current() == LaunchMode.DEVELOPMENT) {
            beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(GrpcHealthStorage.class));
        }
    }

    @BuildStep
    void registerSslResources(BuildProducer<NativeImageResourceBuildItem> resourceBuildItem) {
        Config config = ConfigProvider.getConfig();
        for (String sslProperty : Arrays.asList(CERTIFICATE, KEY, KEY_STORE, TRUST_STORE)) {
            config.getOptionalValue(sslProperty, String.class).ifPresent(value -> ResourceRegistrationUtils.registerResourceForProperty(resourceBuildItem, value));
        }
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem extensionSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(Feature.GRPC_SERVER);
    }

    @BuildStep
    void configureMetrics(GrpcBuildTimeConfig configuration, Optional<MetricsCapabilityBuildItem> metricsCapability, BuildProducer<AdditionalBeanBuildItem> beans, BuildProducer<AdditionalGlobalInterceptorBuildItem> additionalInterceptors) {
        if (configuration.metricsEnabled && metricsCapability.isPresent()) {
            if (metricsCapability.get().metricsSupported("micrometer")) {
                beans.produce((BuildItem)new AdditionalBeanBuildItem(new String[]{METRICS_SERVER_INTERCEPTOR, "io.quarkus.grpc.runtime.metrics.GrpcMetricsClientInterceptor"}));
                additionalInterceptors.produce((BuildItem)new AdditionalGlobalInterceptorBuildItem(METRICS_SERVER_INTERCEPTOR));
            } else {
                log.warn((Object)"Only Micrometer-based metrics system is supported by quarkus-grpc");
            }
        }
    }

    @BuildStep
    BeanArchivePredicateBuildItem additionalBeanArchives() {
        return new BeanArchivePredicateBuildItem((Predicate)new Predicate<ApplicationArchive>(){

            @Override
            public boolean test(ApplicationArchive archive) {
                return !archive.getIndex().getKnownDirectImplementors(GrpcDotNames.MUTINY_BEAN).isEmpty();
            }
        });
    }

    private static class GrpcInterceptors {
        final Set<String> globalInterceptors;
        final Set<String> nonGlobalInterceptors;

        GrpcInterceptors(Set<String> globalInterceptors, Set<String> nonGlobalInterceptors) {
            this.globalInterceptors = globalInterceptors;
            this.nonGlobalInterceptors = nonGlobalInterceptors;
        }
    }
}

