/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.execannotations.ExecutionModelAnnotationsAllowedBuildItem;
import io.quarkus.grpc.deployment.GrpcDotNames;
import java.util.function.Predicate;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;

public class GrpcMethodsProcessor {
    @BuildStep
    ExecutionModelAnnotationsAllowedBuildItem grpcMethods(CombinedIndexBuildItem combinedIndex) {
        final IndexView index = combinedIndex.getIndex();
        return new ExecutionModelAnnotationsAllowedBuildItem((Predicate)new Predicate<MethodInfo>(){

            @Override
            public boolean test(MethodInfo method) {
                if (method.declaringClass().hasDeclaredAnnotation(GrpcDotNames.GRPC_SERVICE)) {
                    return true;
                }
                for (ClassInfo subclass : index.getAllKnownSubclasses(method.declaringClass().name())) {
                    if (!subclass.hasDeclaredAnnotation(GrpcDotNames.GRPC_SERVICE)) continue;
                    return true;
                }
                return false;
            }
        });
    }
}

