/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.inprocess;

import io.grpc.ManagedChannelBuilder;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import io.netty.channel.EventLoopGroup;
import io.quarkus.grpc.runtime.config.Enabled;
import io.quarkus.grpc.runtime.config.GrpcClientConfiguration;
import io.quarkus.grpc.runtime.config.GrpcServerConfiguration;
import io.quarkus.grpc.spi.GrpcBuilderProvider;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.ShutdownContext;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class InProcessGrpcServerBuilderProvider
implements GrpcBuilderProvider<InProcessServerBuilder> {
    public boolean providesServer(GrpcServerConfiguration configuration) {
        return Enabled.isEnabled((Enabled)configuration.inProcess());
    }

    public ServerBuilder<InProcessServerBuilder> createServerBuilder(Vertx vertx, GrpcServerConfiguration configuration, LaunchMode launchMode) {
        InProcessServerBuilder builder = InProcessServerBuilder.forName((String)configuration.inProcess().name());
        VertxInternal vxi = (VertxInternal)vertx;
        EventLoopGroup delegate = vertx.nettyEventLoopGroup();
        ContextInternal context = vxi.createEventLoopContext();
        Executor executor = arg_0 -> InProcessGrpcServerBuilderProvider.lambda$createServerBuilder$1((Executor)delegate, context, arg_0);
        builder.executor(executor);
        return builder;
    }

    public void startServer(Server server) throws Exception {
        server.start();
    }

    public void postStartup(Server server, ShutdownContext shutdown) {
        shutdown.addShutdownTask(() -> ((Server)server).shutdownNow());
    }

    public void devModeReload(List<ServerServiceDefinition> servicesWithInterceptors, Map<String, ServerMethodDefinition<?, ?>> methods, List<ServerInterceptor> globalInterceptors, ShutdownContext shutdown) {
    }

    public boolean serverAlreadyExists() {
        return false;
    }

    public String serverInfo(String host, int port, GrpcServerConfiguration configuration) {
        return "InProcess gRPC server [" + configuration.inProcess().name() + "]";
    }

    public boolean providesChannel(GrpcClientConfiguration configuration) {
        return Enabled.isEnabled((Enabled)configuration.inProcess());
    }

    public String resolver() {
        return "in-process";
    }

    public String adjustHost(String host) {
        return host;
    }

    public ManagedChannelBuilder<?> createChannelBuilder(GrpcClientConfiguration configuration, String target) {
        return InProcessChannelBuilder.forName((String)configuration.inProcess().name()).directExecutor();
    }

    public String channelInfo(GrpcClientConfiguration configuration) {
        return "InProcess [" + configuration.inProcess().name() + "]";
    }

    private static /* synthetic */ void lambda$createServerBuilder$1(Executor delegate, ContextInternal context, Runnable command) {
        delegate.execute(() -> context.dispatch(command));
    }
}

