/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.protoc.plugin;

import com.google.common.base.Strings;
import com.google.common.html.HtmlEscapers;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.compiler.PluginProtos;
import com.salesforce.jprotoc.Generator;
import com.salesforce.jprotoc.GeneratorException;
import com.salesforce.jprotoc.ProtoTypeMap;
import com.salesforce.jprotoc.ProtocPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class MutinyGrpcGenerator
extends Generator {
    private static final int SERVICE_NUMBER_OF_PATHS = 2;
    private static final int METHOD_NUMBER_OF_PATHS = 4;
    private static final String CLASS_PREFIX = "Mutiny";

    private String getServiceJavaDocPrefix() {
        return "    ";
    }

    private String getMethodJavaDocPrefix() {
        return "        ";
    }

    @Override
    public List<PluginProtos.CodeGeneratorResponse.File> generateFiles(PluginProtos.CodeGeneratorRequest request) throws GeneratorException {
        ProtoTypeMap typeMap = ProtoTypeMap.of(request.getProtoFileList());
        List<DescriptorProtos.FileDescriptorProto> protosToGenerate = request.getProtoFileList().stream().filter(protoFile -> request.getFileToGenerateList().contains(protoFile.getName())).collect(Collectors.toList());
        List<ServiceContext> services = this.findServices(protosToGenerate, typeMap);
        return this.generateFiles(services);
    }

    private List<ServiceContext> findServices(List<DescriptorProtos.FileDescriptorProto> protos, ProtoTypeMap typeMap) {
        ArrayList<ServiceContext> contexts = new ArrayList<ServiceContext>();
        protos.forEach(fileProto -> {
            for (int serviceNumber = 0; serviceNumber < fileProto.getServiceCount(); ++serviceNumber) {
                ServiceContext serviceContext = this.buildServiceContext(fileProto.getService(serviceNumber), typeMap, fileProto.getSourceCodeInfo().getLocationList(), serviceNumber);
                serviceContext.protoName = fileProto.getName();
                serviceContext.packageName = this.extractPackageName((DescriptorProtos.FileDescriptorProto)fileProto);
                contexts.add(serviceContext);
            }
        });
        return contexts;
    }

    private String extractPackageName(DescriptorProtos.FileDescriptorProto proto) {
        String javaPackage;
        DescriptorProtos.FileOptions options = proto.getOptions();
        if (options != null && !Strings.isNullOrEmpty(javaPackage = options.getJavaPackage())) {
            return javaPackage;
        }
        return Strings.nullToEmpty(proto.getPackage());
    }

    private ServiceContext buildServiceContext(DescriptorProtos.ServiceDescriptorProto serviceProto, ProtoTypeMap typeMap, List<DescriptorProtos.SourceCodeInfo.Location> locations, int serviceNumber) {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.classPrefix = CLASS_PREFIX;
        serviceContext.fileName = CLASS_PREFIX + serviceProto.getName() + "Grpc.java";
        serviceContext.className = CLASS_PREFIX + serviceProto.getName() + "Grpc";
        serviceContext.serviceName = serviceProto.getName();
        serviceContext.deprecated = serviceProto.getOptions() != null && serviceProto.getOptions().getDeprecated();
        List allLocationsForService = locations.stream().filter(location -> location.getPathCount() >= 2 && location.getPath(0) == 6 && location.getPath(1) == serviceNumber).collect(Collectors.toList());
        DescriptorProtos.SourceCodeInfo.Location serviceLocation = allLocationsForService.stream().filter(location -> location.getPathCount() == 2).findFirst().orElseGet(DescriptorProtos.SourceCodeInfo.Location::getDefaultInstance);
        serviceContext.javaDoc = this.getJavaDoc(this.getComments(serviceLocation), this.getServiceJavaDocPrefix());
        for (int methodNumber = 0; methodNumber < serviceProto.getMethodCount(); ++methodNumber) {
            MethodContext methodContext = this.buildMethodContext(serviceProto.getMethod(methodNumber), typeMap, locations, methodNumber);
            serviceContext.methods.add(methodContext);
        }
        return serviceContext;
    }

    private MethodContext buildMethodContext(DescriptorProtos.MethodDescriptorProto methodProto, ProtoTypeMap typeMap, List<DescriptorProtos.SourceCodeInfo.Location> locations, int methodNumber) {
        MethodContext methodContext = new MethodContext();
        methodContext.methodName = this.lowerCaseFirst(methodProto.getName());
        methodContext.inputType = typeMap.toJavaTypeName(methodProto.getInputType());
        methodContext.outputType = typeMap.toJavaTypeName(methodProto.getOutputType());
        methodContext.deprecated = methodProto.getOptions() != null && methodProto.getOptions().getDeprecated();
        methodContext.isManyInput = methodProto.getClientStreaming();
        methodContext.isManyOutput = methodProto.getServerStreaming();
        methodContext.methodNumber = methodNumber;
        DescriptorProtos.SourceCodeInfo.Location methodLocation = locations.stream().filter(location -> location.getPathCount() == 4 && location.getPath(3) == methodNumber).findFirst().orElseGet(DescriptorProtos.SourceCodeInfo.Location::getDefaultInstance);
        methodContext.javaDoc = this.getJavaDoc(this.getComments(methodLocation), this.getMethodJavaDocPrefix());
        if (!methodProto.getClientStreaming() && !methodProto.getServerStreaming()) {
            methodContext.mutinyCallsMethodName = "oneToOne";
            methodContext.grpcCallsMethodName = "asyncUnaryCall";
        }
        if (!methodProto.getClientStreaming() && methodProto.getServerStreaming()) {
            methodContext.mutinyCallsMethodName = "oneToMany";
            methodContext.grpcCallsMethodName = "asyncServerStreamingCall";
        }
        if (methodProto.getClientStreaming() && !methodProto.getServerStreaming()) {
            methodContext.mutinyCallsMethodName = "manyToOne";
            methodContext.grpcCallsMethodName = "asyncClientStreamingCall";
        }
        if (methodProto.getClientStreaming() && methodProto.getServerStreaming()) {
            methodContext.mutinyCallsMethodName = "manyToMany";
            methodContext.grpcCallsMethodName = "asyncBidiStreamingCall";
        }
        return methodContext;
    }

    private String lowerCaseFirst(String s) {
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    private List<PluginProtos.CodeGeneratorResponse.File> generateFiles(List<ServiceContext> services) {
        return services.stream().map(this::buildFile).collect(Collectors.toList());
    }

    private PluginProtos.CodeGeneratorResponse.File buildFile(ServiceContext context) {
        String content = this.applyTemplate("MutinyStub.mustache", context);
        return PluginProtos.CodeGeneratorResponse.File.newBuilder().setName(this.absoluteFileName(context)).setContent(content).build();
    }

    private String absoluteFileName(ServiceContext ctx) {
        String dir = ctx.packageName.replace('.', '/');
        if (Strings.isNullOrEmpty(dir)) {
            return ctx.fileName;
        }
        return dir + "/" + ctx.fileName;
    }

    private String getComments(DescriptorProtos.SourceCodeInfo.Location location) {
        return location.getLeadingComments().isEmpty() ? location.getTrailingComments() : location.getLeadingComments();
    }

    private String getJavaDoc(String comments, String prefix) {
        if (!comments.isEmpty()) {
            StringBuilder builder = new StringBuilder("/**\n").append(prefix).append(" * <pre>\n");
            Arrays.stream(HtmlEscapers.htmlEscaper().escape(comments).split("\n")).map(line -> line.replace("*/", "&#42;&#47;").replace("*", "&#42;")).forEach(line -> builder.append(prefix).append(" * ").append((String)line).append("\n"));
            builder.append(prefix).append(" * </pre>\n").append(prefix).append(" */");
            return builder.toString();
        }
        return null;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            ProtocPlugin.generate(new MutinyGrpcGenerator());
        } else {
            ProtocPlugin.debug(new MutinyGrpcGenerator(), args[0]);
        }
    }

    private static class MethodContext {
        public String methodName;
        public String inputType;
        public String outputType;
        public boolean deprecated;
        public boolean isManyInput;
        public boolean isManyOutput;
        public String mutinyCallsMethodName;
        public String grpcCallsMethodName;
        public int methodNumber;
        public String javaDoc;

        private MethodContext() {
        }

        public String methodNameUpperUnderscore() {
            StringBuilder s = new StringBuilder();
            for (int i = 0; i < this.methodName.length(); ++i) {
                char c = this.methodName.charAt(i);
                s.append(Character.toUpperCase(c));
                if (i >= this.methodName.length() - 1 || !Character.isLowerCase(c) || !Character.isUpperCase(this.methodName.charAt(i + 1))) continue;
                s.append('_');
            }
            return s.toString();
        }

        public String methodNamePascalCase() {
            String mn = this.methodName.replace("_", "");
            return String.valueOf(Character.toUpperCase(mn.charAt(0))) + mn.substring(1);
        }

        public String methodNameCamelCase() {
            String mn = this.methodName.replace("_", "");
            return String.valueOf(Character.toLowerCase(mn.charAt(0))) + mn.substring(1);
        }

        public String methodHeader() {
            String mh = "";
            if (!Strings.isNullOrEmpty(this.javaDoc)) {
                mh = this.javaDoc;
            }
            if (this.deprecated) {
                mh = mh + "\n        @Deprecated";
            }
            return mh;
        }
    }

    private static class ServiceContext {
        public String fileName;
        public String protoName;
        public String packageName;
        public String className;
        public String classPrefix;
        public String serviceName;
        public boolean deprecated;
        public String javaDoc;
        public List<MethodContext> methods = new ArrayList<MethodContext>();

        private ServiceContext() {
        }

        public List<MethodContext> unaryUnaryMethods() {
            return this.methods.stream().filter(m -> !m.isManyInput && !m.isManyOutput).collect(Collectors.toList());
        }

        public List<MethodContext> unaryManyMethods() {
            return this.methods.stream().filter(m -> !m.isManyInput && m.isManyOutput).collect(Collectors.toList());
        }

        public List<MethodContext> manyUnaryMethods() {
            return this.methods.stream().filter(m -> m.isManyInput && !m.isManyOutput).collect(Collectors.toList());
        }

        public List<MethodContext> manyManyMethods() {
            return this.methods.stream().filter(m -> m.isManyInput && m.isManyOutput).collect(Collectors.toList());
        }
    }
}

