/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.jprotoc;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.DescriptorProtos;
import java.util.Collection;
import javax.annotation.Nonnull;

public final class ProtoTypeMap {
    private static final Joiner DOT_JOINER = Joiner.on('.').skipNulls();
    private final ImmutableMap<String, String> types;

    private ProtoTypeMap(@Nonnull ImmutableMap<String, String> types) {
        Preconditions.checkNotNull(types, "types");
        this.types = types;
    }

    public static ProtoTypeMap of(@Nonnull Collection<DescriptorProtos.FileDescriptorProto> fileDescriptorProtos) {
        Preconditions.checkNotNull(fileDescriptorProtos, "fileDescriptorProtos");
        Preconditions.checkArgument(!fileDescriptorProtos.isEmpty(), "fileDescriptorProtos.isEmpty()");
        ImmutableMap.Builder types = ImmutableMap.builder();
        for (DescriptorProtos.FileDescriptorProto fileDescriptor : fileDescriptorProtos) {
            DescriptorProtos.FileOptions fileOptions = fileDescriptor.getOptions();
            String protoPackage = fileDescriptor.hasPackage() ? "." + fileDescriptor.getPackage() : "";
            String javaPackage = Strings.emptyToNull(fileOptions.hasJavaPackage() ? fileOptions.getJavaPackage() : fileDescriptor.getPackage());
            String enclosingClassName = fileOptions.getJavaMultipleFiles() ? null : ProtoTypeMap.getJavaOuterClassname(fileDescriptor);
            fileDescriptor.getEnumTypeList().forEach(e -> types.put(protoPackage + "." + e.getName(), DOT_JOINER.join(javaPackage, enclosingClassName, e.getName())));
            fileDescriptor.getMessageTypeList().forEach(m3 -> ProtoTypeMap.recursivelyAddTypes(types, m3, protoPackage, enclosingClassName, javaPackage));
        }
        return new ProtoTypeMap(types.build());
    }

    private static void recursivelyAddTypes(ImmutableMap.Builder<String, String> types, DescriptorProtos.DescriptorProto m3, String protoPackage, String enclosingClassName, String javaPackage) {
        String protoTypeName = protoPackage + "." + m3.getName();
        types.put(protoTypeName, DOT_JOINER.join(javaPackage, enclosingClassName, m3.getName()));
        m3.getEnumTypeList().forEach(e -> types.put(protoPackage + "." + m3.getName() + "." + e.getName(), DOT_JOINER.join(javaPackage, enclosingClassName, m3.getName(), e.getName())));
        m3.getNestedTypeList().forEach(n -> ProtoTypeMap.recursivelyAddTypes(types, n, protoPackage + "." + m3.getName(), DOT_JOINER.join(enclosingClassName, m3.getName(), new Object[0]), javaPackage));
    }

    public String toJavaTypeName(@Nonnull String protoTypeName) {
        Preconditions.checkNotNull(protoTypeName, "protoTypeName");
        return this.types.get(protoTypeName);
    }

    public static String getJavaOuterClassname(DescriptorProtos.FileDescriptorProto fileDescriptor) {
        Preconditions.checkNotNull(fileDescriptor, "fileDescriptor");
        DescriptorProtos.FileOptions fileOptions = fileDescriptor.getOptions();
        if (fileOptions.hasJavaOuterClassname()) {
            return fileOptions.getJavaOuterClassname();
        }
        String filename = fileDescriptor.getName().substring(0, fileDescriptor.getName().length() - ".proto".length());
        if (filename.contains("/")) {
            filename = filename.substring(filename.lastIndexOf(47) + 1);
        }
        filename = ProtoTypeMap.makeInvalidCharactersUnderscores(filename);
        filename = ProtoTypeMap.convertToCamelCase(filename);
        filename = ProtoTypeMap.appendOuterClassSuffix(filename, fileDescriptor);
        return filename;
    }

    private static String appendOuterClassSuffix(String enclosingClassName, DescriptorProtos.FileDescriptorProto fd) {
        if (fd.getEnumTypeList().stream().anyMatch(enumProto -> enumProto.getName().equals(enclosingClassName)) || fd.getMessageTypeList().stream().anyMatch(messageProto -> messageProto.getName().equals(enclosingClassName)) || fd.getServiceList().stream().anyMatch(serviceProto -> serviceProto.getName().equals(enclosingClassName))) {
            return enclosingClassName + "OuterClass";
        }
        return enclosingClassName;
    }

    private static String makeInvalidCharactersUnderscores(String filename) {
        char[] filechars = filename.toCharArray();
        for (int i = 0; i < filechars.length; ++i) {
            char c = filechars[i];
            if (CharMatcher.inRange('0', '9').or(CharMatcher.inRange('A', 'Z')).or(CharMatcher.inRange('a', 'z')).matches(c)) continue;
            filechars[i] = 95;
        }
        return new String(filechars);
    }

    private static String convertToCamelCase(String name) {
        StringBuilder sb = new StringBuilder();
        sb.append(Character.toUpperCase(name.charAt(0)));
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            char prev = name.charAt(i - 1);
            if (c == '_') continue;
            if (prev == '_' || CharMatcher.inRange('0', '9').matches(prev)) {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

