/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.reflection.service;

import com.google.protobuf.Descriptors;
import grpc.reflection.v1alpha.MutinyServerReflectionGrpc;
import grpc.reflection.v1alpha.Reflection;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.quarkus.grpc.reflection.service.GrpcServerIndex;
import io.smallrye.mutiny.Multi;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ReflectionServiceV1alpha
extends MutinyServerReflectionGrpc.ServerReflectionImplBase {
    private final GrpcServerIndex index;

    public ReflectionServiceV1alpha(List<ServerServiceDefinition> definitions) {
        this.index = new GrpcServerIndex(definitions);
    }

    public Multi<Reflection.ServerReflectionResponse> serverReflectionInfo(Multi<Reflection.ServerReflectionRequest> request) {
        return request.onItem().transform((Function)new Function<Reflection.ServerReflectionRequest, Reflection.ServerReflectionResponse>(){

            @Override
            public Reflection.ServerReflectionResponse apply(Reflection.ServerReflectionRequest req) {
                switch (req.getMessageRequestCase()) {
                    case LIST_SERVICES: {
                        return ReflectionServiceV1alpha.this.getServiceList(req);
                    }
                    case FILE_BY_FILENAME: {
                        return ReflectionServiceV1alpha.this.getFileByName(req);
                    }
                    case FILE_CONTAINING_SYMBOL: {
                        return ReflectionServiceV1alpha.this.getFileContainingSymbol(req);
                    }
                    case FILE_CONTAINING_EXTENSION: {
                        return ReflectionServiceV1alpha.this.getFileByExtension(req);
                    }
                    case ALL_EXTENSION_NUMBERS_OF_TYPE: {
                        return ReflectionServiceV1alpha.this.getAllExtensions(req);
                    }
                }
                return ReflectionServiceV1alpha.this.getErrorResponse(req, Status.Code.UNIMPLEMENTED, "not implemented " + req.getMessageRequestCase());
            }
        });
    }

    private Reflection.ServerReflectionResponse getServiceList(Reflection.ServerReflectionRequest request) {
        Reflection.ListServiceResponse response = this.index.getServiceNames().stream().map(new Function<String, Reflection.ServiceResponse>(){

            @Override
            public Reflection.ServiceResponse apply(String s) {
                return Reflection.ServiceResponse.newBuilder().setName(s).build();
            }
        }).collect(new Supplier<Reflection.ListServiceResponse.Builder>(){

            @Override
            public Reflection.ListServiceResponse.Builder get() {
                return Reflection.ListServiceResponse.newBuilder();
            }
        }, new BiConsumer<Reflection.ListServiceResponse.Builder, Reflection.ServiceResponse>(){

            @Override
            public void accept(Reflection.ListServiceResponse.Builder builder, Reflection.ServiceResponse value) {
                builder.addService(value);
            }
        }, new BiConsumer<Reflection.ListServiceResponse.Builder, Reflection.ListServiceResponse.Builder>(){

            @Override
            public void accept(Reflection.ListServiceResponse.Builder b1, Reflection.ListServiceResponse.Builder b2) {
                b1.addAllService((Iterable)b2.getServiceList());
            }
        }).build();
        return Reflection.ServerReflectionResponse.newBuilder().setValidHost(request.getHost()).setOriginalRequest(request).setListServicesResponse(response).build();
    }

    private Reflection.ServerReflectionResponse getFileByName(Reflection.ServerReflectionRequest request) {
        String name = request.getFileByFilename();
        Descriptors.FileDescriptor fd = this.index.getFileDescriptorByName(name);
        if (fd != null) {
            return this.getServerReflectionResponse(request, fd);
        }
        return this.getErrorResponse(request, Status.Code.NOT_FOUND, "File not found (" + name + ")");
    }

    private Reflection.ServerReflectionResponse getFileContainingSymbol(Reflection.ServerReflectionRequest request) {
        String symbol = request.getFileContainingSymbol();
        Descriptors.FileDescriptor fd = this.index.getFileDescriptorBySymbol(symbol);
        if (fd != null) {
            return this.getServerReflectionResponse(request, fd);
        }
        return this.getErrorResponse(request, Status.Code.NOT_FOUND, "Symbol not found (" + symbol + ")");
    }

    private Reflection.ServerReflectionResponse getFileByExtension(Reflection.ServerReflectionRequest request) {
        int extension;
        Reflection.ExtensionRequest extensionRequest = request.getFileContainingExtension();
        String type = extensionRequest.getContainingType();
        Descriptors.FileDescriptor fd = this.index.getFileDescriptorByExtensionAndNumber(type, extension = extensionRequest.getExtensionNumber());
        if (fd != null) {
            return this.getServerReflectionResponse(request, fd);
        }
        return this.getErrorResponse(request, Status.Code.NOT_FOUND, "Extension not found (" + type + ", " + extension + ")");
    }

    private Reflection.ServerReflectionResponse getAllExtensions(Reflection.ServerReflectionRequest request) {
        String type = request.getAllExtensionNumbersOfType();
        Set<Integer> extensions = this.index.getExtensionNumbersOfType(type);
        if (extensions != null) {
            Reflection.ExtensionNumberResponse.Builder builder = Reflection.ExtensionNumberResponse.newBuilder().setBaseTypeName(type).addAllExtensionNumber(extensions);
            return Reflection.ServerReflectionResponse.newBuilder().setValidHost(request.getHost()).setOriginalRequest(request).setAllExtensionNumbersResponse(builder).build();
        }
        return this.getErrorResponse(request, Status.Code.NOT_FOUND, "Type not found.");
    }

    private Reflection.ServerReflectionResponse getServerReflectionResponse(Reflection.ServerReflectionRequest request, Descriptors.FileDescriptor fd) {
        Reflection.FileDescriptorResponse.Builder fdRBuilder = Reflection.FileDescriptorResponse.newBuilder();
        HashSet<String> seenFiles = new HashSet<String>();
        ArrayDeque<Descriptors.FileDescriptor> frontier = new ArrayDeque<Descriptors.FileDescriptor>();
        seenFiles.add(fd.getName());
        frontier.add(fd);
        while (!frontier.isEmpty()) {
            Descriptors.FileDescriptor nextFd = (Descriptors.FileDescriptor)frontier.remove();
            fdRBuilder.addFileDescriptorProto(nextFd.toProto().toByteString());
            for (Descriptors.FileDescriptor dependencyFd : nextFd.getDependencies()) {
                if (seenFiles.contains(dependencyFd.getName())) continue;
                seenFiles.add(dependencyFd.getName());
                frontier.add(dependencyFd);
            }
        }
        return Reflection.ServerReflectionResponse.newBuilder().setValidHost(request.getHost()).setOriginalRequest(request).setFileDescriptorResponse(fdRBuilder).build();
    }

    private Reflection.ServerReflectionResponse getErrorResponse(Reflection.ServerReflectionRequest request, Status.Code code, String message) {
        return Reflection.ServerReflectionResponse.newBuilder().setValidHost(request.getHost()).setOriginalRequest(request).setErrorResponse(Reflection.ErrorResponse.newBuilder().setErrorCode(code.value()).setErrorMessage(message)).build();
    }
}

