package io.grpc.reflection.v1alpha;

import static io.grpc.reflection.v1alpha.ServerReflectionGrpc.getServiceDescriptor;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;

@javax.annotation.Generated(
value = "by Mutiny Grpc generator",
comments = "Source: reflection/v1alpha/reflection.proto")
public final class MutinyServerReflectionGrpc implements io.quarkus.grpc.MutinyGrpc {
    private MutinyServerReflectionGrpc() {}

    public static MutinyServerReflectionStub newMutinyStub(io.grpc.Channel channel) {
        return new MutinyServerReflectionStub(channel);
    }

    
    public static final class MutinyServerReflectionStub extends io.grpc.stub.AbstractStub<MutinyServerReflectionStub> implements io.quarkus.grpc.MutinyStub {
        private ServerReflectionGrpc.ServerReflectionStub delegateStub;

        private MutinyServerReflectionStub(io.grpc.Channel channel) {
            super(channel);
            delegateStub = ServerReflectionGrpc.newStub(channel);
        }

        private MutinyServerReflectionStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            super(channel, callOptions);
            delegateStub = ServerReflectionGrpc.newStub(channel).build(channel, callOptions);
        }

        @Override
        protected MutinyServerReflectionStub build(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            return new MutinyServerReflectionStub(channel, callOptions);
        }

        /**
         * <pre>
         *  The reflection service is structured as a bidirectional stream, ensuring
         *  all related requests go to a single server.
         * </pre>
         */
        public io.smallrye.mutiny.Multi<io.grpc.reflection.v1alpha.ServerReflectionResponse> serverReflectionInfo(io.smallrye.mutiny.Multi<io.grpc.reflection.v1alpha.ServerReflectionRequest> request) {
            return io.quarkus.grpc.stubs.ClientCalls.manyToMany(request, delegateStub::serverReflectionInfo);
        }
    }

    
    public static abstract class ServerReflectionImplBase implements io.grpc.BindableService {

        private String compression;
        /**
        * Set whether the server will try to use a compressed response.
        *
        * @param compression the compression, e.g {@code gzip}
        */
        public ServerReflectionImplBase withCompression(String compression) {
        this.compression = compression;
        return this;
        }


        /**
         * <pre>
         *  The reflection service is structured as a bidirectional stream, ensuring
         *  all related requests go to a single server.
         * </pre>
         */
        public io.smallrye.mutiny.Multi<io.grpc.reflection.v1alpha.ServerReflectionResponse> serverReflectionInfo(io.smallrye.mutiny.Multi<io.grpc.reflection.v1alpha.ServerReflectionRequest> request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
            return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
                    .addMethod(
                            io.grpc.reflection.v1alpha.ServerReflectionGrpc.getServerReflectionInfoMethod(),
                            asyncBidiStreamingCall(
                                    new MethodHandlers<
                                            io.grpc.reflection.v1alpha.ServerReflectionRequest,
                                            io.grpc.reflection.v1alpha.ServerReflectionResponse>(
                                            this, METHODID_SERVER_REFLECTION_INFO, compression)))
                    .build();
        }
    }

    private static final int METHODID_SERVER_REFLECTION_INFO = 0;

    private static final class MethodHandlers<Req, Resp> implements
            io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final ServerReflectionImplBase serviceImpl;
        private final int methodId;
        private final String compression;

        MethodHandlers(ServerReflectionImplBase serviceImpl, int methodId, String compression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.compression = compression;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                default:
                    throw new java.lang.AssertionError();
            }
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public io.grpc.stub.StreamObserver<Req> invoke(io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                case METHODID_SERVER_REFLECTION_INFO:
                    return (io.grpc.stub.StreamObserver<Req>) io.quarkus.grpc.stubs.ServerCalls.manyToMany(
                            (io.grpc.stub.StreamObserver<io.grpc.reflection.v1alpha.ServerReflectionResponse>) responseObserver,
                            serviceImpl::serverReflectionInfo);
                default:
                    throw new java.lang.AssertionError();
            }
        }
    }

}