/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.xds;

import io.grpc.ChannelCredentials;
import io.grpc.Grpc;
import io.grpc.InsecureChannelCredentials;
import io.grpc.InsecureServerCredentials;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.xds.XdsChannelCredentials;
import io.grpc.xds.XdsServerBuilder;
import io.grpc.xds.XdsServerCredentials;
import io.netty.channel.EventLoopGroup;
import io.quarkus.grpc.runtime.config.ClientXds;
import io.quarkus.grpc.runtime.config.GrpcClientConfiguration;
import io.quarkus.grpc.runtime.config.GrpcServerConfiguration;
import io.quarkus.grpc.runtime.config.Xds;
import io.quarkus.grpc.runtime.devmode.DevModeInterceptor;
import io.quarkus.grpc.runtime.devmode.GrpcHotReplacementInterceptor;
import io.quarkus.grpc.spi.GrpcBuilderProvider;
import io.quarkus.grpc.xds.devmode.XdsServerReloader;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.ShutdownContext;
import io.vertx.core.Vertx;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.VertxInternal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class XdsGrpcServerBuilderProvider
implements GrpcBuilderProvider<XdsServerBuilder> {
    public boolean providesServer(GrpcServerConfiguration configuration) {
        Xds xds = configuration.xds;
        return xds != null && xds.enabled;
    }

    public ServerBuilder<XdsServerBuilder> createServerBuilder(Vertx vertx, GrpcServerConfiguration configuration, LaunchMode launchMode) {
        Xds xds = configuration.xds;
        int port = launchMode == LaunchMode.TEST ? configuration.testPort : configuration.port;
        ServerCredentials credentials = InsecureServerCredentials.create();
        if (xds.secure) {
            credentials = XdsServerCredentials.create((ServerCredentials)credentials);
        }
        XdsServerBuilder builder = XdsServerBuilder.forPort((int)port, (ServerCredentials)credentials);
        VertxInternal vxi = (VertxInternal)vertx;
        EventLoopGroup delegate = vertx.nettyEventLoopGroup();
        EventLoopContext context = vxi.createEventLoopContext();
        Executor executor = arg_0 -> XdsGrpcServerBuilderProvider.lambda$createServerBuilder$1((Executor)delegate, context, arg_0);
        builder.executor(executor);
        if (launchMode == LaunchMode.DEVELOPMENT) {
            builder.intercept((ServerInterceptor)new DevModeInterceptor(Thread.currentThread().getContextClassLoader()));
            builder.intercept((ServerInterceptor)new GrpcHotReplacementInterceptor());
        }
        return builder;
    }

    public void startServer(Server server) throws Exception {
        server.start();
    }

    public void postStartup(Server server, ShutdownContext shutdown) {
        XdsServerReloader.init(server);
        shutdown.addShutdownTask(XdsServerReloader::reset);
    }

    public void devModeReload(List<ServerServiceDefinition> servicesWithInterceptors, Map<String, ServerMethodDefinition<?, ?>> methods, List<ServerInterceptor> globalInterceptors, ShutdownContext shutdown) {
        XdsServerReloader.reinitialize(servicesWithInterceptors, methods, globalInterceptors);
        shutdown.addShutdownTask(XdsServerReloader::reset);
    }

    public boolean serverAlreadyExists() {
        return XdsServerReloader.getServer() != null;
    }

    public String serverInfo(String host, int port, GrpcServerConfiguration configuration) {
        return String.format("gRPC server on %s:%d [xDS enabled]", host, port);
    }

    public boolean providesChannel(GrpcClientConfiguration configuration) {
        ClientXds xds = configuration.xds;
        if (xds != null) {
            return xds.enabled || "xds".equalsIgnoreCase(configuration.nameResolver);
        }
        return false;
    }

    public String resolver() {
        return "xds";
    }

    public String adjustHost(String host) {
        return "/" + host;
    }

    public ManagedChannelBuilder<?> createChannelBuilder(GrpcClientConfiguration configuration, String target) {
        ClientXds xds = configuration.xds;
        ChannelCredentials credentials = InsecureChannelCredentials.create();
        if (xds.secure) {
            credentials = XdsChannelCredentials.create((ChannelCredentials)credentials);
        }
        target = xds.target.orElse(target);
        return Grpc.newChannelBuilder((String)target, (ChannelCredentials)credentials);
    }

    public String channelInfo(GrpcClientConfiguration configuration) {
        return "xDS";
    }

    private static /* synthetic */ void lambda$createServerBuilder$1(Executor delegate, EventLoopContext context, Runnable command) {
        delegate.execute(() -> context.dispatch(command));
    }
}

