/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.supports;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.Prioritized;

@ApplicationScoped
public class IOThreadClientInterceptor
implements ClientInterceptor,
Prioritized {
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        final Context context = Vertx.currentContext();
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){
                    private volatile CompletableFuture<Void> onMessageCompletion;

                    public void onMessage(RespT message) {
                        if (context != null) {
                            this.onMessageCompletion = new CompletableFuture();
                            context.runOnContext(unused -> {
                                try {
                                    super.onMessage(message);
                                    this.onMessageCompletion.complete(null);
                                }
                                catch (Throwable any) {
                                    this.onMessageCompletion.completeExceptionally(any);
                                }
                            });
                        } else {
                            super.onMessage(message);
                        }
                    }

                    public void onClose(Status status, Metadata trailers) {
                        if (this.onMessageCompletion != null && !Context.isOnEventLoopThread()) {
                            try {
                                this.onMessageCompletion.get(60L, TimeUnit.SECONDS);
                            }
                            catch (InterruptedException | ExecutionException e) {
                                throw new RuntimeException("`onMessage` failed or interrupted", e);
                            }
                            catch (TimeoutException e) {
                                throw new RuntimeException("`onMessage` did not complete in 60 seconds");
                            }
                            super.onClose(status, trailers);
                        } else {
                            super.onClose(status, trailers);
                        }
                    }
                }, headers);
            }
        };
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }
}

