/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime;

import grpc.health.v1.HealthOuterClass;
import io.grpc.BindableService;
import io.grpc.ServerInterceptor;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.quarkus.arc.Arc;
import io.quarkus.grpc.runtime.GrpcContainer;
import io.quarkus.grpc.runtime.GrpcSslUtils;
import io.quarkus.grpc.runtime.config.GrpcConfiguration;
import io.quarkus.grpc.runtime.config.GrpcServerConfiguration;
import io.quarkus.grpc.runtime.devmode.GrpcHotReplacementInterceptor;
import io.quarkus.grpc.runtime.devmode.GrpcServerReloader;
import io.quarkus.grpc.runtime.health.GrpcHealthStorage;
import io.quarkus.grpc.runtime.reflection.ReflectionService;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ProfileManager;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.grpc.VertxServer;
import io.vertx.grpc.VertxServerBuilder;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.enterprise.inject.Instance;
import org.jboss.logging.Logger;

@Recorder
public class GrpcServerRecorder {
    private static final Logger LOGGER = Logger.getLogger((String)GrpcServerRecorder.class.getName());
    private static final AtomicInteger grpcVerticleCount = new AtomicInteger(0);

    public void initializeGrpcServer(RuntimeValue<Vertx> vertxSupplier, GrpcConfiguration cfg, ShutdownContext shutdown) {
        boolean devMode;
        GrpcContainer grpcContainer = (GrpcContainer)Arc.container().instance(GrpcContainer.class, new Annotation[0]).get();
        if (grpcContainer == null) {
            throw new IllegalStateException("gRPC not initialized, GrpcContainer not found");
        }
        Vertx vertx = (Vertx)vertxSupplier.getValue();
        if (GrpcServerRecorder.hasNoServices(grpcContainer.getServices())) {
            throw new IllegalStateException("Unable to find beans exposing the `BindableService` interface - not starting the gRPC server");
        }
        GrpcServerConfiguration configuration = cfg.server;
        boolean bl = devMode = ProfileManager.getLaunchMode() == LaunchMode.DEVELOPMENT;
        if (devMode) {
            if (GrpcServerReloader.getServer() == null) {
                this.devModeStart(grpcContainer, vertx, configuration, shutdown);
            } else {
                GrpcServerRecorder.devModeReload(grpcContainer);
            }
        } else {
            this.prodStart(grpcContainer, vertx, configuration);
        }
    }

    private void prodStart(GrpcContainer grpcContainer, Vertx vertx, GrpcServerConfiguration configuration) {
        CompletableFuture startResult = new CompletableFuture();
        vertx.deployVerticle(() -> new GrpcServerVerticle(configuration, grpcContainer), new DeploymentOptions().setInstances(configuration.instances), result -> {
            if (result.failed()) {
                startResult.completeExceptionally(result.cause());
            } else {
                this.postStartup(grpcContainer, configuration);
                startResult.complete(null);
            }
        });
        try {
            startResult.get(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error((Object)"Unable to start the gRPC server, waiting for server start interrupted");
        }
        catch (TimeoutException e) {
            LOGGER.error((Object)"Unable to start the gRPC server, still not listening after 1 minute");
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Unable to start the gRPC server", e.getCause());
        }
    }

    private void postStartup(final GrpcContainer grpcContainer, GrpcServerConfiguration configuration) {
        grpcContainer.getHealthStorage().stream().forEach(new Consumer<GrpcHealthStorage>(){

            @Override
            public void accept(final GrpcHealthStorage storage) {
                storage.setStatus("", HealthOuterClass.HealthCheckResponse.ServingStatus.SERVING);
                grpcContainer.getServices().forEach((Consumer)new Consumer<BindableService>(){

                    @Override
                    public void accept(BindableService service) {
                        ServerServiceDefinition definition = service.bindService();
                        storage.setStatus(definition.getServiceDescriptor().getName(), HealthOuterClass.HealthCheckResponse.ServingStatus.SERVING);
                    }
                });
            }
        });
        LOGGER.infof("gRPC Server started on %s:%d [SSL enabled: %s]", (Object)configuration.host, (Object)configuration.port, (Object)(!configuration.plainText ? 1 : 0));
    }

    private void devModeStart(final GrpcContainer grpcContainer, Vertx vertx, final GrpcServerConfiguration configuration, ShutdownContext shutdown) {
        final CompletableFuture future = new CompletableFuture();
        VertxServer vertxServer = this.buildServer(vertx, configuration, grpcContainer, true).start((Handler)new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> ar) {
                if (ar.failed()) {
                    LOGGER.error((Object)"Unable to start the gRPC server", ar.cause());
                    future.completeExceptionally(ar.cause());
                } else {
                    GrpcServerRecorder.this.postStartup(grpcContainer, configuration);
                    future.complete(true);
                    grpcVerticleCount.incrementAndGet();
                }
            }
        });
        try {
            future.get(1L, TimeUnit.MINUTES);
        }
        catch (TimeoutException e) {
            LOGGER.error((Object)"Failed to start grpc server in time", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("grpc server start failed", e);
        }
        catch (InterruptedException e) {
            LOGGER.warn((Object)"Waiting for grpc server start interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        GrpcServerReloader.init(vertxServer);
        shutdown.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                GrpcServerReloader.reset();
            }
        });
    }

    private void applyTransportSecurityConfig(GrpcServerConfiguration configuration, VertxServerBuilder builder) {
        if (configuration.transportSecurity != null) {
            File cert = configuration.transportSecurity.certificate.map(new Function<String, File>(){

                @Override
                public File apply(String pathname) {
                    return new File(pathname);
                }
            }).orElse(null);
            File key = configuration.transportSecurity.key.map(new Function<String, File>(){

                @Override
                public File apply(String pathname) {
                    return new File(pathname);
                }
            }).orElse(null);
            if (cert != null || key != null) {
                builder.useTransportSecurity(cert, key);
            }
        }
    }

    private static boolean hasNoServices(Instance<BindableService> services) {
        return services.isUnsatisfied() || services.stream().count() == 1L && ((BindableService)services.get()).bindService().getServiceDescriptor().getName().equals("grpc.health.v1.Health");
    }

    private static List<ServerServiceDefinition> gatherServices(Instance<BindableService> services) {
        final ArrayList<ServerServiceDefinition> definitions = new ArrayList<ServerServiceDefinition>();
        services.forEach((Consumer)new Consumer<BindableService>(){

            @Override
            public void accept(BindableService bindable) {
                ServerServiceDefinition definition = bindable.bindService();
                LOGGER.debugf("Registered gRPC service '%s'", (Object)definition.getServiceDescriptor().getName());
                definitions.add(definition);
            }
        });
        return definitions;
    }

    private static void devModeReload(GrpcContainer grpcContainer) {
        List<ServerServiceDefinition> serviceDefinitions = GrpcServerRecorder.gatherServices(grpcContainer.getServices());
        HashMap methods = new HashMap();
        for (ServerServiceDefinition service : serviceDefinitions) {
            for (ServerMethodDefinition method : service.getMethods()) {
                methods.put(method.getMethodDescriptor().getFullMethodName(), method);
            }
        }
        ServerServiceDefinition reflectionService = new ReflectionService(serviceDefinitions).bindService();
        for (ServerMethodDefinition method : reflectionService.getMethods()) {
            methods.put(method.getMethodDescriptor().getFullMethodName(), method);
        }
        GrpcServerReloader.reinitialize(serviceDefinitions, methods, grpcContainer.getSortedInterceptors());
    }

    public static int getVerticleCount() {
        return grpcVerticleCount.get();
    }

    private VertxServer buildServer(Vertx vertx, final GrpcServerConfiguration configuration, GrpcContainer grpcContainer, boolean devMode) {
        Optional<Duration> handshakeTimeout;
        VertxServerBuilder builder = VertxServerBuilder.forAddress((Vertx)vertx, (String)configuration.host, (int)configuration.port);
        final AtomicBoolean usePlainText = new AtomicBoolean();
        builder.useSsl((Handler)new Handler<HttpServerOptions>(){

            public void handle(HttpServerOptions options) {
                try {
                    usePlainText.set(GrpcSslUtils.applySslOptions(configuration, options));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
        if (configuration.maxInboundMessageSize.isPresent()) {
            builder.maxInboundMessageSize(configuration.maxInboundMessageSize.getAsInt());
        }
        if ((handshakeTimeout = configuration.handshakeTimeout).isPresent()) {
            builder.handshakeTimeout(handshakeTimeout.get().toMillis(), TimeUnit.MILLISECONDS);
        }
        this.applyTransportSecurityConfig(configuration, builder);
        boolean reflectionServiceEnabled = configuration.enableReflectionService || ProfileManager.getLaunchMode() == LaunchMode.DEVELOPMENT;
        List<ServerServiceDefinition> definitions = GrpcServerRecorder.gatherServices(grpcContainer.getServices());
        for (ServerServiceDefinition definition : definitions) {
            builder.addService(definition);
        }
        if (reflectionServiceEnabled) {
            LOGGER.info((Object)"Registering gRPC reflection service");
            builder.addService((BindableService)new ReflectionService(definitions));
        }
        for (ServerInterceptor serverInterceptor : grpcContainer.getSortedInterceptors()) {
            builder.intercept(serverInterceptor);
        }
        if (devMode) {
            builder.commandDecorator(command -> vertx.executeBlocking((Handler)new Handler<Promise<Boolean>>(){

                public void handle(Promise<Boolean> event) {
                    event.complete((Object)GrpcHotReplacementInterceptor.fire());
                }
            }, false, result -> command.run()));
        }
        LOGGER.debugf("Starting gRPC Server on %s:%d  [SSL enabled: %s]...", (Object)configuration.host, (Object)configuration.port, (Object)(!usePlainText.get() ? 1 : 0));
        return builder.build();
    }

    private class GrpcServerVerticle
    extends AbstractVerticle {
        private final GrpcServerConfiguration configuration;
        private final GrpcContainer grpcContainer;
        private VertxServer grpcServer;

        GrpcServerVerticle(GrpcServerConfiguration configuration, GrpcContainer grpcContainer) {
            this.configuration = configuration;
            this.grpcContainer = grpcContainer;
        }

        public void start(final Promise<Void> startPromise) {
            if (this.grpcContainer.getServices().isUnsatisfied()) {
                LOGGER.warn((Object)"Unable to find bean exposing the `BindableService` interface - not starting the gRPC server");
                return;
            }
            this.grpcServer = GrpcServerRecorder.this.buildServer(this.getVertx(), this.configuration, this.grpcContainer, false).start((Handler)new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> ar) {
                    if (ar.failed()) {
                        LOGGER.error((Object)"Unable to start the gRPC server", ar.cause());
                        startPromise.fail(ar.cause());
                    } else {
                        startPromise.complete();
                        grpcVerticleCount.incrementAndGet();
                    }
                }
            });
        }

        public void stop(final Promise<Void> stopPromise) {
            this.grpcServer.shutdown((Handler)new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> ar) {
                    if (ar.failed()) {
                        LOGGER.errorf(ar.cause(), "Unable to stop the gRPC server gracefully", new Object[0]);
                    } else {
                        LOGGER.debug((Object)"gRPC Server stopped");
                        stopPromise.complete();
                        grpcVerticleCount.decrementAndGet();
                    }
                }
            });
        }
    }
}

