/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.supports;

import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.grpc.runtime.GrpcClientInterceptorContainer;
import io.quarkus.grpc.runtime.annotations.GrpcServiceLiteral;
import io.quarkus.grpc.runtime.config.GrpcClientConfiguration;
import io.quarkus.grpc.runtime.supports.GrpcClientConfigProvider;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;

public class Channels {
    private Channels() {
    }

    public static Channel createChannel(String name) throws SSLException {
        Optional<Duration> idleTimeout;
        Optional<Duration> keepAliveTimeout;
        Optional<Duration> keepAliveTime;
        Optional<String> overrideAuthority;
        Optional<String> userAgent;
        InstanceHandle instance = Arc.container().instance(GrpcClientConfigProvider.class, new Annotation[0]);
        if (!instance.isAvailable()) {
            throw new IllegalStateException("Unable to find the GrpcClientConfigProvider");
        }
        GrpcClientConfiguration config = ((GrpcClientConfigProvider)instance.get()).getConfiguration(name);
        String host = config.host;
        int port = config.port;
        boolean plainText = !config.ssl.trustStore.isPresent();
        Optional<Boolean> usePlainText = config.plainText;
        if (usePlainText.isPresent()) {
            plainText = usePlainText.get();
        }
        SslContext context = null;
        if (!plainText) {
            Path trustStorePath = config.ssl.trustStore.orElse(null);
            Path certificatePath = config.ssl.certificate.orElse(null);
            Path keyPath = config.ssl.key.orElse(null);
            SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
            if (trustStorePath != null) {
                sslContextBuilder.trustManager(trustStorePath.toFile());
            }
            if (certificatePath != null && keyPath != null) {
                sslContextBuilder.keyManager(certificatePath.toFile(), keyPath.toFile());
            }
            context = sslContextBuilder.build();
        }
        NettyChannelBuilder builder = ((NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)host, (int)port).flowControlWindow(config.flowControlWindow.orElse(0x100000)).keepAliveWithoutCalls(config.keepAliveWithoutCalls).maxHedgedAttempts(config.maxHedgedAttempts)).maxRetryAttempts(config.maxRetryAttempts)).maxInboundMetadataSize(config.maxInboundMessageSize.orElse(8192)).maxInboundMetadataSize(config.maxInboundMessageSize.orElse(0x400000)).negotiationType(NegotiationType.valueOf((String)config.negotiationType.toUpperCase()));
        if (config.retry) {
            builder.enableRetry();
        } else {
            builder.disableRetry();
        }
        if (config.maxTraceEvents.isPresent()) {
            builder.maxTraceEvents(config.maxTraceEvents.getAsInt());
        }
        if ((userAgent = config.userAgent).isPresent()) {
            builder.userAgent(userAgent.get());
        }
        if (config.retryBufferSize.isPresent()) {
            builder.retryBufferSize(config.retryBufferSize.getAsLong());
        }
        if (config.perRpcBufferLimit.isPresent()) {
            builder.perRpcBufferLimit(config.perRpcBufferLimit.getAsLong());
        }
        if ((overrideAuthority = config.overrideAuthority).isPresent()) {
            builder.overrideAuthority(overrideAuthority.get());
        }
        if ((keepAliveTime = config.keepAliveTime).isPresent()) {
            builder.keepAliveTime(keepAliveTime.get().toMillis(), TimeUnit.MILLISECONDS);
        }
        if ((keepAliveTimeout = config.keepAliveTimeout).isPresent()) {
            builder.keepAliveTimeout(keepAliveTimeout.get().toMillis(), TimeUnit.MILLISECONDS);
        }
        if ((idleTimeout = config.idleTimeout).isPresent()) {
            builder.keepAliveTimeout(idleTimeout.get().toMillis(), TimeUnit.MILLISECONDS);
        }
        if (plainText) {
            builder.usePlaintext();
        }
        if (context != null) {
            builder.sslContext(context);
        }
        InstanceHandle interceptors = Arc.container().instance(GrpcClientInterceptorContainer.class, new Annotation[0]);
        for (ClientInterceptor clientInterceptor : ((GrpcClientInterceptorContainer)interceptors.get()).getSortedInterceptors()) {
            builder.intercept(new ClientInterceptor[]{clientInterceptor});
        }
        return builder.build();
    }

    public static Channel retrieveChannel(String name) {
        InstanceHandle instance = Arc.container().instance(Channel.class, new Annotation[]{GrpcServiceLiteral.of(name)});
        if (!instance.isAvailable()) {
            throw new IllegalStateException("Unable to retrieve the gRPC Channel " + name);
        }
        return (Channel)instance.get();
    }
}

