/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.supports.blocking;

import io.grpc.Context;
import io.grpc.ServerCall;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.ManagedContext;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import java.util.function.Consumer;

class BlockingExecutionHandler<ReqT>
implements Handler<Promise<Object>> {
    private final ServerCall.Listener<ReqT> delegate;
    private final Context grpcContext;
    private final Consumer<ServerCall.Listener<ReqT>> consumer;
    private final InjectableContext.ContextState state;
    private final ManagedContext requestContext;

    public BlockingExecutionHandler(Consumer<ServerCall.Listener<ReqT>> consumer, Context grpcContext, ServerCall.Listener<ReqT> delegate, InjectableContext.ContextState state, ManagedContext requestContext) {
        this.consumer = consumer;
        this.grpcContext = grpcContext;
        this.delegate = delegate;
        this.state = state;
        this.requestContext = requestContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Promise<Object> event) {
        Context previous = Context.current();
        this.grpcContext.attach();
        try {
            this.requestContext.activate(this.state);
            try {
                this.consumer.accept(this.delegate);
            }
            catch (Throwable any) {
                try {
                    event.fail(any);
                    this.grpcContext.detach(previous);
                    return;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.requestContext.deactivate();
                }
            }
            this.requestContext.deactivate();
            event.complete();
        }
        finally {
            this.grpcContext.detach(previous);
        }
    }
}

