/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.health;

import grpc.health.v1.HealthOuterClass;
import io.quarkus.grpc.runtime.health.GrpcHealthStorage;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
public class GrpcHealthCheck
implements HealthCheck {
    @Inject
    GrpcHealthStorage healthService;

    public HealthCheckResponse call() {
        HealthOuterClass.HealthCheckResponse.ServingStatus servingStatus = this.healthService.getStatuses().get("");
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"gRPC Server health check").up();
        builder.name("gRPC Server");
        if (this.isUp(servingStatus)) {
            builder.up();
        } else {
            builder.down();
        }
        for (Map.Entry<String, HealthOuterClass.HealthCheckResponse.ServingStatus> statusEntry : this.healthService.getStatuses().entrySet()) {
            String serviceName = statusEntry.getKey();
            if (serviceName.equals("")) continue;
            builder.withData(serviceName, this.isUp(statusEntry.getValue()));
        }
        return builder.build();
    }

    private boolean isUp(HealthOuterClass.HealthCheckResponse.ServingStatus value) {
        return value == HealthOuterClass.HealthCheckResponse.ServingStatus.SERVING;
    }
}

