/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.stork;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.Context;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.StatusException;
import io.smallrye.stork.api.ServiceInstance;
import java.util.concurrent.atomic.AtomicReference;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.Prioritized;

@ApplicationScoped
public class StorkMeasuringGrpcInterceptor
implements ClientInterceptor,
Prioritized {
    public static final Context.Key<AtomicReference<ServiceInstance>> STORK_SERVICE_INSTANCE = Context.key((String)"stork.service-instance");
    public static final Context.Key<Boolean> STORK_MEASURE_TIME = Context.key((String)"stork.measure-time");

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new StorkMeasuringCall(next.newCall(method, callOptions), method.getType());
    }

    public int getPriority() {
        return 2147483547;
    }

    private static class StorkMeasuringCallListener<RespT>
    extends ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT> {
        final StorkMeasuringCall<?, ?> collector;

        public StorkMeasuringCallListener(ClientCall.Listener<RespT> responseListener, StorkMeasuringCall<?, ?> collector) {
            super(responseListener);
            this.collector = collector;
        }

        public void onMessage(RespT message) {
            this.collector.recordReply();
            super.onMessage(message);
        }

        public void onClose(Status status, Metadata trailers) {
            StatusException error = null;
            if (!status.isOk()) {
                error = status.asException(trailers);
            }
            this.collector.recordEnd((Throwable)error);
            super.onClose(status, trailers);
        }
    }

    private static class StorkMeasuringCall<ReqT, RespT>
    extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
        ServiceInstance serviceInstance;
        final boolean recordTime;

        protected StorkMeasuringCall(ClientCall<ReqT, RespT> delegate, MethodDescriptor.MethodType type) {
            super(delegate);
            this.recordTime = type == MethodDescriptor.MethodType.UNARY;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(ClientCall.Listener<RespT> responseListener, Metadata metadata) {
            Context context = Context.current().withValues(STORK_SERVICE_INSTANCE, new AtomicReference(), STORK_MEASURE_TIME, (Object)this.recordTime);
            Context oldContext = context.attach();
            try {
                super.start(new StorkMeasuringCallListener<RespT>(responseListener, this), metadata);
                this.serviceInstance = (ServiceInstance)((AtomicReference)STORK_SERVICE_INSTANCE.get()).get();
            }
            finally {
                context.detach(oldContext);
            }
        }

        void recordReply() {
            if (this.serviceInstance != null && this.recordTime) {
                this.serviceInstance.recordReply();
            }
        }

        void recordEnd(Throwable error) {
            if (this.serviceInstance != null) {
                this.serviceInstance.recordEnd(error);
            }
        }
    }
}

