/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.supports.context;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.quarkus.grpc.GlobalInterceptor;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.Prioritized;
import org.jboss.logging.Logger;

@ApplicationScoped
@GlobalInterceptor
public class GrpcDuplicatedContextGrpcInterceptor
implements ServerInterceptor,
Prioritized {
    private static final Logger log = Logger.getLogger((String)GrpcDuplicatedContextGrpcInterceptor.class.getName());

    private static boolean isRootContext(Context context) {
        return !VertxContext.isDuplicatedContext((Context)context);
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        Context capturedVertxContext = Vertx.currentContext();
        if (capturedVertxContext != null) {
            Context local = VertxContext.getOrCreateDuplicatedContext((Context)capturedVertxContext);
            VertxContextSafetyToggle.setContextSafe((Context)local, (boolean)true);
            return new ListenedOnDuplicatedContext(() -> next.startCall(call, headers), local);
        }
        log.warn((Object)"Unable to run on a duplicated context - interceptor not called on the Vert.x event loop");
        return next.startCall(call, headers);
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    static class ListenedOnDuplicatedContext<ReqT>
    extends ServerCall.Listener<ReqT> {
        private final Context context;
        private final Supplier<ServerCall.Listener<ReqT>> supplier;
        private ServerCall.Listener<ReqT> delegate;

        public ListenedOnDuplicatedContext(Supplier<ServerCall.Listener<ReqT>> supplier, Context context) {
            this.context = context;
            this.supplier = supplier;
        }

        private synchronized ServerCall.Listener<ReqT> getDelegate() {
            if (this.delegate == null) {
                this.delegate = this.supplier.get();
            }
            return this.delegate;
        }

        public void onMessage(ReqT message) {
            if (Vertx.currentContext() == this.context) {
                this.getDelegate().onMessage(message);
            } else {
                this.context.runOnContext(x -> this.getDelegate().onMessage(message));
            }
        }

        public void onReady() {
            if (Vertx.currentContext() == this.context) {
                this.getDelegate().onReady();
            } else {
                this.context.runOnContext(x -> this.getDelegate().onReady());
            }
        }

        public void onHalfClose() {
            if (Vertx.currentContext() == this.context) {
                this.getDelegate().onHalfClose();
            } else {
                this.context.runOnContext(x -> this.getDelegate().onHalfClose());
            }
        }

        public void onCancel() {
            if (Vertx.currentContext() == this.context) {
                this.getDelegate().onCancel();
            } else {
                this.context.runOnContext(x -> this.getDelegate().onCancel());
            }
        }

        public void onComplete() {
            if (Vertx.currentContext() == this.context) {
                this.getDelegate().onComplete();
            } else {
                this.context.runOnContext(x -> this.getDelegate().onComplete());
            }
        }
    }
}

