/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.supports.context;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.quarkus.grpc.GlobalInterceptor;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.Prioritized;
import org.jboss.logging.Logger;

@ApplicationScoped
@GlobalInterceptor
public class GrpcDuplicatedContextGrpcInterceptor
implements ServerInterceptor,
Prioritized {
    private static final Logger log = Logger.getLogger((String)GrpcDuplicatedContextGrpcInterceptor.class.getName());

    private static boolean isRootContext(Context context) {
        return !VertxContext.isDuplicatedContext((Context)context);
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        Context capturedVertxContext = Vertx.currentContext();
        if (capturedVertxContext != null) {
            Context local = VertxContext.getOrCreateDuplicatedContext((Context)capturedVertxContext);
            VertxContextSafetyToggle.setContextSafe((Context)local, (boolean)true);
            return new ListenedOnDuplicatedContext<ReqT, RespT>(call, () -> next.startCall(call, headers), local);
        }
        log.warn((Object)"Unable to run on a duplicated context - interceptor not called on the Vert.x event loop");
        return next.startCall(call, headers);
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    static class ListenedOnDuplicatedContext<ReqT, RespT>
    extends ServerCall.Listener<ReqT> {
        private final Context context;
        private final Supplier<ServerCall.Listener<ReqT>> supplier;
        private final ServerCall<ReqT, RespT> call;
        private ServerCall.Listener<ReqT> delegate;
        private final AtomicBoolean closed = new AtomicBoolean();

        public ListenedOnDuplicatedContext(ServerCall<ReqT, RespT> call, Supplier<ServerCall.Listener<ReqT>> supplier, Context context) {
            this.context = context;
            this.supplier = supplier;
            this.call = call;
        }

        private synchronized ServerCall.Listener<ReqT> getDelegate() {
            if (this.delegate == null) {
                try {
                    this.delegate = this.supplier.get();
                }
                catch (Throwable t) {
                    log.warn((Object)"Unable to retrieve gRPC Server call listener", t);
                    this.close(t);
                    return null;
                }
            }
            return this.delegate;
        }

        private void close(Throwable t) {
            if (this.closed.compareAndSet(false, true)) {
                this.call.close(Status.fromThrowable((Throwable)t), new Metadata());
            }
        }

        private void invoke(final Consumer<ServerCall.Listener<ReqT>> invocation) {
            if (Vertx.currentContext() == this.context) {
                ServerCall.Listener<ReqT> listener = this.getDelegate();
                if (listener == null) {
                    return;
                }
                try {
                    invocation.accept(listener);
                }
                catch (Throwable t) {
                    this.close(t);
                }
            } else {
                this.context.runOnContext((Handler)new Handler<Void>(){

                    public void handle(Void x) {
                        ServerCall.Listener listener = this.getDelegate();
                        if (listener == null) {
                            return;
                        }
                        try {
                            invocation.accept(listener);
                        }
                        catch (Throwable t) {
                            this.close(t);
                        }
                    }
                });
            }
        }

        public void onMessage(final ReqT message) {
            this.invoke(new Consumer<ServerCall.Listener<ReqT>>(){

                @Override
                public void accept(ServerCall.Listener<ReqT> listener) {
                    listener.onMessage(message);
                }
            });
        }

        public void onReady() {
            this.invoke(ServerCall.Listener::onReady);
        }

        public void onHalfClose() {
            this.invoke(ServerCall.Listener::onHalfClose);
        }

        public void onCancel() {
            this.invoke(ServerCall.Listener::onCancel);
        }

        public void onComplete() {
            this.invoke(ServerCall.Listener::onComplete);
        }
    }
}

