/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime;

import grpc.health.v1.HealthOuterClass;
import io.grpc.BindableService;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.quarkus.arc.Arc;
import io.quarkus.arc.Subclass;
import io.quarkus.grpc.runtime.GrpcContainer;
import io.quarkus.grpc.runtime.GrpcSslUtils;
import io.quarkus.grpc.runtime.ServerInterceptorStorage;
import io.quarkus.grpc.runtime.config.GrpcConfiguration;
import io.quarkus.grpc.runtime.config.GrpcServerConfiguration;
import io.quarkus.grpc.runtime.config.GrpcServerNettyConfig;
import io.quarkus.grpc.runtime.devmode.GrpcHotReplacementInterceptor;
import io.quarkus.grpc.runtime.devmode.GrpcServerReloader;
import io.quarkus.grpc.runtime.health.GrpcHealthStorage;
import io.quarkus.grpc.runtime.reflection.ReflectionService;
import io.quarkus.grpc.runtime.supports.CompressionInterceptor;
import io.quarkus.grpc.runtime.supports.blocking.BlockingServerInterceptor;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.QuarkusBindException;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ProfileManager;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.grpc.VertxServer;
import io.vertx.grpc.VertxServerBuilder;
import io.vertx.grpc.server.GrpcServer;
import io.vertx.grpc.server.GrpcServiceBridge;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.net.BindException;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.enterprise.inject.Instance;
import org.jboss.logging.Logger;

@Recorder
public class GrpcServerRecorder {
    private static final Logger LOGGER = Logger.getLogger((String)GrpcServerRecorder.class.getName());
    private static final AtomicInteger grpcVerticleCount = new AtomicInteger(0);
    private static volatile DevModeWrapper devModeWrapper;
    private static volatile List<GrpcServiceDefinition> services;
    private static final Pattern GRPC_CONTENT_TYPE;

    public static List<GrpcServiceDefinition> getServices() {
        return services;
    }

    public void initializeGrpcServer(RuntimeValue<Vertx> vertxSupplier, RuntimeValue<Router> routerSupplier, GrpcConfiguration cfg, ShutdownContext shutdown, Map<String, List<String>> blockingMethodsPerService, LaunchMode launchMode) {
        GrpcContainer grpcContainer = (GrpcContainer)Arc.container().instance(GrpcContainer.class, new Annotation[0]).get();
        if (grpcContainer == null) {
            throw new IllegalStateException("gRPC not initialized, GrpcContainer not found");
        }
        Vertx vertx = (Vertx)vertxSupplier.getValue();
        if (GrpcServerRecorder.hasNoServices(grpcContainer.getServices()) && LaunchMode.current() != LaunchMode.DEVELOPMENT) {
            LOGGER.error((Object)"Unable to find beans exposing the `BindableService` interface - not starting the gRPC server");
        }
        GrpcServerConfiguration configuration = cfg.server;
        if (configuration.useSeparateServer) {
            LOGGER.warn((Object)"Using legacy gRPC support, with separate new HTTP server instance. Switch to single HTTP server instance usage with quarkus.grpc.server.use-separate-server=false property");
            if (launchMode == LaunchMode.DEVELOPMENT) {
                if (GrpcServerReloader.getServer() == null) {
                    this.devModeStart(grpcContainer, vertx, configuration, blockingMethodsPerService, shutdown, launchMode);
                } else {
                    this.devModeReload(grpcContainer, vertx, configuration, blockingMethodsPerService, shutdown);
                }
            } else {
                this.prodStart(grpcContainer, vertx, configuration, blockingMethodsPerService, launchMode);
            }
        } else {
            this.buildGrpcServer(vertx, configuration, routerSupplier, shutdown, blockingMethodsPerService, grpcContainer, launchMode);
        }
    }

    private void buildGrpcServer(Vertx vertx, GrpcServerConfiguration configuration, RuntimeValue<Router> routerSupplier, ShutdownContext shutdown, Map<String, List<String>> blockingMethodsPerService, GrpcContainer grpcContainer, LaunchMode launchMode) {
        boolean reflectionServiceEnabled;
        GrpcServer server = GrpcServer.server((Vertx)vertx);
        List<ServerInterceptor> globalInterceptors = grpcContainer.getSortedGlobalInterceptors();
        if (launchMode == LaunchMode.DEVELOPMENT) {
            globalInterceptors.add(0, new DevModeInterceptor(Thread.currentThread().getContextClassLoader()));
        }
        List<GrpcServiceDefinition> toBeRegistered = GrpcServerRecorder.collectServiceDefinitions(grpcContainer.getServices());
        ArrayList<ServerServiceDefinition> definitions = new ArrayList<ServerServiceDefinition>();
        CompressionInterceptor compressionInterceptor = this.prepareCompressionInterceptor(configuration);
        for (GrpcServiceDefinition service : toBeRegistered) {
            ServerServiceDefinition defWithInterceptors = this.serviceWithInterceptors(vertx, grpcContainer, blockingMethodsPerService, compressionInterceptor, service, launchMode == LaunchMode.DEVELOPMENT);
            LOGGER.debugf("Registered gRPC service '%s'", (Object)service.definition.getServiceDescriptor().getName());
            ServerServiceDefinition serviceDefinition = ServerInterceptors.intercept((ServerServiceDefinition)defWithInterceptors, globalInterceptors);
            GrpcServiceBridge bridge = GrpcServiceBridge.bridge((ServerServiceDefinition)serviceDefinition);
            bridge.bind(server);
            definitions.add(service.definition);
        }
        boolean bl = reflectionServiceEnabled = configuration.enableReflectionService || ProfileManager.getLaunchMode() == LaunchMode.DEVELOPMENT;
        if (reflectionServiceEnabled) {
            LOGGER.info((Object)"Registering gRPC reflection service");
            ReflectionService reflectionService = new ReflectionService(definitions);
            ServerServiceDefinition serviceDefinition = ServerInterceptors.intercept((BindableService)reflectionService, globalInterceptors);
            GrpcServiceBridge bridge = GrpcServiceBridge.bridge((ServerServiceDefinition)serviceDefinition);
            bridge.bind(server);
        }
        LOGGER.info((Object)"Starting new Vert.x gRPC server ...");
        Route route = ((Router)routerSupplier.getValue()).route().handler(ctx -> {
            if (!GrpcServerRecorder.isGrpc(ctx)) {
                ctx.next();
            } else {
                server.handle((Object)ctx.request());
            }
        });
        shutdown.addShutdownTask(() -> ((Route)route).remove());
    }

    private static boolean isGrpc(RoutingContext rc) {
        String header = rc.request().getHeader("content-type");
        return header != null && GRPC_CONTENT_TYPE.matcher(header.toLowerCase(Locale.ROOT)).matches();
    }

    private void prodStart(final GrpcContainer grpcContainer, Vertx vertx, final GrpcServerConfiguration configuration, final Map<String, List<String>> blockingMethodsPerService, final LaunchMode launchMode) {
        final CompletableFuture startResult = new CompletableFuture();
        vertx.deployVerticle((Supplier)new Supplier<Verticle>(){

            @Override
            public Verticle get() {
                return new GrpcServerVerticle(configuration, grpcContainer, launchMode, blockingMethodsPerService);
            }
        }, new DeploymentOptions().setInstances(configuration.instances), (Handler)new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> result) {
                if (result.failed()) {
                    startResult.completeExceptionally(result.cause());
                } else {
                    GrpcServerRecorder.this.postStartup(configuration, launchMode == LaunchMode.TEST);
                    startResult.complete(null);
                }
            }
        });
        try {
            startResult.get(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error((Object)"Unable to start the gRPC server, waiting for server start interrupted");
        }
        catch (TimeoutException e) {
            LOGGER.error((Object)"Unable to start the gRPC server, still not listening after 1 minute");
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Unable to start the gRPC server", e.getCause());
        }
    }

    private void postStartup(GrpcServerConfiguration configuration, boolean test) {
        this.initHealthStorage();
        LOGGER.infof("gRPC Server started on %s:%d [SSL enabled: %s]", (Object)configuration.host, (Object)(test ? configuration.testPort : configuration.port), (Object)(!configuration.plainText ? 1 : 0));
    }

    private void initHealthStorage() {
        GrpcHealthStorage storage = (GrpcHealthStorage)Arc.container().instance(GrpcHealthStorage.class, new Annotation[0]).get();
        storage.setStatus("", HealthOuterClass.HealthCheckResponse.ServingStatus.SERVING);
        for (GrpcServiceDefinition service : services) {
            storage.setStatus(service.definition.getServiceDescriptor().getName(), HealthOuterClass.HealthCheckResponse.ServingStatus.SERVING);
        }
    }

    private void devModeStart(GrpcContainer grpcContainer, Vertx vertx, final GrpcServerConfiguration configuration, Map<String, List<String>> blockingMethodsPerService, ShutdownContext shutdown, LaunchMode launchMode) {
        final CompletableFuture future = new CompletableFuture();
        devModeWrapper = new DevModeWrapper(Thread.currentThread().getContextClassLoader());
        final Map.Entry<Integer, VertxServer> portToServer = this.buildServer(vertx, configuration, blockingMethodsPerService, grpcContainer, launchMode);
        VertxServer vertxServer = portToServer.getValue().start((Handler)new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> ar) {
                if (ar.failed()) {
                    Throwable effectiveCause = GrpcServerRecorder.this.getEffectiveThrowable(ar, portToServer);
                    if (effectiveCause instanceof QuarkusBindException) {
                        LOGGER.error((Object)"Unable to start the gRPC server");
                    } else {
                        LOGGER.error((Object)"Unable to start the gRPC server", effectiveCause);
                    }
                    future.completeExceptionally(effectiveCause);
                } else {
                    GrpcServerRecorder.this.postStartup(configuration, false);
                    future.complete(true);
                    grpcVerticleCount.incrementAndGet();
                }
            }
        });
        try {
            future.get(1L, TimeUnit.MINUTES);
        }
        catch (TimeoutException e) {
            LOGGER.error((Object)"Failed to start grpc server in time", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("grpc server start failed", e);
        }
        catch (InterruptedException e) {
            LOGGER.warn((Object)"Waiting for grpc server start interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        GrpcServerReloader.init(vertxServer);
        shutdown.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                GrpcServerReloader.reset();
            }
        });
    }

    private void applyNettySettings(GrpcServerConfiguration configuration, VertxServerBuilder builder) {
        if (configuration.netty != null) {
            GrpcServerNettyConfig config = configuration.netty;
            config.keepAliveTime.ifPresent(duration -> builder.nettyBuilder().keepAliveTime(duration.toNanos(), TimeUnit.NANOSECONDS));
        }
    }

    private void applyTransportSecurityConfig(GrpcServerConfiguration configuration, VertxServerBuilder builder) {
        if (configuration.transportSecurity != null) {
            File cert = configuration.transportSecurity.certificate.map(new Function<String, File>(){

                @Override
                public File apply(String pathname) {
                    return new File(pathname);
                }
            }).orElse(null);
            File key = configuration.transportSecurity.key.map(new Function<String, File>(){

                @Override
                public File apply(String pathname) {
                    return new File(pathname);
                }
            }).orElse(null);
            if (cert != null || key != null) {
                builder.useTransportSecurity(cert, key);
            }
        }
    }

    private static boolean hasNoServices(Instance<BindableService> services) {
        return services.isUnsatisfied() || services.stream().count() == 1L && ((BindableService)services.get()).bindService().getServiceDescriptor().getName().equals("grpc.health.v1.Health");
    }

    private static List<GrpcServiceDefinition> collectServiceDefinitions(Instance<BindableService> services) {
        ArrayList<GrpcServiceDefinition> definitions = new ArrayList<GrpcServiceDefinition>();
        for (BindableService service : services) {
            ServerServiceDefinition definition = service.bindService();
            definitions.add(new GrpcServiceDefinition(service, definition));
        }
        GrpcServerRecorder.services = definitions;
        return definitions;
    }

    private Throwable getEffectiveThrowable(AsyncResult<Void> ar, Map.Entry<Integer, VertxServer> portToServer) {
        Throwable effectiveCause = ar.cause();
        while (effectiveCause.getCause() != null) {
            effectiveCause = effectiveCause.getCause();
        }
        if (effectiveCause instanceof BindException) {
            effectiveCause = new QuarkusBindException(new Integer[]{portToServer.getKey()});
        }
        return effectiveCause;
    }

    private void devModeReload(GrpcContainer grpcContainer, Vertx vertx, GrpcServerConfiguration configuration, Map<String, List<String>> blockingMethodsPerService, ShutdownContext shutdown) {
        List<GrpcServiceDefinition> services = GrpcServerRecorder.collectServiceDefinitions(grpcContainer.getServices());
        ArrayList<ServerServiceDefinition> definitions = new ArrayList<ServerServiceDefinition>();
        HashMap methods = new HashMap();
        for (GrpcServiceDefinition grpcServiceDefinition : services) {
            definitions.add(grpcServiceDefinition.definition);
        }
        ServerServiceDefinition reflectionService = new ReflectionService(definitions).bindService();
        for (ServerMethodDefinition method : reflectionService.getMethods()) {
            methods.put(method.getMethodDescriptor().getFullMethodName(), method);
        }
        ArrayList<ServerServiceDefinition> arrayList = new ArrayList<ServerServiceDefinition>();
        CompressionInterceptor compressionInterceptor = this.prepareCompressionInterceptor(configuration);
        for (GrpcServiceDefinition service : services) {
            arrayList.add(this.serviceWithInterceptors(vertx, grpcContainer, blockingMethodsPerService, compressionInterceptor, service, true));
        }
        for (ServerServiceDefinition serviceWithInterceptors : arrayList) {
            for (ServerMethodDefinition method : serviceWithInterceptors.getMethods()) {
                methods.put(method.getMethodDescriptor().getFullMethodName(), method);
            }
        }
        devModeWrapper = new DevModeWrapper(Thread.currentThread().getContextClassLoader());
        this.initHealthStorage();
        GrpcServerReloader.reinitialize(arrayList, methods, grpcContainer.getSortedGlobalInterceptors());
        shutdown.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                GrpcServerReloader.reset();
            }
        });
    }

    public static int getVerticleCount() {
        return grpcVerticleCount.get();
    }

    public RuntimeValue<ServerInterceptorStorage> initServerInterceptorStorage(Map<String, Set<Class<?>>> perServiceInterceptors, Set<Class<?>> globalInterceptors) {
        return new RuntimeValue((Object)new ServerInterceptorStorage(perServiceInterceptors, globalInterceptors));
    }

    private Map.Entry<Integer, VertxServer> buildServer(final Vertx vertx, final GrpcServerConfiguration configuration, Map<String, List<String>> blockingMethodsPerService, GrpcContainer grpcContainer, LaunchMode launchMode) {
        Optional<Duration> handshakeTimeout;
        int port = launchMode == LaunchMode.TEST ? configuration.testPort : configuration.port;
        VertxServerBuilder builder = VertxServerBuilder.forAddress((Vertx)vertx, (String)configuration.host, (int)port);
        final AtomicBoolean usePlainText = new AtomicBoolean();
        builder.useSsl((Handler)new Handler<HttpServerOptions>(){

            public void handle(HttpServerOptions options) {
                try {
                    usePlainText.set(GrpcSslUtils.applySslOptions(configuration, options));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
        if (configuration.maxInboundMessageSize.isPresent()) {
            builder.maxInboundMessageSize(configuration.maxInboundMessageSize.getAsInt());
        }
        if (configuration.maxInboundMetadataSize.isPresent()) {
            builder.maxInboundMetadataSize(configuration.maxInboundMetadataSize.getAsInt());
        }
        if ((handshakeTimeout = configuration.handshakeTimeout).isPresent()) {
            builder.handshakeTimeout(handshakeTimeout.get().toMillis(), TimeUnit.MILLISECONDS);
        }
        this.applyTransportSecurityConfig(configuration, builder);
        this.applyNettySettings(configuration, builder);
        boolean reflectionServiceEnabled = configuration.enableReflectionService || ProfileManager.getLaunchMode() == LaunchMode.DEVELOPMENT;
        List<GrpcServiceDefinition> toBeRegistered = GrpcServerRecorder.collectServiceDefinitions(grpcContainer.getServices());
        ArrayList<ServerServiceDefinition> definitions = new ArrayList<ServerServiceDefinition>();
        CompressionInterceptor compressionInterceptor = this.prepareCompressionInterceptor(configuration);
        for (GrpcServiceDefinition service : toBeRegistered) {
            builder.addService(this.serviceWithInterceptors(vertx, grpcContainer, blockingMethodsPerService, compressionInterceptor, service, launchMode == LaunchMode.DEVELOPMENT));
            LOGGER.debugf("Registered gRPC service '%s'", (Object)service.definition.getServiceDescriptor().getName());
            definitions.add(service.definition);
        }
        if (reflectionServiceEnabled) {
            LOGGER.info((Object)"Registering gRPC reflection service");
            builder.addService((BindableService)new ReflectionService(definitions));
        }
        for (ServerInterceptor serverInterceptor : grpcContainer.getSortedGlobalInterceptors()) {
            builder.intercept(serverInterceptor);
        }
        if (launchMode == LaunchMode.DEVELOPMENT) {
            builder.commandDecorator((Consumer)new Consumer<Runnable>(){

                @Override
                public void accept(final Runnable command) {
                    vertx.executeBlocking((Handler)new Handler<Promise<Boolean>>(){

                        public void handle(Promise<Boolean> event) {
                            event.complete((Object)GrpcHotReplacementInterceptor.fire());
                        }
                    }, false, (Handler)new Handler<AsyncResult<Boolean>>(){

                        public void handle(AsyncResult<Boolean> result) {
                            devModeWrapper.run(command);
                        }
                    });
                }
            });
        }
        LOGGER.debugf("Starting gRPC Server on %s:%d  [SSL enabled: %s]...", (Object)configuration.host, (Object)port, (Object)(!usePlainText.get() ? 1 : 0));
        return new AbstractMap.SimpleEntry<Integer, VertxServer>(port, builder.build());
    }

    private CompressionInterceptor prepareCompressionInterceptor(GrpcServerConfiguration configuration) {
        CompressionInterceptor compressionInterceptor = null;
        if (configuration.compression.isPresent()) {
            compressionInterceptor = new CompressionInterceptor(configuration.compression.get());
        }
        return compressionInterceptor;
    }

    private ServerServiceDefinition serviceWithInterceptors(Vertx vertx, GrpcContainer grpcContainer, Map<String, List<String>> blockingMethodsPerService, CompressionInterceptor compressionInterceptor, GrpcServiceDefinition service, boolean devMode) {
        List<String> list;
        ArrayList<ServerInterceptor> interceptors = new ArrayList<ServerInterceptor>();
        if (compressionInterceptor != null) {
            interceptors.add(compressionInterceptor);
        }
        interceptors.addAll(grpcContainer.getSortedPerServiceInterceptors(service.getImplementationClassName()));
        if (!blockingMethodsPerService.isEmpty() && (list = blockingMethodsPerService.get(service.getImplementationClassName())) != null) {
            interceptors.add(new BlockingServerInterceptor(vertx, list, devMode));
        }
        return ServerInterceptors.intercept((ServerServiceDefinition)service.definition, interceptors);
    }

    static {
        services = Collections.emptyList();
        GRPC_CONTENT_TYPE = Pattern.compile("^application/grpc.*");
    }

    private class DevModeInterceptor
    implements ServerInterceptor {
        private final ClassLoader classLoader;

        public DevModeInterceptor(ClassLoader contextClassLoader) {
            this.classLoader = contextClassLoader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> next) {
            ClassLoader originalTccl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            try {
                ServerCall.Listener listener = next.startCall(serverCall, metadata);
                return listener;
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalTccl);
            }
        }
    }

    private class DevModeWrapper {
        private final ClassLoader classLoader;

        public DevModeWrapper(ClassLoader contextClassLoader) {
            this.classLoader = contextClassLoader;
        }

        public void run(Runnable command) {
            ClassLoader originalTccl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            try {
                command.run();
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalTccl);
            }
        }
    }

    private class GrpcServerVerticle
    extends AbstractVerticle {
        private final GrpcServerConfiguration configuration;
        private final GrpcContainer grpcContainer;
        private final LaunchMode launchMode;
        private final Map<String, List<String>> blockingMethodsPerService;
        private VertxServer grpcServer;

        GrpcServerVerticle(GrpcServerConfiguration configuration, GrpcContainer grpcContainer, LaunchMode launchMode, Map<String, List<String>> blockingMethodsPerService) {
            this.configuration = configuration;
            this.grpcContainer = grpcContainer;
            this.launchMode = launchMode;
            this.blockingMethodsPerService = blockingMethodsPerService;
        }

        public void start(final Promise<Void> startPromise) {
            if (this.grpcContainer.getServices().isUnsatisfied()) {
                LOGGER.warn((Object)"Unable to find bean exposing the `BindableService` interface - not starting the gRPC server");
                return;
            }
            final Map.Entry<Integer, VertxServer> portToServer = GrpcServerRecorder.this.buildServer(this.getVertx(), this.configuration, this.blockingMethodsPerService, this.grpcContainer, this.launchMode);
            this.grpcServer = portToServer.getValue().start((Handler)new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> ar) {
                    if (ar.failed()) {
                        Throwable effectiveCause = GrpcServerRecorder.this.getEffectiveThrowable(ar, portToServer);
                        if (effectiveCause instanceof QuarkusBindException) {
                            LOGGER.error((Object)"Unable to start the gRPC server");
                        } else {
                            LOGGER.error((Object)"Unable to start the gRPC server", effectiveCause);
                        }
                        startPromise.fail(effectiveCause);
                    } else {
                        startPromise.complete();
                        grpcVerticleCount.incrementAndGet();
                    }
                }
            });
        }

        public void stop(final Promise<Void> stopPromise) {
            this.grpcServer.shutdown((Handler)new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> ar) {
                    if (ar.failed()) {
                        LOGGER.errorf(ar.cause(), "Unable to stop the gRPC server gracefully", new Object[0]);
                    } else {
                        LOGGER.debug((Object)"gRPC Server stopped");
                        stopPromise.complete();
                        grpcVerticleCount.decrementAndGet();
                    }
                }
            });
        }
    }

    public static final class GrpcServiceDefinition {
        public final BindableService service;
        public final ServerServiceDefinition definition;

        GrpcServiceDefinition(BindableService service, ServerServiceDefinition definition) {
            this.service = service;
            this.definition = definition;
        }

        public String getImplementationClassName() {
            if (this.service instanceof Subclass) {
                return this.service.getClass().getSuperclass().getName();
            }
            return this.service.getClass().getName();
        }
    }
}

