/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.supports.exc;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.StatusException;
import io.quarkus.arc.DefaultBean;
import io.quarkus.grpc.ExceptionHandler;
import io.quarkus.grpc.ExceptionHandlerProvider;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
@DefaultBean
public class DefaultExceptionHandlerProvider
implements ExceptionHandlerProvider {
    public <ReqT, RespT> ExceptionHandler<ReqT, RespT> createHandler(ServerCall.Listener<ReqT> listener, ServerCall<ReqT, RespT> call, Metadata metadata) {
        return new DefaultExceptionHandler<ReqT, RespT>(listener, call, metadata);
    }

    private static class DefaultExceptionHandler<ReqT, RespT>
    extends ExceptionHandler<ReqT, RespT> {
        public DefaultExceptionHandler(ServerCall.Listener<ReqT> listener, ServerCall<ReqT, RespT> call, Metadata metadata) {
            super(listener, call, metadata);
        }

        protected void handleException(Throwable exception, ServerCall<ReqT, RespT> call, Metadata metadata) {
            StatusException se = (StatusException)ExceptionHandlerProvider.toStatusException((Throwable)exception, (boolean)false);
            Metadata trailers = se.getTrailers() != null ? se.getTrailers() : metadata;
            call.close(se.getStatus(), trailers);
        }
    }
}

