/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.supports;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.MethodDescriptor;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.quarkus.arc.Arc;
import io.quarkus.arc.BeanDestroyer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.grpc.GrpcClient;
import io.quarkus.grpc.RegisterClientInterceptor;
import io.quarkus.grpc.runtime.ClientInterceptorStorage;
import io.quarkus.grpc.runtime.GrpcClientInterceptorContainer;
import io.quarkus.grpc.runtime.config.GrpcClientConfiguration;
import io.quarkus.grpc.runtime.config.GrpcServerConfiguration;
import io.quarkus.grpc.runtime.config.SslClientConfig;
import io.quarkus.grpc.runtime.stork.StorkMeasuringGrpcInterceptor;
import io.quarkus.grpc.runtime.supports.GrpcClientConfigProvider;
import io.quarkus.grpc.spi.GrpcBuilderProvider;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.util.ClassPathUtils;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TrustOptions;
import io.vertx.grpc.client.GrpcClient;
import io.vertx.grpc.client.GrpcClientChannel;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.logging.Logger;

public class Channels {
    private static final Logger LOGGER = Logger.getLogger((String)Channels.class.getName());

    private Channels() {
    }

    public static Channel createChannel(String name, Set<String> perClientInterceptors) throws Exception {
        Optional<Duration> idleTimeout;
        String resolver;
        InstanceHandle instance = Arc.container().instance(GrpcClientConfigProvider.class, new Annotation[0]);
        if (!instance.isAvailable()) {
            throw new IllegalStateException("Unable to find the GrpcClientConfigProvider");
        }
        GrpcClientConfigProvider configProvider = (GrpcClientConfigProvider)instance.get();
        GrpcClientConfiguration config = configProvider.getConfiguration(name);
        if (config == null && LaunchMode.current() == LaunchMode.TEST) {
            LOGGER.infof("gRPC client %s created without configuration. We are assuming that it's created to test your gRPC services.", (Object)name);
            config = Channels.testConfig(configProvider.getServerConfiguration());
        }
        if (config == null) {
            throw new IllegalStateException("gRPC client " + name + " is missing configuration.");
        }
        GrpcBuilderProvider provider = GrpcBuilderProvider.findChannelBuilderProvider(config);
        boolean vertxGrpc = config.useQuarkusGrpcClient;
        Object host = config.host;
        int port = config.port;
        String nameResolver = config.nameResolver;
        boolean stork = "stork".equalsIgnoreCase(nameResolver);
        String[] resolverSplit = nameResolver.split(":");
        String string = resolver = provider != null ? provider.resolver() : resolverSplit[0];
        if (provider != null) {
            host = provider.adjustHost((String)host);
        } else if (!vertxGrpc && "dns".equalsIgnoreCase(resolver)) {
            host = "/" + (String)host;
        }
        GrpcClientInterceptorContainer interceptorContainer = (GrpcClientInterceptorContainer)Arc.container().instance(GrpcClientInterceptorContainer.class, new Annotation[0]).get();
        if (stork) {
            perClientInterceptors = new HashSet<String>(perClientInterceptors);
            perClientInterceptors.add(StorkMeasuringGrpcInterceptor.class.getName());
        }
        boolean plainText = config.ssl.trustStore.isEmpty();
        Optional<Boolean> usePlainText = config.plainText;
        if (usePlainText.isPresent()) {
            plainText = usePlainText.get();
        }
        if (!vertxGrpc) {
            Optional<Duration> idleTimeout2;
            Optional<Duration> keepAliveTimeout;
            Optional<Duration> keepAliveTime;
            Optional<String> overrideAuthority;
            Optional<String> userAgent;
            String target = String.format("%s://%s:%d", resolver, host, port);
            LOGGER.debugf("Target for client '%s': %s", (Object)name, (Object)target);
            SslContext context = null;
            if (!plainText && provider == null) {
                Path trustStorePath = config.ssl.trustStore.orElse(null);
                Path certificatePath = config.ssl.certificate.orElse(null);
                Path keyPath = config.ssl.key.orElse(null);
                SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
                if (trustStorePath != null) {
                    try (InputStream stream = Channels.streamFor(trustStorePath, "trust store");){
                        sslContextBuilder.trustManager(stream);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Configuring gRPC client trust store failed", e);
                    }
                }
                if (certificatePath != null && keyPath != null) {
                    try (InputStream certificate = Channels.streamFor(certificatePath, "certificate");
                         InputStream key = Channels.streamFor(keyPath, "key");){
                        sslContextBuilder.keyManager(certificate, key);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Configuring gRPC client certificate failed", e);
                    }
                }
                context = sslContextBuilder.build();
            }
            String loadBalancingPolicy = stork ? "stork" : config.loadBalancingPolicy;
            NettyChannelBuilder builder = provider != null ? provider.createChannelBuilder(config, target) : ((NettyChannelBuilder)((NettyChannelBuilder)((NettyChannelBuilder)((NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forTarget((String)target).directExecutor()).offloadExecutor(Infrastructure.getDefaultExecutor())).defaultLoadBalancingPolicy(loadBalancingPolicy)).flowControlWindow(config.flowControlWindow.orElse(0x100000)).keepAliveWithoutCalls(config.keepAliveWithoutCalls).maxHedgedAttempts(config.maxHedgedAttempts)).maxRetryAttempts(config.maxRetryAttempts)).maxInboundMetadataSize(config.maxInboundMetadataSize.orElse(8192)).maxInboundMessageSize(config.maxInboundMessageSize.orElse(0x400000)).negotiationType(NegotiationType.valueOf((String)config.negotiationType.toUpperCase()));
            if (config.retry) {
                builder.enableRetry();
            } else {
                builder.disableRetry();
            }
            if (config.maxTraceEvents.isPresent()) {
                builder.maxTraceEvents(config.maxTraceEvents.getAsInt());
            }
            if ((userAgent = config.userAgent).isPresent()) {
                builder.userAgent(userAgent.get());
            }
            if (config.retryBufferSize.isPresent()) {
                builder.retryBufferSize(config.retryBufferSize.getAsLong());
            }
            if (config.perRpcBufferLimit.isPresent()) {
                builder.perRpcBufferLimit(config.perRpcBufferLimit.getAsLong());
            }
            if ((overrideAuthority = config.overrideAuthority).isPresent()) {
                builder.overrideAuthority(overrideAuthority.get());
            }
            if ((keepAliveTime = config.keepAliveTime).isPresent()) {
                builder.keepAliveTime(keepAliveTime.get().toMillis(), TimeUnit.MILLISECONDS);
            }
            if ((keepAliveTimeout = config.keepAliveTimeout).isPresent()) {
                builder.keepAliveTimeout(keepAliveTimeout.get().toMillis(), TimeUnit.MILLISECONDS);
            }
            if ((idleTimeout2 = config.idleTimeout).isPresent()) {
                builder.keepAliveTimeout(idleTimeout2.get().toMillis(), TimeUnit.MILLISECONDS);
            }
            if (plainText && provider == null) {
                builder.usePlaintext();
            }
            if (context != null && builder instanceof NettyChannelBuilder) {
                NettyChannelBuilder ncBuilder = builder;
                ncBuilder.sslContext(context);
            }
            interceptorContainer.getSortedPerServiceInterceptors(perClientInterceptors).forEach(arg_0 -> Channels.lambda$createChannel$0((ManagedChannelBuilder)builder, arg_0));
            interceptorContainer.getSortedGlobalInterceptors().forEach(arg_0 -> Channels.lambda$createChannel$1((ManagedChannelBuilder)builder, arg_0));
            LOGGER.info((Object)String.format("Creating %s gRPC channel ...", provider != null ? provider.channelInfo() : "Netty"));
            return builder.build();
        }
        HttpClientOptions options = new HttpClientOptions();
        if (!plainText && config.ssl.trustStore.isPresent()) {
            Optional<Path> trustStorePath = config.ssl.trustStore;
            if (trustStorePath.isPresent()) {
                PemTrustOptions to = new PemTrustOptions();
                to.addCertValue(Channels.bufferFor(trustStorePath.get(), "trust store"));
                options.setTrustOptions((TrustOptions)to);
                options.setSsl(true);
                options.setUseAlpn(true);
            }
            Optional<Path> certificatePath = config.ssl.certificate;
            Optional<Path> keyPath = config.ssl.key;
            if (certificatePath.isPresent() && keyPath.isPresent()) {
                PemKeyCertOptions cko = new PemKeyCertOptions();
                cko.setCertValue(Channels.bufferFor(certificatePath.get(), "certificate"));
                cko.setKeyValue(Channels.bufferFor(keyPath.get(), "key"));
                options.setKeyCertOptions((KeyCertOptions)cko);
                options.setSsl(true);
                options.setUseAlpn(true);
            }
        }
        options.setKeepAlive(config.keepAliveWithoutCalls);
        Optional<Duration> keepAliveTimeout = config.keepAliveTimeout;
        if (keepAliveTimeout.isPresent()) {
            int keepAliveTimeoutN = (int)keepAliveTimeout.get().toSeconds();
            options.setKeepAliveTimeout(keepAliveTimeoutN);
            options.setHttp2KeepAliveTimeout(keepAliveTimeoutN);
        }
        if ((idleTimeout = config.idleTimeout).isPresent()) {
            options.setIdleTimeout((int)idleTimeout.get().toMillis());
            options.setIdleTimeoutUnit(TimeUnit.MILLISECONDS);
        }
        options.setMetricsName("grpc|" + name);
        Vertx vertx = (Vertx)Arc.container().instance(Vertx.class, new Annotation[0]).get();
        GrpcClient client = GrpcClient.client((Vertx)vertx, (HttpClientOptions)options);
        GrpcClientChannel channel = new GrpcClientChannel(client, SocketAddress.inetSocketAddress((int)port, (String)host));
        LOGGER.debugf("Target for client '%s': %s", (Object)name, (Object)((String)host + ":" + port));
        ArrayList<ClientInterceptor> interceptors = new ArrayList<ClientInterceptor>();
        interceptors.addAll(interceptorContainer.getSortedPerServiceInterceptors(perClientInterceptors));
        interceptors.addAll(interceptorContainer.getSortedGlobalInterceptors());
        LOGGER.info((Object)"Creating Vert.x gRPC channel ...");
        return new InternalGrpcChannel(client, ClientInterceptors.intercept((Channel)channel, interceptors));
    }

    private static GrpcClientConfiguration testConfig(GrpcServerConfiguration serverConfiguration) {
        GrpcClientConfiguration config = new GrpcClientConfiguration();
        config.port = serverConfiguration.testPort;
        config.host = serverConfiguration.host;
        config.plainText = Optional.of(serverConfiguration.plainText);
        config.compression = Optional.empty();
        config.flowControlWindow = OptionalInt.empty();
        config.idleTimeout = Optional.empty();
        config.keepAliveTime = Optional.empty();
        config.keepAliveTimeout = Optional.empty();
        config.loadBalancingPolicy = "pick_first";
        config.maxHedgedAttempts = 5;
        config.maxInboundMessageSize = OptionalInt.empty();
        config.maxInboundMetadataSize = OptionalInt.empty();
        config.maxRetryAttempts = 0;
        config.maxTraceEvents = OptionalInt.empty();
        config.nameResolver = "dns";
        config.negotiationType = "PLAINTEXT";
        config.overrideAuthority = Optional.empty();
        config.perRpcBufferLimit = OptionalLong.empty();
        config.retry = false;
        config.retryBufferSize = OptionalLong.empty();
        config.ssl = new SslClientConfig();
        config.ssl.key = Optional.empty();
        config.ssl.certificate = Optional.empty();
        config.ssl.trustStore = Optional.empty();
        config.userAgent = Optional.empty();
        if (serverConfiguration.ssl.certificate.isPresent() || serverConfiguration.ssl.keyStore.isPresent()) {
            LOGGER.warn((Object)"gRPC client created without configuration and the gRPC server is configured for SSL. Configuring SSL for such clients is not supported.");
        }
        return config;
    }

    private static Buffer bufferFor(Path path, String resourceName) throws IOException {
        try (InputStream stream = Channels.streamFor(path, resourceName);){
            Buffer buffer = Buffer.buffer((byte[])stream.readAllBytes());
            return buffer;
        }
    }

    private static InputStream streamFor(Path path, String resourceName) {
        InputStream resource = Thread.currentThread().getContextClassLoader().getResourceAsStream(ClassPathUtils.toResourceName((Path)path));
        if (resource != null) {
            return resource;
        }
        try {
            return Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to read " + resourceName + " from " + path, e);
        }
    }

    public static Channel retrieveChannel(String name, Set<String> perClientInterceptors) {
        ClientInterceptorStorage clientInterceptorStorage = (ClientInterceptorStorage)Arc.container().instance(ClientInterceptorStorage.class, new Annotation[0]).get();
        Annotation[] qualifiers = new Annotation[perClientInterceptors.size() + 1];
        int idx = 0;
        qualifiers[idx++] = GrpcClient.Literal.of((String)name);
        for (String interceptor : perClientInterceptors) {
            qualifiers[idx++] = RegisterClientInterceptor.Literal.of(clientInterceptorStorage.getPerClientInterceptor(interceptor));
        }
        InstanceHandle instance = Arc.container().instance(Channel.class, qualifiers);
        if (!instance.isAvailable()) {
            throw new IllegalStateException("Unable to retrieve the gRPC Channel " + name);
        }
        return (Channel)instance.get();
    }

    private static /* synthetic */ void lambda$createChannel$1(ManagedChannelBuilder rec$, ClientInterceptor xva$0) {
        rec$.intercept(new ClientInterceptor[]{xva$0});
    }

    private static /* synthetic */ void lambda$createChannel$0(ManagedChannelBuilder rec$, ClientInterceptor xva$0) {
        rec$.intercept(new ClientInterceptor[]{xva$0});
    }

    private static class InternalGrpcChannel
    extends Channel {
        private final GrpcClient client;
        private final Channel delegate;

        public InternalGrpcChannel(GrpcClient client, Channel delegate) {
            this.client = client;
            this.delegate = delegate;
        }

        public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
            return this.delegate.newCall(methodDescriptor, callOptions);
        }

        public String authority() {
            return this.delegate.authority();
        }
    }

    public static class ChannelDestroyer
    implements BeanDestroyer<Channel> {
        public void destroy(Channel instance, CreationalContext<Channel> creationalContext, Map<String, Object> params) {
            if (instance instanceof ManagedChannel) {
                ManagedChannel channel = (ManagedChannel)instance;
                LOGGER.info((Object)("Shutting down gRPC channel " + channel));
                channel.shutdownNow();
                try {
                    channel.awaitTermination(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    LOGGER.info((Object)"Unable to shutdown channel after 10 seconds");
                    Thread.currentThread().interrupt();
                }
            } else if (instance instanceof InternalGrpcChannel) {
                InternalGrpcChannel channel = (InternalGrpcChannel)instance;
                LOGGER.info((Object)("Shutting down Vert.x gRPC channel " + channel.delegate));
                try {
                    channel.client.close().toCompletionStage().toCompletableFuture().get(10L, TimeUnit.SECONDS);
                }
                catch (ExecutionException | TimeoutException e) {
                    LOGGER.warn((Object)"Unable to shutdown channel after 10 seconds", (Throwable)e);
                }
                catch (InterruptedException e) {
                    LOGGER.info((Object)"Unable to shutdown channel after 10 seconds");
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

