/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.supports;

import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.quarkus.arc.Arc;
import io.quarkus.arc.BeanDestroyer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.grpc.GrpcClient;
import io.quarkus.grpc.runtime.GrpcClientInterceptorContainer;
import io.quarkus.grpc.runtime.config.GrpcClientConfiguration;
import io.quarkus.grpc.runtime.config.GrpcServerConfiguration;
import io.quarkus.grpc.runtime.config.SslClientConfig;
import io.quarkus.grpc.runtime.supports.GrpcClientConfigProvider;
import io.quarkus.runtime.LaunchMode;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import javax.enterprise.context.spi.CreationalContext;
import javax.net.ssl.SSLException;
import org.jboss.logging.Logger;

public class Channels {
    private static final Logger LOGGER = Logger.getLogger((String)Channels.class.getName());

    private Channels() {
    }

    public static Channel createChannel(String name) throws SSLException {
        Optional<Duration> idleTimeout;
        Optional<Duration> keepAliveTimeout;
        Optional<Duration> keepAliveTime;
        Optional<String> overrideAuthority;
        Optional<String> userAgent;
        InstanceHandle instance = Arc.container().instance(GrpcClientConfigProvider.class, new Annotation[0]);
        if (!instance.isAvailable()) {
            throw new IllegalStateException("Unable to find the GrpcClientConfigProvider");
        }
        GrpcClientConfigProvider configProvider = (GrpcClientConfigProvider)instance.get();
        GrpcClientConfiguration config = configProvider.getConfiguration(name);
        if (config == null && LaunchMode.current() == LaunchMode.TEST) {
            LOGGER.infof("gRPC client %s created without configuration. We are assuming that it's created to test your gRPC services.", (Object)name);
            config = Channels.testConfig(configProvider.getServerConfiguration());
        }
        if (config == null) {
            throw new IllegalStateException("gRPC client " + name + " is missing configuration.");
        }
        String host = config.host;
        int port = config.port;
        boolean plainText = !config.ssl.trustStore.isPresent();
        Optional<Boolean> usePlainText = config.plainText;
        if (usePlainText.isPresent()) {
            plainText = usePlainText.get();
        }
        SslContext context = null;
        if (!plainText) {
            Path trustStorePath = config.ssl.trustStore.orElse(null);
            Path certificatePath = config.ssl.certificate.orElse(null);
            Path keyPath = config.ssl.key.orElse(null);
            SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
            if (trustStorePath != null) {
                try (InputStream stream = Channels.streamFor(trustStorePath, "trust store");){
                    sslContextBuilder.trustManager(stream);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Configuring gRPC client trust store failed", e);
                }
            }
            if (certificatePath != null && keyPath != null) {
                try (InputStream certificate = Channels.streamFor(certificatePath, "certificate");
                     InputStream key = Channels.streamFor(keyPath, "key");){
                    sslContextBuilder.keyManager(certificate, key);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Configuring gRPC client certificate failed", e);
                }
            }
            context = sslContextBuilder.build();
        }
        NettyChannelBuilder builder = ((NettyChannelBuilder)((NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)host, (int)port).defaultLoadBalancingPolicy(config.loadBalancingPolicy)).flowControlWindow(config.flowControlWindow.orElse(0x100000)).keepAliveWithoutCalls(config.keepAliveWithoutCalls).maxHedgedAttempts(config.maxHedgedAttempts)).maxRetryAttempts(config.maxRetryAttempts)).maxInboundMetadataSize(config.maxInboundMetadataSize.orElse(8192)).maxInboundMessageSize(config.maxInboundMessageSize.orElse(0x400000)).negotiationType(NegotiationType.valueOf((String)config.negotiationType.toUpperCase()));
        if (config.retry) {
            builder.enableRetry();
        } else {
            builder.disableRetry();
        }
        if (config.maxTraceEvents.isPresent()) {
            builder.maxTraceEvents(config.maxTraceEvents.getAsInt());
        }
        if ((userAgent = config.userAgent).isPresent()) {
            builder.userAgent(userAgent.get());
        }
        if (config.retryBufferSize.isPresent()) {
            builder.retryBufferSize(config.retryBufferSize.getAsLong());
        }
        if (config.perRpcBufferLimit.isPresent()) {
            builder.perRpcBufferLimit(config.perRpcBufferLimit.getAsLong());
        }
        if ((overrideAuthority = config.overrideAuthority).isPresent()) {
            builder.overrideAuthority(overrideAuthority.get());
        }
        if ((keepAliveTime = config.keepAliveTime).isPresent()) {
            builder.keepAliveTime(keepAliveTime.get().toMillis(), TimeUnit.MILLISECONDS);
        }
        if ((keepAliveTimeout = config.keepAliveTimeout).isPresent()) {
            builder.keepAliveTimeout(keepAliveTimeout.get().toMillis(), TimeUnit.MILLISECONDS);
        }
        if ((idleTimeout = config.idleTimeout).isPresent()) {
            builder.keepAliveTimeout(idleTimeout.get().toMillis(), TimeUnit.MILLISECONDS);
        }
        if (plainText) {
            builder.usePlaintext();
        }
        if (context != null) {
            builder.sslContext(context);
        }
        InstanceHandle interceptors = Arc.container().instance(GrpcClientInterceptorContainer.class, new Annotation[0]);
        for (ClientInterceptor clientInterceptor : ((GrpcClientInterceptorContainer)interceptors.get()).getSortedInterceptors()) {
            builder.intercept(new ClientInterceptor[]{clientInterceptor});
        }
        return builder.build();
    }

    private static GrpcClientConfiguration testConfig(GrpcServerConfiguration serverConfiguration) {
        GrpcClientConfiguration config = new GrpcClientConfiguration();
        config.port = serverConfiguration.testPort;
        config.host = serverConfiguration.host;
        config.plainText = Optional.of(serverConfiguration.plainText);
        config.compression = Optional.empty();
        config.flowControlWindow = OptionalInt.empty();
        config.idleTimeout = Optional.empty();
        config.keepAliveTime = Optional.empty();
        config.keepAliveTimeout = Optional.empty();
        config.loadBalancingPolicy = "pick_first";
        config.maxHedgedAttempts = 5;
        config.maxInboundMessageSize = OptionalInt.empty();
        config.maxInboundMetadataSize = OptionalInt.empty();
        config.maxRetryAttempts = 0;
        config.maxTraceEvents = OptionalInt.empty();
        config.negotiationType = "PLAINTEXT";
        config.overrideAuthority = Optional.empty();
        config.perRpcBufferLimit = OptionalLong.empty();
        config.retry = false;
        config.retryBufferSize = OptionalLong.empty();
        config.ssl = new SslClientConfig();
        config.ssl.key = Optional.empty();
        config.ssl.certificate = Optional.empty();
        config.ssl.trustStore = Optional.empty();
        config.userAgent = Optional.empty();
        if (serverConfiguration.ssl.certificate.isPresent() || serverConfiguration.ssl.keyStore.isPresent()) {
            LOGGER.warn((Object)"gRPC client created without configuration and the gRPC server is configured for SSL. Configuring SSL for such clients is not supported.");
        }
        return config;
    }

    private static InputStream streamFor(Path path, String resourceName) {
        InputStream resource = Thread.currentThread().getContextClassLoader().getResourceAsStream(path.toString());
        if (resource != null) {
            return resource;
        }
        try {
            return Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to read " + resourceName + " from " + path, e);
        }
    }

    public static Channel retrieveChannel(String name) {
        InstanceHandle instance = Arc.container().instance(Channel.class, new Annotation[]{GrpcClient.Literal.of((String)name)});
        if (!instance.isAvailable()) {
            throw new IllegalStateException("Unable to retrieve the gRPC Channel " + name);
        }
        return (Channel)instance.get();
    }

    public static class ChannelDestroyer
    implements BeanDestroyer<Channel> {
        public void destroy(Channel instance, CreationalContext<Channel> creationalContext, Map<String, Object> params) {
            if (instance instanceof ManagedChannel) {
                ManagedChannel channel = (ManagedChannel)instance;
                LOGGER.info((Object)("Shutting down gRPC channel " + channel));
                channel.shutdownNow();
                try {
                    channel.awaitTermination(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    LOGGER.info((Object)"Unable to shutdown channel after 10 seconds");
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

