/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime;

import io.grpc.ServerInterceptor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class InterceptorStorage {
    private final Map<String, Set<Class<? extends ServerInterceptor>>> perServiceInterceptors = new HashMap<String, Set<Class<? extends ServerInterceptor>>>();
    private final Set<Class<? extends ServerInterceptor>> globalInterceptors = new HashSet<Class<? extends ServerInterceptor>>();

    public Set<Class<? extends ServerInterceptor>> getInterceptors(String serviceClassName) {
        return this.perServiceInterceptors.get(serviceClassName);
    }

    public Set<Class<? extends ServerInterceptor>> getGlobalInterceptors() {
        return this.globalInterceptors;
    }

    public void addGlobalInterceptor(Class<? extends ServerInterceptor> interceptor) {
        this.globalInterceptors.add(interceptor);
    }

    public void addInterceptor(String serviceClassName, Class<? extends ServerInterceptor> interceptor) {
        Set interceptors = this.perServiceInterceptors.computeIfAbsent(serviceClassName, c -> new HashSet());
        interceptors.add(interceptor);
    }
}

