/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.stork;

import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.Status;
import io.smallrye.mutiny.Uni;
import io.smallrye.stork.Service;
import io.smallrye.stork.ServiceDiscovery;
import io.smallrye.stork.ServiceInstance;
import io.smallrye.stork.Stork;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;

public class GrpcStorkServiceDiscovery
extends NameResolverProvider {
    private static final Logger log = Logger.getLogger(GrpcStorkServiceDiscovery.class);
    public static final Attributes.Key<ServiceInstance> SERVICE_INSTANCE = Attributes.Key.create((String)"service-instance");

    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return 4;
    }

    public String getDefaultScheme() {
        return "stork";
    }

    public NameResolver newNameResolver(final URI targetUri, NameResolver.Args args) {
        if (!"stork".equals(targetUri.getScheme())) {
            return null;
        }
        final NameResolver.ServiceConfigParser configParser = args.getServiceConfigParser();
        return new NameResolver(){
            NameResolver.Listener2 listener;
            volatile boolean resolving;
            volatile boolean shutdown;
            ServiceDiscovery serviceDiscovery;
            String serviceName;
            volatile Set<Long> serviceInstanceIds = new HashSet<Long>();

            public String getServiceAuthority() {
                return targetUri.getAuthority();
            }

            public void shutdown() {
                this.shutdown = true;
            }

            public void start(NameResolver.Listener2 listener) {
                Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"already started");
                this.listener = listener;
                this.serviceName = targetUri.getHost();
                Service service = Stork.getInstance().getService(this.serviceName);
                if (service == null) {
                    listener.onError(Status.ABORTED.withDescription("No service definition for serviceName " + this.serviceName + " found."));
                    return;
                }
                this.serviceDiscovery = service.getServiceDiscovery();
                this.resolve();
            }

            private void resolve() {
                if (this.resolving || this.shutdown) {
                    return;
                }
                this.resolving = true;
                Uni serviceInstances = this.serviceDiscovery.getServiceInstances();
                serviceInstances.subscribe().with(this::informListener);
            }

            public void refresh() {
                this.resolve();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void informListener(List<ServiceInstance> instances) {
                block10: {
                    ArrayList<EquivalentAddressGroup> addresses = new ArrayList<EquivalentAddressGroup>();
                    try {
                        if (this.serviceInstanceIds.size() == instances.size() && !this.areServicesRemoved(instances)) break block10;
                        HashSet<Long> serviceInstanceIds = new HashSet<Long>();
                        for (ServiceInstance instance : instances) {
                            serviceInstanceIds.add(instance.getId());
                        }
                        this.serviceInstanceIds = serviceInstanceIds;
                        for (ServiceInstance instance : instances) {
                            ArrayList<InetSocketAddress> socketAddresses = new ArrayList<InetSocketAddress>();
                            try {
                                for (InetAddress inetAddress : InetAddress.getAllByName(instance.getHost())) {
                                    socketAddresses.add(new InetSocketAddress(inetAddress, instance.getPort()));
                                }
                            }
                            catch (UnknownHostException e) {
                                log.errorf((Throwable)e, "Ignoring wrong host: '%s' for service name '%s'", (Object)instance.getHost(), (Object)this.serviceName);
                            }
                            if (socketAddresses.isEmpty()) continue;
                            Attributes attributes = Attributes.newBuilder().set(SERVICE_INSTANCE, (Object)instance).build();
                            EquivalentAddressGroup addressGroup = new EquivalentAddressGroup(socketAddresses, attributes);
                            addresses.add(addressGroup);
                        }
                        if (addresses.isEmpty()) {
                            log.error((Object)("Failed to determine working socket addresses for service-name: " + this.serviceName));
                            this.listener.onError(Status.FAILED_PRECONDITION);
                        } else {
                            NameResolver.ConfigOrError serviceConfig = configParser.parseServiceConfig(this.mapConfigForServiceName());
                            this.listener.onResult(NameResolver.ResolutionResult.newBuilder().setAddresses(addresses).setServiceConfig(serviceConfig).build());
                        }
                    }
                    finally {
                        this.resolving = false;
                    }
                }
            }

            private boolean areServicesRemoved(List<ServiceInstance> instances) {
                for (ServiceInstance instance : instances) {
                    if (this.serviceInstanceIds.contains(instance.getId())) continue;
                    return true;
                }
                return false;
            }

            private Map<String, List<Map<String, Map<String, String>>>> mapConfigForServiceName() {
                return Map.of("loadBalancingConfig", List.of(Map.of("stork", Map.of("service-name", this.serviceName))));
            }
        };
    }
}

